package com.artenum.cassandra.internal;

import org.keridwen.vtk.service.VtkReadyService;

import com.artenum.cassandra.Cassandra;
import com.artenum.cassandra.CassandraService;

public class DefaultCassandraService implements CassandraService {
    /** Cassandra instance. */
    private Cassandra cassandra;
    /** VTK service injected dynamically by iPOJO. */
    private final VtkReadyService vtkService = null;

    public void start() {
        if (this.vtkService != null && this.vtkService.isVtkReady()) {
            try {
                this.cassandra = new Cassandra();
            } catch (final Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Cassandra getCassandra() {
        return this.cassandra;
    }

}
