/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald,
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it
 *  and/or modify it under the terms of the Q Public License;
 *  either version 1 of the License.
 *
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE. See the Q Public License for more details.
 *
 *  You should have received a copy of the Q Public License
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */
package com.artenum.cassandra.ui;

import com.artenum.cassandra.action.CassandraActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b> The Cassandra toolbar
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Sebastien Jourdain, jourdain@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Sebastien Jourdain
 * @version       0.1
 */
public class CassandraToolBar extends JToolBar {
    /**
	 * 
	 */
	private static final long serialVersionUID = 963022048039313712L;
	private JButton print;
    private JButton xy;
    private JButton yx;
    private JButton xz;
    private JButton zx;
    private JButton yz;
    private JButton zy;
    
    private JButton resetCamera;
    private JButton openButton;
    private JButton saveButton;
    
    private CassandraActionListener listener;
    
    private ImageIcon plusXicon;

    public CassandraToolBar(CassandraActionListener listener) {
        this.listener = listener;

        //
        openButton = new  JButton();
        openButton.setIcon(createImageIcon("/com/artenum/cassandra/ui/icons/icon_open-v2.png"));
        openButton.setActionCommand(CassandraActionListener.OPEN_VTK_FILE);
        openButton.addActionListener(listener);
        
        saveButton = new JButton();
        saveButton.setIcon(createImageIcon("/com/artenum/cassandra/ui/icons/icon_save-v2.png"));
        saveButton.setActionCommand(CassandraActionListener.SAVE_VTK_FILE);
        saveButton.addActionListener(listener);
        
        print = new JButton();
        print.setIcon(createImageIcon("/com/artenum/cassandra/ui/icons/icon_photo.png"));
        //print.setText("Save image");
        print.setActionCommand(CassandraActionListener.SAVE_VTK_VIEW);
        print.addActionListener(listener);
        
        xy = new JButton();
        xy.setIcon(createImageIcon("/com/artenum/cassandra/ui/icons/icon_plusZ.png"));
        xy.setActionCommand(CassandraActionListener.SET_VIEW_XY);
        xy.addActionListener(listener);
        
        yx = new JButton();
        yx.setIcon(createImageIcon("/com/artenum/cassandra/ui/icons/icon_minusZ.png"));
        yx.setActionCommand(CassandraActionListener.SET_VIEW_YX);
        yx.addActionListener(listener);
        
        xz = new JButton();
        xz.setIcon(createImageIcon("/com/artenum/cassandra/ui/icons/icon_plusY.png"));
        xz.setActionCommand(CassandraActionListener.SET_VIEW_XZ);
        xz.addActionListener(listener);
        
        zx = new JButton();
        zx.setIcon(createImageIcon("/com/artenum/cassandra/ui/icons/icon_minusY.png"));
        zx.setActionCommand(CassandraActionListener.SET_VIEW_ZX);
        zx.addActionListener(listener);
        
        yz = new JButton();
        plusXicon = createImageIcon("/com/artenum/cassandra/ui/icons/icon_plusX.png");
        yz.setIcon(plusXicon);
        yz.setActionCommand(CassandraActionListener.SET_VIEW_YZ);
        yz.addActionListener(listener);
        
        zy = new JButton();
        zy.setIcon(createImageIcon("/com/artenum/cassandra/ui/icons/icon_minusX.png"));
        zy.setActionCommand(CassandraActionListener.SET_VIEW_ZY);
        zy.addActionListener(listener);
        
        resetCamera = new JButton();
        resetCamera.setIcon(createImageIcon("/com/artenum/cassandra/ui/icons/icon_centre.png"));
        resetCamera.setActionCommand(CassandraActionListener.RESET_VIEW);
        resetCamera.addActionListener(listener);

        //
        add(openButton);
        add(saveButton);
        add(print);
        add(xy);
        add(yx);
        add(xz);
        add(zx);
        add(yz);
        add(zy);
        add(resetCamera);
    }
    
    /** Returns an ImageIcon, or null if the path was invalid. */
	protected ImageIcon createImageIcon(String path) {
		java.net.URL imgURL = this.getClass().getResource(path);
		if (imgURL != null) {
			return new ImageIcon(imgURL);
		} else {
			System.err.println("Couldn't find file: " + path);
			return null;
		}
	}
}
