package com.artenum.cassandra.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.util.CassandraToolBox;

public class ExportPipelineDialog  implements ActionListener {

    private PipeLineManager pipelineManager;

    private JFrame dialogFrame;
    private JPanel mainPane;
    private JTextField fileTextFile;
    private File selectedFile;
    private File scriptSavedDir;
    
    final static public String SELECT_FILE = "select.file";
    
    
    public ExportPipelineDialog(Frame parentFrame, PipeLineManager pipelineManager) {
        this.pipelineManager = pipelineManager;
        dialogFrame = new JFrame("Lookup Table control");
        
        mainPane = new JPanel();
        
        // Dialog box
        mainPane.setLayout(new BoxLayout(mainPane, BoxLayout.PAGE_AXIS));

        // file panel
        JPanel filePanel = new JPanel();
        filePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Output File"));
        JLabel fileLabel = new JLabel("Output file");
        fileTextFile = new JTextField("                                   ");
        fileTextFile.setSize(fileTextFile.getHeight(), 128);
        JButton selectFileButton = new JButton("Select");
        selectFileButton.setActionCommand(SELECT_FILE);
        selectFileButton.addActionListener(this);
        
        filePanel.add(fileLabel);
        filePanel.add(fileTextFile);
        filePanel.add(selectFileButton);
        filePanel.add(Box.createHorizontalGlue());

        

        // selection Panel
        JPanel selectionPanel = new JPanel();
        selectionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Exported Components"));

        mainPane.add(filePanel);
        mainPane.add(selectionPanel);
        mainPane.setPreferredSize(new Dimension(400, 500));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
      String actionCmd = evt.getActionCommand();
      if (actionCmd.equals(SELECT_FILE)){
          
          JFileChooser chooser = new JFileChooser();
          if (scriptSavedDir != null) {
              chooser.setCurrentDirectory(scriptSavedDir);
          }
          if(chooser.showSaveDialog(dialogFrame) == JFileChooser.APPROVE_OPTION){
              selectedFile = chooser.getSelectedFile();
              scriptSavedDir = selectedFile.getParentFile(); 
              try {
                fileTextFile.setText(selectedFile.getCanonicalPath());
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
          }
      }else{
          System.out.println(actionCmd);
      }
        
    }

    public int showMessageDialog() {
        
        Object[] options = {"Export","Cancel"};
        return(JOptionPane.showOptionDialog(dialogFrame, mainPane, "Export Pipeline", JOptionPane.YES_NO_OPTION,JOptionPane.PLAIN_MESSAGE,
                null,    
                options,  
                options[0])); 
    }
    
    public File getSelectedFile(){
        return(selectedFile);
    }
}
