package com.artenum.cassandra.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Frame;

import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

import vtk.vtkAlgorithm;

public class ThreadedProgressBarDialog extends Thread {

    vtkAlgorithm algorithm;
    double minProgressValue;
    double maxProgressValue;
    double progressValue;

    double nextTime;
    double samplingPeriod = 10.0;
    JLabel messageLabel;

    boolean cont = true;
    
    JPanel messagePanel;
    JProgressBar progressBar;
    
    double initTime;
    double endTime;
    
    JDialog dialogFrame;
    Thread controlThread;
    
    String message;
    
    public ThreadedProgressBarDialog() {
        nextTime = System.currentTimeMillis() + samplingPeriod;
        initTime = System.currentTimeMillis();
        endTime = initTime + 20 * 1000;
    }

    public ThreadedProgressBarDialog(vtkAlgorithm algorithm) {
        this.algorithm = algorithm;
        minProgressValue = this.algorithm.GetProgressMinValue();
        maxProgressValue = this.algorithm.GetProgressMaxValue();
        nextTime = System.currentTimeMillis() + samplingPeriod;
        initTime = System.currentTimeMillis();
        endTime = initTime + 20 * 1000;

    }
    
    public void setProgressMinValue(double min){
        minProgressValue = min;
    }
    
    public void setProgressMaxValue(double max){
        maxProgressValue = max;
    }
    
    public void showDialog(Frame owner, String message){
        
        dialogFrame = new JDialog(owner);
        dialogFrame.getContentPane().setLayout(new BorderLayout());
        
        messagePanel = new JPanel();
        messagePanel.setLayout(new BorderLayout());
        messageLabel = new JLabel("no message");
        messageLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        messagePanel.add(messageLabel, BorderLayout.CENTER);
        
        progressBar = new JProgressBar(0, 100);
        progressBar.setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 20, 10, 20));
        progressBar.setIndeterminate(true);
        
        dialogFrame.getContentPane().add(messagePanel, BorderLayout.CENTER);
        dialogFrame.getContentPane().add(progressBar, BorderLayout.SOUTH);
        
        dialogFrame.setSize(300, 150);
        dialogFrame.setLocationRelativeTo(null);
        dialogFrame.setVisible(true);
    }
    
    /**
     * Stop the thread and close to current dialog frame. 
     */
    public void close(){
        this.cont = false;
        dialogFrame.dispose();
    }
    
    
    public void setMessage(String message){
        this.message = message;
        messageLabel.setText(message);
    }
    
    public void setProgressValue(double progressValue){
        this.progressValue = progressValue;
    }
    
    public void run() {    
        
        while (cont) {
            if (System.currentTimeMillis() > nextTime) {
                nextTime = System.currentTimeMillis() + samplingPeriod;
            }
            messageLabel.setText(message);
            progressBar.setIndeterminate(false);
            progressBar.setValue( (int)(this.progressValue*(maxProgressValue-minProgressValue)*100.0)  );
            
            if ( progressValue == maxProgressValue){
                cont = false;
            }
        }
        close();
    }
}
