/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald,
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it
 *  and/or modify it under the terms of the Q Public License;
 *  either version 1 of the License.
 *
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE. See the Q Public License for more details.
 *
 *  You should have received a copy of the Q Public License
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */
package com.artenum.cassandra.ui.popup;

import com.artenum.cassandra.action.menu.RenameVtkObject;
import com.artenum.cassandra.pipeline.CascadeRemoveManager;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.util.VtkObjectInformationPane;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b> Dataset popup menu.
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Sebastien Jourdain, jourdain@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Sebastien Jourdain, Julien Forest, Benoit Thiebault, Jérémie Turbet
 * @version       0.2
 */
public class DataSetPopupMenu extends JPopupMenu implements ActionListener, VtkObjectPopupMenu {
    // Actions
    public final static String DATASET_REMOVE = "dataset.remove";
    public final static String DATASET_GET_INFO = "dataset.get.info";
    public final static String DATASET_SAVE = "dataset.save";
    
    private PipeLineManager pipeLineManager;
    private CascadeRemoveManager cascadeRemoveManager;
    private CassandraObject currentVtkObject;

    // UI components
    private RenameVtkObject datasetRename;
    private JMenuItem datasetRemove;
    private JMenuItem datasetGetInfo;
    private JMenuItem dataSetSave;

    /**
     * Define a popup menu for the current DataSet and make the link with the given 
     * pipeline manager and cascadeRemoveManager. 
     * 
     * This menu will allow the user to act on the selected data set. 
     * 
     * @param pipeLineManager
     * @param cascadeRemoveManager
     */
    public DataSetPopupMenu(PipeLineManager pipeLineManager, CascadeRemoveManager cascadeRemoveManager) {
        this.pipeLineManager = pipeLineManager;
        this.cascadeRemoveManager = cascadeRemoveManager;
        
        // Init popup ui
        
        // menu to rename the selected DataSet
        datasetRename = new RenameVtkObject("Rename", "Rename dataset", null);
        add(datasetRename);
        //addSeparator();   
        
        // menuItem to get information about the selected dataSet
        datasetGetInfo = new JMenuItem("Get information");
        datasetGetInfo.setActionCommand(DATASET_GET_INFO);
        datasetGetInfo.addActionListener(this);
        add(datasetGetInfo);
        addSeparator();
        
        // menuItem to save the selected dataSet
        //dataSetSave = new JMenuItem("Save DataSet");
        //dataSetSave.setActionCommand(DATASET_SAVE);
        //dataSetSave.addActionListener(this);
        //add(dataSetSave);
        //addSeparator();

        // menuItem 
        datasetRemove = new JMenuItem("Remove");
        datasetRemove.setActionCommand(DATASET_REMOVE);
        datasetRemove.addActionListener(this);
        add(datasetRemove);
    }

    
    public void setCurrentVtkOject(CassandraObject currentVtkObject) {
        this.currentVtkObject = currentVtkObject;
        datasetRename.setVtkObject(currentVtkObject);
    }

    public void actionPerformed(ActionEvent e) {
    	
        String command = e.getActionCommand();
        if (command.equals(DATASET_REMOVE)) {
            cascadeRemoveManager.removeDataSet(currentVtkObject);
            
        } else if ( command.equals(DATASET_GET_INFO)){     
        	VtkObjectInformationPane infoPane = new VtkObjectInformationPane(currentVtkObject);
        	infoPane.showMessageDialog();
        }
    }
}
