/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.util;

import com.artenum.cassandra.pipeline.PipeLineManager;

import vtk.vtkDataSet;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * @author Sebastien
 */
public class IsoLevelAnimation extends Thread {
    private vtkDataSet dataset;
    private ArrayList list;
    private boolean keepGoing = true;
    private PipeLineManager pipeLineManager;
    private int speed = 100;
    private double reduction = 0.25;
    private double stepSize;

    public IsoLevelAnimation(PipeLineManager pipeLineManager, vtkDataSet dataset, double levelA, double levelB, int nbStep, boolean normal, boolean register) {
        this.dataset = dataset;
        this.pipeLineManager = pipeLineManager;
        list = new ArrayList();
        IsoLevelPipeLine pipe;
        stepSize = (levelB - levelA) / ((double) nbStep);
        for (int i = 0; i < nbStep; i++) {
            pipe = new IsoLevelPipeLine(dataset, levelA + (i * stepSize), normal);
            if (register) {
                pipeLineManager.setActorVisible(pipeLineManager.addActor(pipe.getActor(), "Slice actor"), true);
            } else {
                pipeLineManager.getCassandraView().GetRenderer().AddActor(pipe.getActor());
            }

            list.add(pipe);
        }

        setPriority(Thread.MIN_PRIORITY);
    }

    public void run() {
        IsoLevelPipeLine currentPipe = null;
        IsoLevelPipeLine previousPipe = null;
        ArrayList tmpList = new ArrayList();
        while (keepGoing) {
            for (Iterator i = list.iterator(); i.hasNext();) {
                currentPipe = (IsoLevelPipeLine) i.next();
                tmpList.add(currentPipe);
                currentPipe.getActor().SetVisibility(1);
                if (previousPipe != null) {
                    previousPipe.getActor().SetVisibility(0);
                }

                previousPipe = currentPipe;
                pipeLineManager.getCassandraView().repaint();
                try {
                    sleep(speed);
                } catch (InterruptedException e) {
                    System.out.println("sleep error");
                }
            }
            while (!tmpList.isEmpty()) {
                currentPipe = (IsoLevelPipeLine) tmpList.remove(tmpList.size() - 1);
                currentPipe.getActor().SetVisibility(1);
                if (previousPipe != null) {
                    previousPipe.getActor().SetVisibility(0);
                }

                previousPipe = currentPipe;
                pipeLineManager.getCassandraView().repaint();
                try {
                    sleep(speed);
                } catch (InterruptedException e) {
                    System.out.println("sleep error");
                }
            }
        }
    }

    public void stopWorking() {
        keepGoing = false;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setReduction(double reduction) {
        this.reduction = reduction;
    }
}
