package com.artenum.cassandra.util;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import com.artenum.cassandra.pipeline.CassandraObject;

public class VtkObjectInformationPane {

	private JFrame infoFrame;
	private JTextArea textArea;
	private JScrollPane scrollPane;
	private JPanel mainPane;

	public VtkObjectInformationPane(CassandraObject currentVtkObject) {
		infoFrame = new JFrame();

		textArea = new JTextArea();
		textArea.setText(currentVtkObject.getVtkObject().toString());
		
		scrollPane = new JScrollPane();
		scrollPane.setViewportView(textArea);
		
		mainPane = new JPanel();
		mainPane.setLayout(new BorderLayout());
		mainPane.add(scrollPane, BorderLayout.CENTER);
		mainPane.setPreferredSize(new Dimension(400, 600));

	}

	public void showMessageDialog() {
		JOptionPane.showMessageDialog(infoFrame, mainPane);
	}
}
