/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Julien Forest / Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.plugin.cad;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.CassandraPluginIntegrator;
import com.artenum.cassandra.plugin.DynamicPluginMenu;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.util.CassandraToolBox;

import javax.swing.JMenuItem;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b>
 *             This class integrates all plugins contained
 *             in the jar file into Cassandra. Practically,
 *             this class adds all needed links items in
 *             the menus of the main Cassandra GUI.
 *             The instantiation itself is delegated to the
 *             action linked to your menu.
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Julien Forest, j.forest@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Julien Forest, Artenum SARL
 * @version       0.1
 */

public class PluginIntegrator implements CassandraPluginIntegrator {
    public PluginIntegrator() {}

    public void integratePluginsInFramework(PipeLineManager pipelineManager, PluginManager pluginManager, DynamicPluginMenu menu) {
        // Instantiate the graphical component to add in the default Cassandra GUI.
        JMenuItem pluginLaunch = new JMenuItem("Import STEP");

        // Add the graphical component in the Cassandra menu
        menu.addImportMenuComponent(pluginLaunch);

        // Add a listener to the menu for the Plugin instantiation 
        pluginLaunch.addActionListener(new InstanciationManager(pipelineManager, pluginManager, CassandraToolBox.getParentFrame(pluginLaunch)));
    }
}
