/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald,
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it
 *  and/or modify it under the terms of the Q Public License;
 *  either version 1 of the License.
 *
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE. See the Q Public License for more details.
 *
 *  You should have received a copy of the Q Public License
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */
package com.artenum.cassandra.plugin.cellcenter;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.VtkObjectListModel;
import com.artenum.cassandra.plugin.PlugInControlUI;

import vtk.vtkDataSet;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataListener;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 24/06/2010
 * <b>Modification          :</b>
 *
 * <b>Description  :</b> Control panel for the plugin.
 *
 *
 * @author        Julien Forest
 * @version       0.1
 */
public class CellCenterControlUI extends PlugInControlUI {
    private PipeLineManager pipeLineManager;
    private JFormattedTextField centerX;
    private JCheckBox cellVertexCheckBox;
    private JComboBox input;

    //
    private CellCenterPlugin plugin;

    /**
     * Defines the graphical interface of the control panel for the cutting plane plugin.
     * This method just defines the components and attach the action listener.
     * @param pipeLineManager
     * @param plugin
     */
    public CellCenterControlUI(PipeLineManager pipeLineManager, CellCenterPlugin plugin, Frame owner) {
        super(owner, "Cell Centers configuration panel");

        //
        this.pipeLineManager = pipeLineManager;
        this.plugin = plugin;

        cellVertexCheckBox = new JCheckBox("Vertex Cells");
        JPanel vertexControlPanel = new JPanel();
        vertexControlPanel.add(cellVertexCheckBox);

        //to select the input dataSet
        input = new JComboBox(new DataSetListModel(pipeLineManager.getDataSetList()));

        //define the "Update" button. The corresponding action name
        //is "UPDATE". The action itself is performed in the
        //actionPerformed method.
        JButton exec = new JButton("Update");
        exec.setActionCommand("UPDATE");
        exec.addActionListener(this);

        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener(this);

        //
        JPanel line1 = new JPanel();
        line1.setLayout(new BoxLayout(line1, BoxLayout.LINE_AXIS));
        line1.add(new JLabel("Input Dataset"));
        line1.add(input);

        //
        JPanel cmdLine = new JPanel();
        cmdLine.setLayout(new BoxLayout(cmdLine, BoxLayout.LINE_AXIS));
        cmdLine.add(Box.createHorizontalGlue());
        cmdLine.add(exec);
        cmdLine.add(cancel);

        //
        getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS));
        getContentPane().add(line1);
        getContentPane().add(vertexControlPanel);
        getContentPane().add(cmdLine);

        //getContentPane().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pack();
        Dimension size = getSize();
        size.setSize(size.getWidth() + 100, size.getHeight());
        setSize(size);
        setLocationRelativeTo(null);
    }

    /**
     * Perform the actions requested by the components (buttons, etc...)
     * of the control GUI of the plugin.
     * The actions are filtered on the keywords previously defined.
     * If needed and depending on the action, this method the relevant update method of the
     * plugin.
     */
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("UPDATE")) {
            if (input.getSelectedItem() == null) {
            	JOptionPane.showMessageDialog(new JFrame(),
            		    "Please select a valid input dataset.",
            		    "Input Filter Selection Error",
            		    JOptionPane.ERROR_MESSAGE);
                return;
            }

            //here update the cutting plan input data of the cutting plane plugin 
            int cellVertexFlag = 0;
            if (cellVertexCheckBox.isSelected()) {
                cellVertexFlag = 1;
            }

            plugin.updateCellCenter(cellVertexFlag, (vtkDataSet) ((CassandraObject) input.getSelectedItem()).getVtkObject());
            pipeLineManager.validateViewAndGo();
        }

        if (command.equals("CANCEL")) {
            this.dispose();
        }
    }

    /**
     *
     */
    public void stateChanged(ChangeEvent e) {
        //        double value = ((double) slider.getValue()) / 10;
        //        double cx = ((Number) centerX.getValue()).doubleValue();
        //        double cy = ((Number) centerY.getValue()).doubleValue();
        //        double cz = ((Number) centerZ.getValue()).doubleValue();
        //        double nx = ((Number) normalX.getValue()).doubleValue();
        //        double ny = ((Number) normalY.getValue()).doubleValue();
        //        double nz = ((Number) normalZ.getValue()).doubleValue();
        //        if (input.getSelectedItem() != null) {
        //            plugin.updateCellCenter(cx + (nx * value), cy + (ny * value), cz + (nz * value), nx, ny, nz,
        //                (vtkDataSet) ((VtkObject) input.getSelectedItem()).getVtkObject());
        //            pipeLineManager.validateViewAndGo();
        //        }
    }

    /**
     * Define the data model for the input combo box.
     */
    class DataSetListModel implements ComboBoxModel {
        private VtkObjectListModel datasetModel;
        private Object selectedItem;

        public DataSetListModel(VtkObjectListModel datasetModel) {
            this.datasetModel = datasetModel;
        }

        public Object getElementAt(int index) {
            return datasetModel.getElementAt(index);
        }

        public Object getSelectedItem() {
            return selectedItem;
        }

        public int getSize() {
            return datasetModel.getSize();
        }

        public void setSelectedItem(Object anItem) {
            selectedItem = anItem;
        }

        public void addListDataListener(ListDataListener l) {
            datasetModel.addListDataListener(l);
        }

        public void removeListDataListener(ListDataListener l) {
            datasetModel.removeListDataListener(l);
        }
    }

    public void itemStateChanged(ItemEvent arg0) {
        // TODO Auto-generated method stub
        
    }
}
