/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Julien Forest / Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.plugin.defaults;

import com.artenum.cassandra.pipeline.PipeLineManager;

import vtk.vtkIVExporter;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ExportToOpenInventor implements ActionListener {
    private PipeLineManager pipelineManager;
    private Frame owner;
    private vtkIVExporter exporter;

    public ExportToOpenInventor(PipeLineManager pipelineManager, Frame owner) {
        this.pipelineManager = pipelineManager;
        this.owner = owner;
        exporter = new vtkIVExporter();
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new FileFilter() {
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".obj");
                }

                public String getDescription() {
                    return "Open Inventor files";
                }
            });
        if (chooser.showSaveDialog(owner) == JFileChooser.APPROVE_OPTION) {
            String file = chooser.getSelectedFile().getAbsolutePath();
            try {
                if (!file.endsWith(".oiv")) {
                    file += ".oiv";
                }

                exporter.SetFileName(file);
                exporter.SetInput(pipelineManager.getCassandraView().GetRenderWindow());
                exporter.Update();
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(owner, "Unable to save: " + file);
            }
        }
    }
}
