/**
 * Project : Cassandra-Penelope Plufin
 * Copyright : (c) Artenum SARL, 24 rue Louis Blanc
 * 75010, Paris, France 2009-2010
 * http://www.artenum.com
 * All copyright and trademarks reserved.
 * Email : contact@artenum.com
 * Licence : cf. LICENSE.txt
 * Developed By : Artenum SARL
 * Authors : Sebastien Jourdain (jourdain@artenum.com)
 * Benoit thiebault (thiebault@artenum.com)
 * Jeremie Turbet (JeT) (turbet@artenum.com)
 * Julien Forest (j.forest@artenum.com)
 * Created : (JFreeMesh) 2009
 * Modified : 08 apr. 2011
 */
package com.artenum.cassandra.plugin.penelope;

import javax.swing.JMenuItem;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.CassandraPluginIntegrator;
import com.artenum.cassandra.plugin.DynamicPluginMenu;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.util.CassandraToolBox;

/**
 * Define a plug-in integrator for the Cassandra 3D viewer (see http://www.artenum.com/FR/Produits-Cassandra.html).
 * See the Cassandra's documentation for further information.
 * @author S. Jourdain, Artenum SARL.
 * @author J. Forest, Artenum SARL.
 */
public class PluginIntegrator implements CassandraPluginIntegrator {
	
	public PluginIntegrator(){}
	
	@Override
	public void integratePluginsInFramework( PipeLineManager pipelineManager, PluginManager pluginManager, DynamicPluginMenu menu ) {
		// Integrate the Msh import
		final JMenuItem loadMshFile = new JMenuItem( "Gmsh mesh file (msh)" );
		menu.addImportMenuComponent( loadMshFile );
		loadMshFile.addActionListener( new LoadMsh( pipelineManager, pluginManager, CassandraToolBox.getParentFrame( loadMshFile ) ) );
	}
}
