/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald,
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it
 *  and/or modify it under the terms of the Q Public License;
 *  either version 1 of the License.
 *
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE. See the Q Public License for more details.
 *
 *  You should have received a copy of the Q Public License
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */
package com.artenum.cassandra.plugin.threshold;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;

import vtk.vtkDataSet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b> Control panel for the plugin.
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Sebastien Jourdain, jourdain@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Sebastien Jourdain, ARTENUM SARL 
 * @author        Julien Forest, ARTENUM SARL 
 * 
 * @version       1.2
 */
public class ThresholdControlUI extends PlugInControlUI {
    // plugin data
    private PipeLineManager pipeLineManager;
    private ThresholdPlugin plugin;
    private VtkObjectComboBoxModel datasetModel;

    // plugin ui
    private JComboBox inputDataset;
    private JFormattedTextField lowerLevel;
    private JFormattedTextField upperLevel;
    private JRadioButton thresholdBetween;
    private JRadioButton thresholdByLower;
    private JRadioButton thresholdByUpper;

    public ThresholdControlUI(PipeLineManager pipeLineManager, ThresholdPlugin plugin, Frame owner) {
        super(owner, "Threshold configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = plugin;
        datasetModel = new VtkObjectComboBoxModel(pipeLineManager.getDataSetList(), plugin.getOutputDataSet());

        // Dialog box
        getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS));

        // Input dataset
        JPanel line = new JPanel(new BorderLayout());
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Input dataset"));
        inputDataset = new JComboBox(datasetModel);
        inputDataset.addActionListener(this);
        line.add(inputDataset, BorderLayout.CENTER);
        line.setMaximumSize(new Dimension(10000, inputDataset.getHeight()));
        getContentPane().add(line);

        // Vertical glue
        line = new JPanel(new BorderLayout());
        line.add(Box.createRigidArea(new Dimension(10, 10)), BorderLayout.NORTH);
        getContentPane().add(line);

        // Range
        line = new JPanel(new GridLayout(2, 2));
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Levels"));
        lowerLevel = new JFormattedTextField("0");
        lowerLevel.setValue(new Double(-1));
        upperLevel = new JFormattedTextField("0");
        upperLevel.setValue(new Double(1));
        line.add(new JLabel("Lower level"));
        line.add(new JLabel("Upper level"));
        line.add(lowerLevel);
        line.add(upperLevel);
        getContentPane().add(line);

        // Vertical glue
        line = new JPanel(new BorderLayout());
        line.add(Box.createRigidArea(new Dimension(10, 10)), BorderLayout.NORTH);
        getContentPane().add(line);

        // Threshold type
        line = new JPanel(new GridLayout(3, 1));
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Threshold type"));
        ButtonGroup group = new ButtonGroup();
        thresholdBetween = new JRadioButton("Threshold between", true);
        thresholdByLower = new JRadioButton("Threshold by lower", false);
        thresholdByUpper = new JRadioButton("Threshold by upper", false);
        group.add(thresholdBetween);
        group.add(thresholdByLower);
        group.add(thresholdByUpper);
        line.add(thresholdBetween);
        line.add(thresholdByLower);
        line.add(thresholdByUpper);
        getContentPane().add(line);

        // Vertical glue
        line = new JPanel(new BorderLayout());
        line.add(Box.createRigidArea(new Dimension(10, 10)), BorderLayout.NORTH);
        getContentPane().add(line);

        // cmd line
        line = new JPanel();
        JButton update = new JButton("Update");
        update.setActionCommand("UPDATE");
        update.addActionListener(this);
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener(this);
        line.setLayout(new BoxLayout(line, BoxLayout.LINE_AXIS));
        line.add(Box.createHorizontalGlue());
        line.add(update);
        line.add(cancel);
        getContentPane().add(line);

        pack();
        Dimension d = getSize();
        setSize(300, d.height);
        setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        int levelFlag = 0;
        if (command.equals("UPDATE")) {
            if (inputDataset.getSelectedItem() != null) {
                int thresholdType = 0;
                if (thresholdBetween.isSelected()) {
                    thresholdType = ThresholdPlugin.THRESHOLD_BETWEEN;
                }

                if (thresholdByLower.isSelected()) {
                    thresholdType = ThresholdPlugin.THRESHOLD_LOWER;
                }

                if (thresholdByUpper.isSelected()) {
                    thresholdType = ThresholdPlugin.THRESHOLD_UPPER;
                }

                plugin.updateThreshold((vtkDataSet) ((CassandraObject) datasetModel.getSelectedItem()).getVtkObject(), thresholdType,
                    ((Number) lowerLevel.getValue()).doubleValue(), ((Number) upperLevel.getValue()).doubleValue());
                pipeLineManager.validateViewAndGo();
            } else {
            	JOptionPane.showMessageDialog(new JFrame(),
            		    "Please select a valid input dataset.",
            		    "Input Filter Selection Error",
            		    JOptionPane.ERROR_MESSAGE);
            	return;
            }
        } else if (command.equals("CANCEL")) {
            this.dispose();
        } else if (datasetModel.getSelectedItem() != null) {
            // New input selection
            double[] range = ((vtkDataSet) ((CassandraObject) datasetModel.getSelectedItem()).getVtkObject()).GetScalarRange();
            if (range != null) {
                lowerLevel.setValue(new Double(range[0]));
                upperLevel.setValue(new Double(range[1]));
            }
        }
    }

    public void stateChanged(ChangeEvent arg0) {
        // TODO Auto-generated method stub
        
    }

    public void itemStateChanged(ItemEvent arg0) {
        // TODO Auto-generated method stub
        
    }
}
