/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald,
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it
 *  and/or modify it under the terms of the Q Public License;
 *  either version 1 of the License.
 *
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE. See the Q Public License for more details.
 *
 *  You should have received a copy of the Q Public License
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */
package com.artenum.cassandra.renderer.vtk;

import vtk.vtkCellPicker;
import vtk.vtkPointPicker;

/**
 * Generic interface for 3D picking. 
 * 
 * @author Artenum SARL. 
 *
 */
public interface PickingObserver {
	
	/**
	 * Pick action for points;
	 * @param picker
	 */
    void pickPoint(vtkPointPicker pointPicker);
    
    /**
     * Pick action for cells;
     * @param cellPicker
     */
    void pickCell(vtkCellPicker cellPicker);
    
}
