/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.gmsh.field;

import com.artenum.penelope.field.DataFieldManager;
import com.artenum.penelope.field.interfaces.DataField;
import com.artenum.penelope.field.io.DataFieldExportException;
import com.artenum.penelope.field.io.DataFieldExporter;
import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.MeshMask;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.plugin.gmsh.mesh.GMSHFilePart22;
import com.artenum.penelope.plugin.gmsh.mesh.GeometryIdMapper;
import com.artenum.penelope.plugin.gmsh.mesh.GmshExporter22;
import com.artenum.penelope.plugin.gmsh.mesh.GmshMeshMapping;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class GmshDataFieldExporter
extends GmshExporter22
implements DataFieldExporter {
    private static final String NEWLINE = System.getProperty("line.separator");
    DataFieldManager dataset = null;
    int nodeIdShift = 1;
    int elmIdShit = 1;
    boolean exportEdges = false;
    boolean exportSurfaces = false;
    boolean exportVolumes = false;

    public GmshDataFieldExporter(Mesh mesh, GmshMeshMapping meshBuilder, String filePath, DataFieldManager dataset) {
        super(mesh, meshBuilder, filePath);
        this.dataset = dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportAll() throws IOException {
        if (this.dataset == null) {
            System.out.println("Error: impossible to export, dataSet not defined or null");
        }
        if (super.getFilePath() == null) {
            System.out.println("Error: impossible to export, output file not defined or null");
        }
        BufferedWriter fw = null;
        try {
            fw = new BufferedWriter(new FileWriter(super.getFilePath()));
            this.writeAll(fw);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    protected void writeAll(BufferedWriter fw) throws IOException {
        this.exportHeader(fw);
        this.exportNodes(fw);
        this.exportMeshElements(fw, false);
        for (DataField df : this.dataset.getDataFields()) {
            System.out.println("Adding MeshElement for DataField: " + df.getName());
        }
        fw.write("$EndElements\n");
        for (DataField df : this.dataset.getDataFields()) {
            GeometryIdMapper idMapper;
            int penelopeId;
            int i;
            System.out.println("Exporting DataField: " + df.getName());
            System.out.println(".... exported");
            MeshMask mf = df.getMeshMask();
            if (df.getMeshType() == MeshType.VERTEX) {
                System.out.println("DataField localised on nodes");
                fw.write(GMSHFilePart22.ELEMENT_NODE_DATA_SECTION.getStartTag() + NEWLINE);
                fw.write("1\n");
                fw.write("\"" + df.getName() + "\"");
                fw.write("\n0\n3\n0\n1\n");
                fw.write(mf.getNbMeshElements() + NEWLINE);
                for (i = 0; i < mf.getNbMeshElements(); ++i) {
                    penelopeId = mf.getMeshElementIds()[i];
                    idMapper = super.getMeshBuilder().getIdMapper();
                    fw.write(Integer.toString(idMapper.getGmshVertexId(penelopeId)));
                    fw.write(" " + df.getDataArray().get(i));
                    fw.newLine();
                }
                fw.write(GMSHFilePart22.ELEMENT_NODE_DATA_SECTION.getEndTag() + NEWLINE);
                continue;
            }
            System.out.println("DataField localised on MeshElements");
            fw.write(GMSHFilePart22.ELEMENT_DATA_SECTION.getStartTag() + NEWLINE);
            fw.write("1\n");
            fw.write("\"" + df.getName() + "\"");
            fw.write("\n0\n3\n0\n1\n");
            fw.write(mf.getNbMeshElements() + NEWLINE);
            for (i = 0; i < mf.getNbMeshElements(); ++i) {
                penelopeId = mf.getMeshElementIds()[i];
                idMapper = super.getMeshBuilder().getIdMapper();
                Integer gmshId = null;
                MeshType meshType = mf.getMeshType();
                if (meshType == MeshType.VERTEX) {
                    gmshId = idMapper.getGmshVertexId(penelopeId);
                } else if (meshType == MeshType.EDGE) {
                    gmshId = idMapper.getGmshEdgeId(penelopeId);
                } else if (meshType == MeshType.FACE) {
                    Vertex[] penelopeVertices;
                    System.out.println("penelope id for face : " + penelopeId);
                    Face faceById = super.getMesh().getFaceById(penelopeId);
                    for (Vertex vertex : penelopeVertices = faceById.getVertices()) {
                        int gmshId3 = idMapper.getGmshVertexId(vertex.getId());
                        System.out.println("penelope id : " + vertex.getId() + "\ngmshid : " + gmshId3);
                    }
                    System.out.println(faceById);
                    gmshId = idMapper.getGmshFaceId(penelopeId);
                } else if (meshType == MeshType.POLYHEDRON) {
                    gmshId = idMapper.getGmshPolyhedronId(penelopeId);
                }
                if (gmshId == null) {
                    throw new UnsupportedOperationException("Computes of gmsh id from penelope id was not found. The penelope id is : " + penelopeId + ", and the type of mesh field is : " + meshType);
                }
                System.out.println("export penelope id : " + penelopeId);
                System.out.println("export gmsh id : " + gmshId);
                fw.write(Integer.toString(gmshId));
                fw.write(" " + df.getDataArray().get(i));
                fw.newLine();
            }
            fw.write(GMSHFilePart22.ELEMENT_DATA_SECTION.getEndTag() + NEWLINE);
        }
    }

    public void setExportType(MeshType type, Boolean isToExport) throws DataFieldExportException {
        if (type == MeshType.EDGE) {
            this.exportEdges = isToExport;
            return;
        }
        if (type == MeshType.FACE) {
            this.exportSurfaces = isToExport;
            return;
        }
        if (type == MeshType.POLYHEDRON) {
            this.exportVolumes = isToExport;
            return;
        }
        throw new DataFieldExportException("Invalid GeometryLocalisation type");
    }

    public void setNodeIdShift(int shift) {
        this.nodeIdShift = shift;
    }

    public void setOutputFile(File file) throws DataFieldExportException {
    }
}

