/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.gmsh.geo.io;

import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.Vertex;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MeshToGeoExporter {
    private String filePath;
    private final Mesh mesh;
    private int nodeIdShift = 1;
    private final int edgeIdShift = 1;
    private final int lineLoopIdShift = 1;
    private int faceIdShift = 1;

    public MeshToGeoExporter() {
        this(null);
    }

    public MeshToGeoExporter(Mesh mesh) {
        this(mesh, null);
    }

    public MeshToGeoExporter(Mesh mesh, String filePath) {
        this.mesh = mesh;
        this.filePath = filePath;
    }

    public void setOutputFile(String filePath) {
        this.filePath = filePath;
    }

    public void setNodeIdShift(int shift) {
        this.nodeIdShift = shift;
    }

    public void setSurfaceIdShift(int shift) {
        this.faceIdShift = shift;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportAll() throws IOException {
        int lineLoopId = 0;
        int faceId = 0;
        ArrayList<Integer> doublonList = new ArrayList<Integer>();
        ArrayList<Integer> startPointList = new ArrayList<Integer>();
        Face face = null;
        int meshElementId = 0;
        int startNodeId = 0;
        int endNodeId = 0;
        int tmpEdgeId = 0;
        Edge[] edgeList = null;
        BufferedWriter fw = null;
        try {
            fw = new BufferedWriter(new FileWriter(this.filePath));
            fw.write("res = 1.0;\n");
            List nodeElementIterator = this.mesh.getVertices();
            for (Vertex vertex : nodeElementIterator) {
                fw.write("Point(");
                fw.write(Integer.toString(vertex.getId() + this.nodeIdShift));
                fw.write(") = {");
                fw.write(Double.toString(vertex.getPoint().getCoord()[0]));
                fw.write(", ");
                fw.write(Double.toString(vertex.getPoint().getCoord()[1]));
                fw.write(", ");
                fw.write(Double.toString(vertex.getPoint().getCoord()[2]));
                fw.write(", res");
                fw.write("}; \n");
            }
            Iterator faceIterator = this.mesh.getFaceIterator();
            while (faceIterator.hasNext()) {
                face = (Face)faceIterator.next();
                meshElementId = face.getId();
                edgeList = face.getEdges();
                int n = face.getId();
                this.getClass();
                lineLoopId = n + 1;
                String tmpCurveLoop = "Line Loop(" + lineLoopId + ") = {";
                for (Edge edge : edgeList) {
                    startNodeId = edge.getVertexAt(0).getId() + this.nodeIdShift;
                    endNodeId = edge.getVertexAt(1).getId() + this.nodeIdShift;
                    int n2 = edge.getId();
                    this.getClass();
                    if (!doublonList.contains(n2 + 1)) {
                        StringBuilder stringBuilder = new StringBuilder().append("Line(");
                        int n3 = edge.getId();
                        this.getClass();
                        fw.write(stringBuilder.append(Integer.toString(n3 + 1)).append(") = {").append(startNodeId).append(", ").append(endNodeId).append("}; \n").toString());
                        int n4 = edge.getId();
                        this.getClass();
                        doublonList.add(n4 + 1);
                        startPointList.add(startNodeId);
                        int n5 = edge.getId();
                        this.getClass();
                        tmpEdgeId = n5 + 1;
                    } else {
                        int n6 = edge.getId();
                        this.getClass();
                        if (startNodeId != (Integer)startPointList.get(doublonList.indexOf(n6 + 1))) {
                            int n7 = edge.getId();
                            this.getClass();
                            tmpEdgeId = -(n7 + 1);
                        } else {
                            int n8 = edge.getId();
                            this.getClass();
                            tmpEdgeId = n8 + 1;
                        }
                    }
                    tmpCurveLoop = tmpCurveLoop + tmpEdgeId + ", ";
                }
                tmpCurveLoop = tmpCurveLoop.subSequence(0, tmpCurveLoop.length() - 2) + "};";
                fw.write(tmpCurveLoop + "\n");
                faceId = face.getId() + this.faceIdShift;
                fw.write("Plane Surface(" + faceId + ") = {" + lineLoopId + "}; \n");
            }
            boolean volumeId = true;
            Iterator faceOnGrpIter = this.mesh.getFaceIterator();
            Face faceOnGrp = null;
            String tmpSurfaceLoop = "Surface Loop(1) = {";
            while (faceOnGrpIter.hasNext()) {
                faceOnGrp = (Face)faceOnGrpIter.next();
                faceId = faceOnGrp.getId() + this.faceIdShift;
                tmpSurfaceLoop = tmpSurfaceLoop + faceId + ", ";
            }
            tmpSurfaceLoop = tmpSurfaceLoop.subSequence(0, tmpSurfaceLoop.length() - 2) + "};";
            fw.write(tmpSurfaceLoop + "\n");
            fw.write("Volume(1) = {1};");
        }
        finally {
            fw.close();
        }
    }
}

