/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.gmsh.mesh;

import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.MeshMask;
import com.artenum.penelope.mesh.interfaces.Polyhedron;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.plugin.gmsh.mesh.GeometryIdMapper;
import com.artenum.penelope.plugin.gmsh.mesh.GmshMeshMapping;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GmshExporter10 {
    private final String filePath;
    private final GmshMeshMapping meshBuilder;
    private final Mesh mesh;
    private boolean ignoreMeshGroups = false;

    public GmshExporter10(Mesh mesh, GmshMeshMapping meshBuilder, String filePath) {
        this.meshBuilder = meshBuilder;
        this.mesh = mesh;
        this.filePath = filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportAll() throws IOException {
        GeometryIdMapper idMapper = this.meshBuilder.getIdMapper();
        BufferedWriter fw = null;
        try {
            FileWriter out = new FileWriter(this.filePath);
            fw = new BufferedWriter(out);
            this.exportNodes(idMapper, fw);
            this.exportMeshElement(idMapper, fw);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    private void exportMeshElement(GeometryIdMapper idMapper, BufferedWriter fw) throws IOException {
        Vertex localVertex;
        int nbMeshElement;
        int gmshId;
        int penelopeId;
        int elmMeshGroupList;
        fw.write("$ELM\n");
        Map<Integer, Integer> edgeIdMap = idMapper.getEdgeIdMap();
        int edgeCount = 0;
        for (Integer edgeId : edgeIdMap.values()) {
            List edgeMeshMasksForEdgeId = this.mesh.getDataFieldManager().getEdgeMeshMasksForEdgeId(edgeId.intValue());
            edgeCount += edgeMeshMasksForEdgeId.size();
        }
        Map<Integer, Integer> faceIdMap = idMapper.getFaceIdMap();
        int faceCount = 0;
        for (Integer faceId : faceIdMap.values()) {
            List faceMeshMasksForFaceId = this.mesh.getDataFieldManager().getFaceMeshMasksForFaceId(faceId.intValue());
            faceCount += faceMeshMasksForFaceId.size();
        }
        int polyhedronCount = 0;
        List polyhedronIteratorTmp = this.mesh.getPolyhedronList();
        for (Polyhedron polyhedron : polyhedronIteratorTmp) {
            List polyhedronMeshMasksForPolyhedronId = this.mesh.getDataFieldManager().getPolyhedronMeshMasksForPolyhedronId(polyhedron.getId());
            polyhedronCount += polyhedronMeshMasksForPolyhedronId.size();
        }
        int point15Count = 0;
        List<Vertex> vertexIteratorTmp = this.meshBuilder.getPoint15List();
        for (Vertex vertex : vertexIteratorTmp) {
            List vertexMeshMasksForVertexId = this.mesh.getDataFieldManager().getVertexMeshMasksForVertexId(vertex.getId());
            point15Count += vertexMeshMasksForVertexId.size();
        }
        int nbMeshElements = point15Count + edgeCount + faceCount + polyhedronCount;
        fw.write(Integer.toString(nbMeshElements));
        fw.write("\n");
        List<Vertex> vertexIterator = this.meshBuilder.getPoint15List();
        for (Vertex vertex : vertexIterator) {
            int meshElementType = 15;
            Integer nbVerticesOnMeshElement = new Integer(1);
            elmMeshGroupList = this.ignoreMeshGroups ? 1 : this.mesh.getDataFieldManager().getVertexMeshMasksForVertexId(vertex.getId()).size();
            for (int i = 0; i < elmMeshGroupList; ++i) {
                Integer penelopeVertexId = vertex.getId();
                Integer gmshVertexId = idMapper.getGmshVertexId(penelopeVertexId);
                fw.write(Integer.toString(gmshVertexId));
                fw.write(" ");
                fw.write(Integer.toString(15));
                fw.write(" ");
                fw.write(Integer.toString(((MeshMask)this.mesh.getDataFieldManager().getVertexMeshMasksForVertexId(vertex.getId()).get(i)).getId()));
                fw.write(" ");
                fw.write("1");
                fw.write(" ");
                fw.write(Integer.toString(nbVerticesOnMeshElement));
                fw.write(" ");
                for (int j = 0; j < nbVerticesOnMeshElement; ++j) {
                    penelopeId = vertex.getId();
                    gmshId = idMapper.getGmshVertexId(penelopeId);
                    fw.write(Integer.toString(gmshId));
                    fw.write(" ");
                }
                fw.write("\n");
            }
        }
        Integer meshElementType = 1;
        for (Integer penelopeEdgeId : edgeIdMap.values()) {
            Edge edge = this.mesh.getEdgeById(penelopeEdgeId.intValue());
            elmMeshGroupList = this.ignoreMeshGroups ? 1 : this.mesh.getDataFieldManager().getEdgeMeshMasksForEdgeId(penelopeEdgeId.intValue()).size();
            for (int i = 0; i < elmMeshGroupList; ++i) {
                Integer gmshEdgeId = idMapper.getGmshEdgeId(penelopeEdgeId);
                fw.write(Integer.toString(gmshEdgeId));
                fw.write(" ");
                fw.write(Integer.toString(meshElementType));
                fw.write(" ");
                fw.write(Integer.toString(((MeshMask)this.mesh.getDataFieldManager().getEdgeMeshMasksForEdgeId(edge.getId()).get(i)).getId()));
                fw.write(" ");
                fw.write("1");
                fw.write(" ");
                nbMeshElement = edge.getNbVertices();
                fw.write(Integer.toString(nbMeshElement));
                fw.write(" ");
                for (int j = 0; j < nbMeshElement; ++j) {
                    localVertex = edge.getVertexAt(j);
                    penelopeId = localVertex.getId();
                    gmshId = idMapper.getGmshVertexId(penelopeId);
                    fw.write(Integer.toString(gmshId));
                    fw.write(" ");
                }
                fw.write("\n");
            }
        }
        meshElementType = 2;
        for (Integer penelopeFaceId : faceIdMap.values()) {
            Face face = this.mesh.getFaceById(penelopeFaceId.intValue());
            elmMeshGroupList = this.ignoreMeshGroups ? 1 : this.mesh.getDataFieldManager().getFaceMeshMasksForFaceId(face.getId()).size();
            for (int i = 0; i < elmMeshGroupList; ++i) {
                Integer gmshFaceId = idMapper.getGmshFaceId(penelopeFaceId);
                fw.write(Integer.toString(gmshFaceId));
                fw.write(" ");
                fw.write(Integer.toString(meshElementType));
                fw.write(" ");
                fw.write(Integer.toString(((MeshMask)this.mesh.getDataFieldManager().getFaceMeshMasksForFaceId(face.getId()).get(i)).getId()));
                fw.write(" ");
                fw.write("1");
                fw.write(" ");
                nbMeshElement = face.getNbVertices();
                fw.write(Integer.toString(nbMeshElement));
                fw.write(" ");
                for (int j = 0; j < nbMeshElement; ++j) {
                    localVertex = face.getVertexAt(j);
                    penelopeId = localVertex.getId();
                    gmshId = idMapper.getGmshVertexId(penelopeId);
                    fw.write(Integer.toString(gmshId));
                    fw.write(" ");
                }
                fw.write("\n");
            }
        }
        meshElementType = 4;
        for (Polyhedron polyhedron : this.mesh.getPolyhedronList()) {
            elmMeshGroupList = this.ignoreMeshGroups ? 1 : this.mesh.getDataFieldManager().getPolyhedronMeshMasksForPolyhedronId(polyhedron.getId()).size();
            for (int i = 0; i < elmMeshGroupList; ++i) {
                Integer penelopePolyhedronId = polyhedron.getId();
                Integer gmshPolyhedronId = idMapper.getGmshPolyhedronId(penelopePolyhedronId);
                fw.write(Integer.toString(gmshPolyhedronId));
                fw.write(" ");
                fw.write(Integer.toString(meshElementType));
                fw.write(" ");
                fw.write(Integer.toString(((MeshMask)this.mesh.getDataFieldManager().getPolyhedronMeshMasksForPolyhedronId(polyhedron.getId()).get(i)).getId()));
                fw.write(" ");
                fw.write("1");
                fw.write(" ");
                nbMeshElement = polyhedron.getNbVertices();
                fw.write(Integer.toString(nbMeshElement));
                fw.write(" ");
                for (int j = 0; j < nbMeshElement; ++j) {
                    localVertex = polyhedron.getVertexAt(j);
                    penelopeId = localVertex.getId();
                    gmshId = idMapper.getGmshVertexId(penelopeId);
                    fw.write(Integer.toString(gmshId));
                    fw.write(" ");
                }
                fw.write("\n");
            }
        }
        fw.write("$ENDELM\n");
    }

    private void exportNodes(GeometryIdMapper idMapper, BufferedWriter fw) throws IOException {
        fw.write("$NOD\n");
        fw.write(Integer.toString(this.mesh.getNbVertices()));
        fw.write("\n");
        Iterator nodeElementIterator = this.mesh.getVertexIterator();
        Vertex nodeElement = null;
        while (nodeElementIterator.hasNext()) {
            nodeElement = (Vertex)nodeElementIterator.next();
            int penelopeId = nodeElement.getId();
            Integer gmshNodeId = idMapper.getGmshVertexId(penelopeId);
            fw.write(Integer.toString(gmshNodeId));
            fw.write(" ");
            fw.write(Double.toString(nodeElement.getPoint().getCoord()[0]));
            fw.write(" ");
            fw.write(Double.toString(nodeElement.getPoint().getCoord()[1]));
            fw.write(" ");
            fw.write(Double.toString(nodeElement.getPoint().getCoord()[2]));
            fw.write("\n");
        }
        fw.write("$ENDNOD\n");
    }

    public boolean isIgnoreMeshGroups() {
        return this.ignoreMeshGroups;
    }

    public void setIgnoreMeshGroups(boolean ignoreMeshGroups) {
        this.ignoreMeshGroups = ignoreMeshGroups;
    }
}

