/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.probingline;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.pipeline.graph.VtkObjectCellAdapter;
import com.artenum.cassandra.plugin.CassandraPlugInProperty;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.SimplePlugInProperty;
import com.artenum.cassandra.plugin.probingline.Plot2D;
import com.artenum.cassandra.plugin.probingline.ProbingLineControlUI;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import vtk.vtkActor;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkDataSetMapper;
import vtk.vtkLineSource;
import vtk.vtkLineWidget;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkObject;
import vtk.vtkProbeFilter;
import vtk.vtkRenderWindowInteractor;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;

public class ProbingLinePlugin
implements CassandraPlugin,
RemoveListener {
    private String name;
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private ProbingLineControlUI controlUI;
    private int nbUpdate = 0;
    private double[] startPt;
    private double[] endPt;
    private int resol = 128;
    private ArrayList x;
    private ArrayList y;
    private Plot2D plot;
    private JDialog plotDialog;
    private vtkLineSource line;
    private vtkDataSetMapper lineMapper;
    private vtkActor lineActor;
    private vtkProbeFilter probe;
    private vtkDataSet lastDataSet;
    private vtkLookupTable outputLookupTable;
    private vtkScalarBarActor outputScalarBar;
    private CassandraObject outputCassDataset;
    private CassandraObject cassFilter;
    private CassandraObject outputCassMapper;
    private CassandraObject outputCassActor;
    private CassandraObject outputCassLookupTable;
    private CassandraObject outputCassScalarBar;
    private Filter filterImpl;
    private vtkLineWidget lineWidget;
    Frame owner;
    public static final String PERSISTENCE_KEY_INPUT_DATASET = "persistence.key.inputVtkDataSet";
    public static final String PERSISTENCE_KEY_INOUT = "persistence.key.insideOut";
    public static final String PERSISTENCE_KEY_OUPUT_DATASET = "persistence.key.outputDataSet";
    public static final String PERSISTENCE_KEY_OUPUT_MAPPER = "persistence.key.outputMapper";
    public static final String PERSISTENCE_KEY_OUPUT_LOOKUP_TABLE = "persistence.key.outputlookUpTable";
    public static final String PERSISTENCE_KEY_OUTPUT_ACTOR = "persistence.key.outputActor";
    public static final String PERSISTENCE_KEY_OUTPUT_SCALAR_BAR = "persistence.key.ouputScalarBar";
    public static final String PERSISTENCE_KEY_CELL_POS_X = "persistence.key.cell.PosX";
    public static final String PERSISTENCE_KEY_CELL_POS_Y = "persistence.key.cell.PosY";
    public static final String PERSISTENCE_KEY_START_POINT_X = "persistence.key.start.point.x";
    public static final String PERSISTENCE_KEY_START_POINT_Y = "persistence.key.start.point.y";
    public static final String PERSISTENCE_KEY_START_POINT_Z = "persistence.key.start.point.z";
    public static final String PERSISTENCE_KEY_END_POINT_X = "persistence.key.end.point.x";
    public static final String PERSISTENCE_KEY_END_POINT_Y = "persistence.key.end.point.y";
    public static final String PERSISTENCE_KEY_END_POINT_Z = "persistence.key.end.point.z";
    public static final String PERSISTENCE_KEY_PROBE_RESOLUTION = "persistence.key.probe.resolution";

    public ProbingLinePlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this.initPlugIn(pipelineManager, pluginManager, owner);
        this.initPipeline();
    }

    public ProbingLinePlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner, boolean initPipeline) {
        this.initPlugIn(pipelineManager, pluginManager, owner);
        if (initPipeline) {
            this.initPipeline();
        }
    }

    public ProbingLinePlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner, int initPipeline) {
        this.initPlugIn(pipelineManager, pluginManager, owner);
        if (initPipeline == 1) {
            this.initPipeline();
        }
    }

    public void initPlugIn(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this.owner = owner;
        this.name = "Probing Line";
        this.filterImpl = new FilterImpl();
        this.filterImpl.addRemoveListener((RemoveListener)this);
        this.filterImpl.setParentPlugin((CassandraPlugin)this);
        this.pipelineManager = pipelineManager;
        this.pluginManager = pluginManager;
        this.controlUI = new ProbingLineControlUI(pipelineManager, this, owner);
        this.contextualMenu = new JPopupMenu("Probing line menu");
        JMenuItem showControl = new JMenuItem("Show control");
        showControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProbingLinePlugin.this.controlUI.setVisible(true);
                ProbingLinePlugin.this.controlUI.update3DWidgetStatus();
            }
        });
        this.contextualMenu.add(showControl);
        this.contextualMenu.addSeparator();
        JMenuItem remove = new JMenuItem("Remove");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProbingLinePlugin.this.remove();
            }
        });
        this.contextualMenu.add(remove);
    }

    public void initPipeline() {
        this.startPt = new double[3];
        this.startPt[0] = 0.0;
        this.startPt[1] = 0.0;
        this.startPt[2] = 0.0;
        this.endPt = new double[3];
        this.endPt[0] = 10.0;
        this.endPt[1] = 10.0;
        this.endPt[2] = 10.0;
        if (this.line == null) {
            this.line = new vtkLineSource();
            System.out.println("line: new component");
        }
        this.line.SetPoint1(this.startPt[0], this.startPt[1], this.startPt[2]);
        this.line.SetPoint2(this.endPt[0], this.endPt[1], this.endPt[2]);
        this.line.SetResolution(this.resol);
        if (this.probe == null) {
            this.probe = new vtkProbeFilter();
            this.probe.SetInput((vtkDataSet)this.line.GetOutput());
            this.outputCassDataset = this.pipelineManager.addDataSet((Object)this.probe.GetOutput(), "Probe Output");
        } else {
            this.outputCassDataset = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.probe);
        }
        if (this.lineMapper == null) {
            this.lineMapper = new vtkDataSetMapper();
            this.outputCassMapper = this.pipelineManager.addMapper((Object)this.lineMapper, "Probe Mapper");
        } else {
            this.outputCassMapper = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.lineMapper);
        }
        this.lineMapper.SetInput(this.probe.GetOutput());
        if (this.lineActor == null) {
            this.lineActor = new vtkActor();
            this.outputCassActor = this.pipelineManager.addActor((Object)this.lineActor, "Probe");
            System.out.println("actor: new component");
        } else {
            this.outputCassActor = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.lineActor);
        }
        this.lineActor.SetMapper((vtkMapper)this.lineMapper);
        if (this.outputLookupTable == null) {
            this.outputLookupTable = new vtkLookupTable();
            this.outputCassLookupTable = this.pipelineManager.addLookupTable(this.outputLookupTable, "Clipping plane");
        } else {
            this.outputCassLookupTable = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.outputLookupTable);
        }
        this.outputLookupTable.SetHueRange(0.66667, 0.0);
        this.outputLookupTable.Build();
        this.lineMapper.SetLookupTable((vtkScalarsToColors)this.outputLookupTable);
        if (this.outputScalarBar == null) {
            this.outputScalarBar = new vtkScalarBarActor();
            this.outputCassScalarBar = this.pipelineManager.addScalarBar(this.outputScalarBar, "Clipping plane");
        } else {
            this.outputCassScalarBar = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.outputScalarBar);
        }
        this.outputScalarBar.SetLookupTable((vtkScalarsToColors)this.outputLookupTable);
        this.cassFilter = this.pipelineManager.addFilter(this.filterImpl, "Prober");
        this.cassFilter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
        this.plotDialog = new JDialog(this.owner, "Probed data");
        this.x = new ArrayList();
        this.y = new ArrayList();
        this.plot = new Plot2D(this.x, this.y, "The value", "Probe", "Probe");
        this.plotDialog.getContentPane().add((Component)this.plot.getChartPanel());
        this.plotDialog.setSize(512, 300);
        this.plotDialog.setLocationRelativeTo(null);
        if (this.lineWidget != null) {
            this.lineWidget.SetPoint1(this.line.GetPoint1());
            this.lineWidget.SetPoint2(this.line.GetPoint2());
        }
    }

    public void updateProbe(vtkDataSet inputDataSet, double[] startPtIn, double[] endPtIn, int resolIn, boolean viewPlot2D, int plotType) {
        if (inputDataSet != null) {
            this.startPt = startPtIn;
            this.endPt = endPtIn;
            this.resol = resolIn;
            this.lastDataSet = inputDataSet;
            this.line.SetPoint1(this.startPt[0], this.startPt[1], this.startPt[2]);
            this.line.SetPoint2(this.endPt[0], this.endPt[1], this.endPt[2]);
            this.line.SetResolution(this.resol);
            this.probe.SetSource((vtkDataObject)inputDataSet);
            this.probe.Update();
            this.probe.GetOutput().UpdateData();
            int nbPts = this.probe.GetOutput().GetNumberOfPoints();
            this.x.clear();
            this.y.clear();
            Double[] abscisse = new Double[5];
            for (int i = 0; i < nbPts; ++i) {
                abscisse[0] = i;
                abscisse[1] = this.probe.GetOutput().GetPoint(i)[0];
                abscisse[2] = this.probe.GetOutput().GetPoint(i)[1];
                abscisse[3] = this.probe.GetOutput().GetPoint(i)[2];
                abscisse[4] = this.computeS(this.probe.GetOutput().GetPoint(i)[0], this.probe.GetOutput().GetPoint(i)[1], this.probe.GetOutput().GetPoint(i)[2]);
                this.x.add(abscisse[plotType]);
                this.y.add(this.probe.GetOutput().GetPointData().GetScalars().GetTuple1(i));
            }
            this.pipelineManager.notifyConnectivityChange(this.cassFilter);
            this.plot.updateCollection(this.x, this.y);
            this.plotDialog.setVisible(viewPlot2D);
            if (this.nbUpdate++ == 0 && this.pipelineManager.getActorList().getData().contains(this.outputCassActor)) {
                this.pipelineManager.setActorVisible(this.outputCassActor, true);
            }
            if (this.lineWidget != null) {
                this.lineWidget.SetPoint1(this.line.GetPoint1());
                this.lineWidget.SetPoint2(this.line.GetPoint2());
            }
            this.filterImpl.getInputDataSet().clear();
            this.filterImpl.getInputDataSet().add(inputDataSet);
            this.filterImpl.getOutputDataSet().clear();
            this.filterImpl.getOutputDataSet().add(this.probe.GetOutput());
            this.filterImpl.getAlgorithm().add(this.probe);
            this.filterImpl.getVtkImplicitFunction().clear();
            this.filterImpl.getVtkImplicitFunction().add(this.line);
            this.pipelineManager.notifyConnectivityChange(this.cassFilter);
        }
    }

    public void export() {
        File fileToSave;
        Double[] abscisse = new Double[5];
        JFileChooser chooser = new JFileChooser();
        if (0 == chooser.showSaveDialog(this.plotDialog) && (fileToSave = chooser.getSelectedFile()) != null) {
            try {
                FileWriter fw = new FileWriter(fileToSave);
                fw.write("# index x y z s value \n");
                int size = this.x.size();
                for (int i = 0; i < size; ++i) {
                    abscisse[0] = i;
                    abscisse[1] = this.probe.GetOutput().GetPoint(i)[0];
                    abscisse[2] = this.probe.GetOutput().GetPoint(i)[1];
                    abscisse[3] = this.probe.GetOutput().GetPoint(i)[2];
                    abscisse[4] = this.computeS(this.probe.GetOutput().GetPoint(i)[0], this.probe.GetOutput().GetPoint(i)[1], this.probe.GetOutput().GetPoint(i)[2]);
                    fw.write(abscisse[0] + " " + abscisse[1] + " " + abscisse[2] + " " + abscisse[3] + " " + abscisse[4] + " " + this.probe.GetOutput().GetPointData().GetScalars().GetTuple1(i) + "\n");
                }
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.plotDialog, "Error while trying to export: " + e.getMessage());
            }
        }
    }

    public double computeS(double x, double y, double z) {
        double max;
        double s = 0.0;
        int axeRef = 0;
        double[] pt = new double[]{x, y, z};
        double[] diff = new double[]{this.endPt[0] - this.startPt[0], this.endPt[1] - this.startPt[1], this.endPt[2] - this.startPt[2]};
        if (diff[0] >= diff[1]) {
            if (diff[0] >= diff[2]) {
                max = diff[0];
                axeRef = 0;
            } else {
                max = diff[2];
                axeRef = 2;
            }
        } else if (diff[1] >= diff[2]) {
            max = diff[1];
            axeRef = 1;
        } else {
            max = diff[2];
            axeRef = 2;
        }
        s = pt[axeRef] - this.startPt[axeRef] / max;
        return s;
    }

    public String getName() {
        return this.name;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.outputCassActor);
        this.pipelineManager.removeVtkObject(this.outputCassDataset);
        this.pipelineManager.removeVtkObject(this.outputCassMapper);
        this.pipelineManager.removeVtkObject(this.cassFilter);
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public String toString() {
        return this.getName();
    }

    public CassandraObject getOutputDataSet() {
        return this.outputCassDataset;
    }

    void show3DWidget(boolean b) {
        if (b) {
            if (this.lineWidget == null) {
                this.init3DWidget();
            }
            this.lineWidget.On();
        } else if (this.lineWidget != null) {
            this.lineWidget.Off();
        }
    }

    void init3DWidget() {
        this.lineWidget = new vtkLineWidget();
        this.lineWidget.SetInteractor((vtkRenderWindowInteractor)this.pipelineManager.getCassandraView().getIren());
        this.lineWidget.EnabledOn();
        this.pipelineManager.getCassandraView().deepValidateView();
        this.lineWidget.SetInput(this.lastDataSet);
        this.lineWidget.SetPlaceFactor(1.2);
        this.lineWidget.PlaceWidget();
        this.lineWidget.SetPoint1(this.line.GetPoint1());
        this.lineWidget.SetPoint2(this.line.GetPoint2());
        this.lineWidget.AddObserver("InteractionEvent", (Object)this, "interactionCallBack");
    }

    private void widgetCharEvent() {
        char code = Character.toLowerCase(this.pipelineManager.getCassandraView().getIren().GetKeyCode());
        System.out.println("touch typed:" + code);
        if (code == 'b') {
            this.lineWidget.SetEnabled(1);
        }
    }

    private void startInteractionCallBack() {
        System.out.println("wiget interaction started");
    }

    private void interactionCallBack() {
        this.line.SetPoint1(this.lineWidget.GetPoint1());
        this.line.SetPoint2(this.lineWidget.GetPoint2());
        this.controlUI.setPoint1(this.lineWidget.GetPoint1());
        this.controlUI.setPoint2(this.lineWidget.GetPoint2());
        this.controlUI.performAction(this.controlUI.UPDATE);
    }

    public Filter getInternalFilter() {
        return this.filterImpl;
    }

    public PlugInControlUI getControlUI() {
        return this.controlUI;
    }

    public CassandraPlugInProperty getPlugInProperty() {
        this.outputCassLookupTable = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)((vtkLookupTable)this.lineMapper.GetLookupTable()));
        this.outputLookupTable = (vtkLookupTable)this.outputCassLookupTable.getVtkObject();
        this.outputCassScalarBar = this.pipelineManager.getVtkObject((Integer)this.outputCassLookupTable.getOutputConnectivityList().get(0));
        this.outputScalarBar = (vtkScalarBarActor)this.outputCassScalarBar.getVtkObject();
        SimplePlugInProperty prop = new SimplePlugInProperty();
        prop.put((Object)PERSISTENCE_KEY_INPUT_DATASET, (Object)this.probe.GetInput());
        prop.put((Object)PERSISTENCE_KEY_OUPUT_DATASET, (Object)this.probe.GetOutput());
        prop.put((Object)PERSISTENCE_KEY_OUPUT_MAPPER, (Object)this.lineMapper);
        prop.put((Object)PERSISTENCE_KEY_OUPUT_LOOKUP_TABLE, this.outputCassLookupTable.getVtkObject());
        prop.put((Object)PERSISTENCE_KEY_OUTPUT_ACTOR, this.outputCassActor.getVtkObject());
        prop.put((Object)PERSISTENCE_KEY_OUTPUT_SCALAR_BAR, this.outputCassScalarBar.getVtkObject());
        prop.put((Object)PERSISTENCE_KEY_START_POINT_X, (Object)this.line.GetPoint1()[0]);
        prop.put((Object)PERSISTENCE_KEY_START_POINT_Y, (Object)this.line.GetPoint1()[1]);
        prop.put((Object)PERSISTENCE_KEY_START_POINT_Z, (Object)this.line.GetPoint1()[2]);
        prop.put((Object)PERSISTENCE_KEY_END_POINT_X, (Object)this.line.GetPoint2()[0]);
        prop.put((Object)PERSISTENCE_KEY_END_POINT_Y, (Object)this.line.GetPoint2()[1]);
        prop.put((Object)PERSISTENCE_KEY_END_POINT_Z, (Object)this.line.GetPoint2()[3]);
        prop.put((Object)PERSISTENCE_KEY_PROBE_RESOLUTION, (Object)this.line.GetResolution());
        Point cellPosition = ((VtkObjectCellAdapter)this.cassFilter.getMetaData().get("CELL")).getPosition();
        prop.put((Object)PERSISTENCE_KEY_CELL_POS_X, (Object)cellPosition.x);
        prop.put((Object)PERSISTENCE_KEY_CELL_POS_Y, (Object)cellPosition.y);
        return prop;
    }

    public void initAndUpdate(CassandraPlugInProperty prop) {
        this.probe = new vtkProbeFilter();
        vtkDataSet tmpInputDataSet = (vtkDataSet)prop.getSafely((Object)PERSISTENCE_KEY_INPUT_DATASET, (Object)((vtkDataSet)this.probe.GetInput()));
        this.lineMapper = (vtkDataSetMapper)prop.getSafely((Object)PERSISTENCE_KEY_OUPUT_MAPPER, null);
        this.outputLookupTable = (vtkLookupTable)prop.getSafely((Object)PERSISTENCE_KEY_OUPUT_LOOKUP_TABLE, null);
        this.lineActor = (vtkActor)prop.getSafely((Object)PERSISTENCE_KEY_OUTPUT_ACTOR, null);
        this.outputScalarBar = (vtkScalarBarActor)prop.getSafely((Object)PERSISTENCE_KEY_OUTPUT_SCALAR_BAR, null);
        this.line.SetPoint1(prop.getSafely((Object)PERSISTENCE_KEY_START_POINT_X, 0.0), prop.getSafely((Object)PERSISTENCE_KEY_START_POINT_Y, 0.0), prop.getSafely((Object)PERSISTENCE_KEY_START_POINT_Z, 0.0));
        this.line.SetPoint2(prop.getSafely((Object)PERSISTENCE_KEY_END_POINT_X, 0.0), prop.getSafely((Object)PERSISTENCE_KEY_END_POINT_Y, 0.0), prop.getSafely((Object)PERSISTENCE_KEY_END_POINT_Z, 0.0));
        this.line.SetResolution(prop.getSafely((Object)PERSISTENCE_KEY_PROBE_RESOLUTION, 256));
        this.initPipeline();
        this.controlUI.setPoint1(this.line.GetPoint1());
        this.controlUI.setPoint2(this.line.GetPoint2());
        this.controlUI.setSelectedInput(this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)tmpInputDataSet));
        this.updateProbe(tmpInputDataSet, this.line.GetPoint1(), this.line.GetPoint2(), this.line.GetResolution(), false, 1);
        int cellPosX = prop.getSafely((Object)PERSISTENCE_KEY_CELL_POS_X, -1);
        int cellPosY = prop.getSafely((Object)PERSISTENCE_KEY_CELL_POS_Y, -1);
        if (cellPosX > 0 && cellPosY > 0) {
            ((VtkObjectCellAdapter)this.cassFilter.getMetaData().get("CELL")).setPosition(new Point(cellPosX, cellPosY));
        }
    }
}

