/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.threshold;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.plugin.CassandraPlugInProperty;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.threshold.ThresholdControlUI;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkActor;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkDataSetMapper;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;
import vtk.vtkThreshold;

public class ThresholdPlugin
implements CassandraPlugin,
RemoveListener {
    public static final int THRESHOLD_BETWEEN = 1;
    public static final int THRESHOLD_LOWER = 2;
    public static final int THRESHOLD_UPPER = 3;
    private String name = "Threshold";
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private ThresholdControlUI controlUI;
    private int nbUpdate = 0;
    private vtkDataSet lastDataSet;
    private vtkLookupTable lookupTable;
    private vtkScalarBarActor scalarBar;
    private vtkThreshold threshold;
    private vtkDataSetMapper thresholdVtkMapper;
    private vtkActor thresholdVtkActor;
    private CassandraObject actor;
    private CassandraObject mapper;
    private CassandraObject dataset;
    private CassandraObject filter;
    private Filter filterImpl = new FilterImpl();

    public ThresholdPlugin() {
    }

    public ThresholdPlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this();
        this.pipelineManager = pipelineManager;
        this.pluginManager = pluginManager;
        this.controlUI = new ThresholdControlUI(pipelineManager, this, owner);
        this.contextualMenu = new JPopupMenu("Threshold menu");
        JMenuItem showControl = new JMenuItem("Show control");
        showControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThresholdPlugin.this.controlUI.setVisible(true);
            }
        });
        this.contextualMenu.add(showControl);
        this.contextualMenu.addSeparator();
        JMenuItem remove = new JMenuItem("Remove");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThresholdPlugin.this.remove();
            }
        });
        this.contextualMenu.add(remove);
        this.threshold = new vtkThreshold();
        this.thresholdVtkMapper = new vtkDataSetMapper();
        this.thresholdVtkMapper.SetInput((vtkDataSet)this.threshold.GetOutput());
        this.thresholdVtkActor = new vtkActor();
        this.thresholdVtkActor.SetMapper((vtkMapper)this.thresholdVtkMapper);
        this.lookupTable = new vtkLookupTable();
        this.lookupTable.SetHueRange(0.66667, 0.0);
        this.lookupTable.Build();
        this.thresholdVtkMapper.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        vtkScalarBarActor scalBar = new vtkScalarBarActor();
        scalBar.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        this.filterImpl.getOutputDataSet().add(this.threshold.GetOutput());
        this.filterImpl.addRemoveListener((RemoveListener)this);
        this.actor = pipelineManager.addActor((Object)this.thresholdVtkActor, "Threshold");
        this.mapper = pipelineManager.addMapper((Object)this.thresholdVtkMapper, "Threshold");
        this.dataset = pipelineManager.addDataSet((Object)this.threshold.GetOutput(), "Threshold");
        this.filter = pipelineManager.addFilter(this.filterImpl, "Threshold");
        pipelineManager.addLookupTable(this.lookupTable, "Threshold");
        pipelineManager.addScalarBar(scalBar, "Threshold");
        this.filter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
        this.actor.setValide(false);
        this.controlUI.setVisible(true);
    }

    public void updateThreshold(vtkDataSet inputDataSet, int thresholdType, double lowerLevel, double upperLevel) {
        if (inputDataSet != null) {
            this.threshold.SetInput((vtkDataObject)inputDataSet);
            switch (thresholdType) {
                case 1: {
                    this.threshold.ThresholdBetween(lowerLevel, upperLevel);
                    break;
                }
                case 2: {
                    this.threshold.ThresholdByLower(upperLevel);
                    break;
                }
                case 3: {
                    this.threshold.ThresholdByUpper(lowerLevel);
                }
            }
            this.filterImpl.getInputDataSet().clear();
            this.filterImpl.getInputDataSet().add(inputDataSet);
            if (this.pipelineManager.getActorList().getData().contains(this.actor)) {
                this.actor.setValide(true);
                this.pipelineManager.setActorVisible(this.actor, true);
            } else {
                this.pipelineManager.setActorVisible(this.actor, false);
            }
            this.pipelineManager.hideInputActor(this.actor, inputDataSet);
            if ((this.lastDataSet == null || !this.lastDataSet.equals(inputDataSet)) && this.thresholdVtkMapper.GetLookupTable().equals(this.lookupTable)) {
                this.thresholdVtkMapper.SetScalarRange(inputDataSet.GetScalarRange());
                this.lookupTable.SetTableRange(inputDataSet.GetScalarRange());
                this.lastDataSet = inputDataSet;
            }
            this.threshold.Update();
            this.threshold.GetOutput().UpdateData();
            this.pipelineManager.notifyConnectivityChange(this.filter);
        }
    }

    public String getName() {
        return this.name;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.actor);
        this.pipelineManager.removeVtkObject(this.mapper);
        this.pipelineManager.removeVtkObject(this.dataset);
        this.pipelineManager.removeVtkObject(this.filter);
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public String toString() {
        return this.getName();
    }

    public CassandraObject getOutputDataSet() {
        return this.dataset;
    }

    public Filter getInternalFilter() {
        return this.filterImpl;
    }

    public PlugInControlUI getControlUI() {
        return this.controlUI;
    }

    public CassandraPlugInProperty getPlugInProperty() {
        return null;
    }

    public void initAndUpdate(CassandraPlugInProperty prop) {
    }
}

