/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.defaults;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Iterator;
import vtk.vtkDataSet;
import vtk.vtkFloatArray;
import vtk.vtkIdList;
import vtk.vtkPoints;
import vtk.vtkUnstructuredGrid;

public class Line3d {
    private ArrayList pointList = new ArrayList();
    private vtkUnstructuredGrid grid = null;

    public void load(String filePath) throws IOException {
        FileReader fr = new FileReader(filePath);
        LineNumberReader lnr = new LineNumberReader(fr);
        String line = null;
        String[] split = null;
        double[] point = new double[3];
        while ((line = lnr.readLine()) != null) {
            split = line.split(" ");
            int currentIndex = 0;
            for (int i = 0; i < split.length; ++i) {
                if (split[i].trim().length() <= 0) continue;
                point[currentIndex++] = Double.parseDouble(split[i]);
            }
            this.addPoint(point[0], point[1], point[2]);
        }
        lnr.close();
    }

    public void addPoint(double x, double y, double z) {
        this.pointList.add(new double[]{x, y, z});
    }

    public void reset() {
        this.pointList.clear();
        this.grid = null;
    }

    private void buildVtkDataSet() {
        vtkIdList idList = null;
        int id = 0;
        this.grid = new vtkUnstructuredGrid();
        this.grid.Allocate(this.pointList.size() - 1, this.pointList.size());
        vtkPoints points = new vtkPoints();
        vtkFloatArray pcoords = new vtkFloatArray();
        pcoords.SetNumberOfComponents(3);
        pcoords.SetNumberOfTuples(this.pointList.size());
        Iterator i = this.pointList.iterator();
        while (i.hasNext()) {
            points.InsertPoint(id++, (double[])i.next());
        }
        this.grid.SetPoints(points);
        for (int i2 = 0; i2 < id - 1; ++i2) {
            idList = new vtkIdList();
            idList.InsertNextId(i2);
            idList.InsertNextId(i2 + 1);
            this.grid.InsertNextCell(3, idList);
        }
        this.grid.Update();
    }

    public vtkDataSet getDataSet() {
        if (this.grid == null) {
            this.buildVtkDataSet();
        }
        return this.grid;
    }
}

