/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.defaults;

import com.artenum.cassandra.action.PluginActionListener;
import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.defaults.PickingActionEventInformation;
import com.artenum.cassandra.plugin.defaults.ui.PickingInformationUI;
import com.artenum.cassandra.renderer.vtk.PickingObserver;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkCell;
import vtk.vtkCellPicker;
import vtk.vtkDataSet;
import vtk.vtkMapper2D;
import vtk.vtkPointPicker;
import vtk.vtkTextActor;
import vtk.vtkTextMapper;
import vtk.vtkTextProperty;

public class ShowPickingInformation
implements ActionListener,
PickingObserver,
RemoveListener {
    private String name;
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private Frame owner;
    private JPopupMenu contextualMenu;
    private PickingInformationUI controlUI;
    private CassandraObject cassfilter;
    private CassandraObject pointTextCassActor;
    private CassandraObject messageCassActor;
    private vtkTextMapper messageTextMapper;
    private vtkTextActor messageTextActor;
    private int messageTextXPosition = 30;
    private int messageTextYPosition = 30;
    private vtkTextMapper resultsTextMapper;
    private vtkTextActor resultTextActor;
    private StringBuffer resultsTextBuffer;
    private int resultTextXPosition = 10;
    private int resultTextYPosition = 10;
    private String[] coord = new String[3];
    private String padding = "                   ";
    private String[] label = new String[]{"X: ", "Y: ", "Z: "};
    private FilterImpl filterImpl;
    private boolean pipelineInitialised = false;
    private vtkDataSet pickedDataSet = null;
    private Integer meshElementId = -1;

    public ShowPickingInformation(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this.pluginManager = pluginManager;
        this.pipelineManager = pipelineManager;
        this.owner = owner;
        this.initPlugIn(this.pipelineManager, this.pluginManager, this.owner);
    }

    public ShowPickingInformation(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner, int initPipeline) {
        this.pluginManager = pluginManager;
        this.pipelineManager = pipelineManager;
        this.owner = owner;
        this.initPlugIn(this.pipelineManager, this.pluginManager, this.owner);
        if (initPipeline == 1) {
            this.initPipeline();
        }
    }

    public void initPlugIn(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this.name = "Picking";
        this.pipelineManager = pipelineManager;
        this.resultsTextBuffer = new StringBuffer();
        this.filterImpl = new FilterImpl();
        this.filterImpl.addRemoveListener((RemoveListener)this);
        this.controlUI = new PickingInformationUI(this.pipelineManager, this, owner);
        this.contextualMenu = new JPopupMenu("Picking menu");
        JMenuItem showControl = new JMenuItem("Show control");
        showControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowPickingInformation.this.controlUI.setVisible(true);
            }
        });
        this.contextualMenu.add(showControl);
    }

    private void initPipeline() {
        if (!this.pipelineInitialised) {
            this.cassfilter = this.pipelineManager.addFilter((Filter)this.filterImpl, "Picking Filter");
            this.cassfilter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
            this.messageTextMapper = new vtkTextMapper();
            vtkTextProperty messageTextProperty = this.messageTextMapper.GetTextProperty();
            messageTextProperty.SetFontFamilyToArial();
            messageTextProperty.SetFontSize(10);
            messageTextProperty.BoldOn();
            messageTextProperty.ShadowOn();
            messageTextProperty.SetColor(1.0, 0.0, 1.0);
            this.messageTextActor = new vtkTextActor();
            this.messageTextActor.SetMapper((vtkMapper2D)this.messageTextMapper);
            this.messageTextActor.GetProperty().SetColor(1.0, 0.0, 1.0);
            this.messageTextYPosition = this.pipelineManager.getCassandraView().getHeight() - this.messageTextYPosition;
            this.messageTextActor.SetDisplayPosition(this.messageTextXPosition, this.messageTextYPosition);
            this.messageCassActor = this.pipelineManager.addTxtActor(this.messageTextActor, "Picking Message Actor");
            this.pipelineManager.setActorVisible(this.messageCassActor, true);
            this.messageTextActor.SetInput("Picking activated: press p-key to pick a mesh element.");
            this.resultsTextMapper = new vtkTextMapper();
            this.resultsTextMapper.SetInput("");
            vtkTextProperty pointTextProperty = this.resultsTextMapper.GetTextProperty();
            pointTextProperty.SetFontFamilyToArial();
            pointTextProperty.SetFontSize(10);
            pointTextProperty.BoldOn();
            pointTextProperty.ShadowOn();
            pointTextProperty.SetColor(1.0, 1.0, 1.0);
            this.resultTextActor = new vtkTextActor();
            this.resultTextActor.SetMapper((vtkMapper2D)this.resultsTextMapper);
            this.resultTextActor.SetDisplayPosition(this.resultTextXPosition, this.resultTextYPosition);
            this.pointTextCassActor = this.pipelineManager.addTxtActor(this.resultTextActor, "Picking Result Actor");
            this.pipelineManager.setActorVisible(this.pointTextCassActor, true);
            this.pipelineManager.getCassandraView().addPickingObserver((PickingObserver)this);
            this.pipelineManager.getCassandraView().deepValidateView();
            this.pipelineInitialised = true;
        }
    }

    public double getPointPickerTolerance() {
        return this.pipelineManager.getCassandraView().getPointPickerTolerance();
    }

    public void setPointPickerTolerance(double tolerance) {
        this.pipelineManager.getCassandraView().setPointPickerTolerance(tolerance);
    }

    public double getCellPickerTolerance() {
        return this.pipelineManager.getCassandraView().getCellPickerTolerance();
    }

    public void setCellPickerTolerance(double tolerance) {
        this.pipelineManager.getCassandraView().setCellPickerTolerance(tolerance);
    }

    public int getPickingMode() {
        return this.pipelineManager.getCassandraView().getPickingMode();
    }

    public void setPickingMode(int pickMode) {
        this.pipelineManager.getCassandraView().setPickMode(pickMode);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.initPipeline();
        this.controlUI.update();
    }

    private void notifyPluginListerners(int cellDimensionPicked) {
        Iterator iter = this.pluginManager.getPluginActionListenerList().iterator();
        PickingActionEventInformation actionEventInformation = new PickingActionEventInformation(this.meshElementId, this.getPickingMode(), cellDimensionPicked);
        ActionEvent evt = new ActionEvent(actionEventInformation, 1515, "picking.action.cmd");
        while (iter.hasNext()) {
            PluginActionListener listener = (PluginActionListener)iter.next();
            listener.actionPerformed(evt);
        }
    }

    public void pickPoint(vtkPointPicker pointPicker) {
        if (this.resultTextActor != null) {
            this.meshElementId = pointPicker.GetPointId();
            if (pointPicker.GetPointId() > -1) {
                this.pickedDataSet = pointPicker.GetDataSet();
                double[] xyz = pointPicker.GetDataSet().GetPoint(this.meshElementId.intValue());
                this.coord[0] = Float.toString((float)xyz[0]);
                this.coord[1] = Float.toString((float)xyz[1]);
                this.coord[2] = Float.toString((float)xyz[2]);
                this.resultsTextBuffer.delete(0, this.resultsTextBuffer.length());
                this.resultsTextBuffer.append("Point ID: ");
                this.resultsTextBuffer.append(Integer.toString(this.meshElementId));
                this.resultsTextBuffer.append("\n");
                for (int i = 0; i < this.coord.length; ++i) {
                    this.resultsTextBuffer.append(this.label[i % 3]);
                    this.resultsTextBuffer.append(this.coord[i]);
                    this.resultsTextBuffer.append(this.fill(this.coord[i]));
                }
                this.resultsTextBuffer.append("\nValue: ");
                if (pointPicker.GetDataSet().GetPointData().GetArray(0) != null) {
                    this.resultsTextBuffer.append(Double.toString(pointPicker.GetDataSet().GetPointData().GetArray(0).GetTuple1(this.meshElementId.intValue())));
                } else {
                    this.resultsTextBuffer.append("Not defined");
                }
                this.resultTextActor.SetInput(this.resultsTextBuffer.toString());
            } else {
                System.out.println("No point found.");
                this.resultsTextBuffer.delete(0, this.resultsTextBuffer.length());
                this.resultsTextBuffer.append("No point found.");
                this.resultsTextBuffer.append("\n");
                this.resultTextActor.SetInput(this.resultsTextBuffer.toString());
                this.meshElementId = -1;
            }
        }
        this.notifyPluginListerners(0);
    }

    public void pickCell(vtkCellPicker cellPicker) {
        this.pickedDataSet = cellPicker.GetDataSet();
        if (this.resultTextActor != null) {
            this.meshElementId = cellPicker.GetPointId();
            if (this.meshElementId > -1) {
                this.resultsTextBuffer.delete(0, this.resultsTextBuffer.length());
                this.resultsTextBuffer.append("Cell ID: ");
                this.resultsTextBuffer.append(Integer.toString(this.meshElementId));
                this.resultsTextBuffer.append("\n");
                this.resultTextActor.SetInput(this.resultsTextBuffer.toString());
            } else {
                System.out.println("No cell found.");
                this.resultsTextBuffer.delete(0, this.resultsTextBuffer.length());
                this.resultsTextBuffer.append("No cell found.");
                this.resultsTextBuffer.append("\n");
                this.resultTextActor.SetInput(this.resultsTextBuffer.toString());
                this.meshElementId = -1;
            }
        }
        int getCellId = cellPicker.GetCellId();
        vtkCell vtkCell2 = this.pickedDataSet.GetCell(getCellId);
        this.notifyPluginListerners(vtkCell2.GetCellDimension());
    }

    public String fill(String number) {
        return this.padding.substring(number.length());
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public void remove() {
        this.pipelineManager.removeVtkObject(this.pointTextCassActor);
        this.pipelineManager.removeVtkObject(this.cassfilter);
    }

    public vtkDataSet getPickedDataSet() {
        return this.pickedDataSet;
    }
}

