/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.cellcenter;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObjectListModel;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.cellcenter.CellCenterPlugin;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataListener;
import vtk.vtkDataSet;

public class CellCenterControlUI
extends PlugInControlUI {
    private PipeLineManager pipeLineManager;
    private JFormattedTextField centerX;
    private JCheckBox cellVertexCheckBox;
    private JComboBox input;
    private CellCenterPlugin plugin;

    public CellCenterControlUI(PipeLineManager pipeLineManager, CellCenterPlugin plugin, Frame owner) {
        super(owner, "Cell Centers configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = plugin;
        this.cellVertexCheckBox = new JCheckBox("Vertex Cells");
        JPanel vertexControlPanel = new JPanel();
        vertexControlPanel.add(this.cellVertexCheckBox);
        this.input = new JComboBox(new DataSetListModel(pipeLineManager.getDataSetList()));
        JButton exec = new JButton("Update");
        exec.setActionCommand("UPDATE");
        exec.addActionListener((ActionListener)((Object)this));
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener((ActionListener)((Object)this));
        JPanel line1 = new JPanel();
        line1.setLayout(new BoxLayout(line1, 2));
        line1.add(new JLabel("Input Dataset"));
        line1.add(this.input);
        JPanel cmdLine = new JPanel();
        cmdLine.setLayout(new BoxLayout(cmdLine, 2));
        cmdLine.add(Box.createHorizontalGlue());
        cmdLine.add(exec);
        cmdLine.add(cancel);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(line1);
        this.getContentPane().add(vertexControlPanel);
        this.getContentPane().add(cmdLine);
        this.pack();
        Dimension size = this.getSize();
        size.setSize(size.getWidth() + 100.0, size.getHeight());
        this.setSize(size);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("UPDATE")) {
            if (this.input.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(new JFrame(), "Please select a valid input dataset.", "Input Filter Selection Error", 0);
                return;
            }
            int cellVertexFlag = 0;
            if (this.cellVertexCheckBox.isSelected()) {
                cellVertexFlag = 1;
            }
            this.plugin.updateCellCenter(cellVertexFlag, (vtkDataSet)((CassandraObject)this.input.getSelectedItem()).getVtkObject());
            this.pipeLineManager.validateViewAndGo();
        }
        if (command.equals("CANCEL")) {
            this.dispose();
        }
    }

    public void stateChanged(ChangeEvent e) {
    }

    public void itemStateChanged(ItemEvent arg0) {
    }

    class DataSetListModel
    implements ComboBoxModel {
        private VtkObjectListModel datasetModel;
        private Object selectedItem;

        public DataSetListModel(VtkObjectListModel datasetModel) {
            this.datasetModel = datasetModel;
        }

        @Override
        public Object getElementAt(int index) {
            return this.datasetModel.getElementAt(index);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public int getSize() {
            return this.datasetModel.getSize();
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectedItem = anItem;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.datasetModel.addListDataListener(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.datasetModel.removeListDataListener(l);
        }
    }
}

