/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObjectListModel;
import com.artenum.cassandra.plugin.PluginManager;
import java.util.Iterator;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class CassandraTreeModel
extends DefaultTreeModel
implements ListDataListener {
    private PipeLineManager pipelineManager;
    private PluginManager pluginModel;
    private VtkObjectListModel actorModel;
    private VtkObjectListModel mapperModel;
    private VtkObjectListModel datasetModel;
    private VtkObjectListModel lookupTableModel;
    private VtkObjectListModel scalarBarModel;
    private VtkObjectListModel txtActorModel;
    private DefaultMutableTreeNode actorParentNode;
    private DefaultMutableTreeNode mapperParentNode;
    private DefaultMutableTreeNode datasetParentNode;
    private DefaultMutableTreeNode lookupTableParentNode;
    private DefaultMutableTreeNode scalarParentNode;
    private DefaultMutableTreeNode txtActorParentNode;
    private DefaultMutableTreeNode pluginParentNode;
    private DefaultMutableTreeNode root;

    public CassandraTreeModel(PipeLineManager pipelineManager, PluginManager pluginManager) {
        super(new DefaultMutableTreeNode("Vtk components"));
        this.pipelineManager = pipelineManager;
        this.actorModel = pipelineManager.getActorList();
        this.mapperModel = pipelineManager.getMapperList();
        this.datasetModel = pipelineManager.getDataSetList();
        this.txtActorModel = pipelineManager.getTextActorList();
        this.scalarBarModel = pipelineManager.getScalarBarList();
        this.lookupTableModel = pipelineManager.getLookupTableList();
        this.pluginModel = pluginManager;
        this.datasetModel.addListDataListener(this);
        this.mapperModel.addListDataListener(this);
        this.actorModel.addListDataListener(this);
        this.lookupTableModel.addListDataListener(this);
        this.txtActorModel.addListDataListener(this);
        this.scalarBarModel.addListDataListener(this);
        this.pluginModel.addListDataListener(this);
        this.root = (DefaultMutableTreeNode)this.getRoot();
        this.actorParentNode = new DefaultMutableTreeNode("Actors");
        this.mapperParentNode = new DefaultMutableTreeNode("Mappers");
        this.datasetParentNode = new DefaultMutableTreeNode("Dataset");
        this.pluginParentNode = new DefaultMutableTreeNode("Plugins");
        this.scalarParentNode = new DefaultMutableTreeNode("ScalarBar");
        this.txtActorParentNode = new DefaultMutableTreeNode("Text");
        this.lookupTableParentNode = new DefaultMutableTreeNode("Lookup Table");
        this.insertNodeInto(this.actorParentNode, this.root, this.root.getChildCount());
        this.insertNodeInto(this.scalarParentNode, this.root, this.root.getChildCount());
        this.insertNodeInto(this.txtActorParentNode, this.root, this.root.getChildCount());
        this.insertNodeInto(this.mapperParentNode, this.root, this.root.getChildCount());
        this.insertNodeInto(this.lookupTableParentNode, this.root, this.root.getChildCount());
        this.insertNodeInto(this.datasetParentNode, this.root, this.root.getChildCount());
        this.insertNodeInto(this.pluginParentNode, this.root, this.root.getChildCount());
        this.reload();
    }

    @Override
    public void reload() {
        this.actorParentNode.removeAllChildren();
        this.mapperParentNode.removeAllChildren();
        this.datasetParentNode.removeAllChildren();
        this.pluginParentNode.removeAllChildren();
        this.scalarParentNode.removeAllChildren();
        this.txtActorParentNode.removeAllChildren();
        this.lookupTableParentNode.removeAllChildren();
        Iterator<Object> i = this.actorModel.getData().iterator();
        while (i.hasNext()) {
            this.insertNodeInto(new DefaultMutableTreeNode(i.next()), this.actorParentNode, this.actorParentNode.getChildCount());
        }
        i = this.mapperModel.getData().iterator();
        while (i.hasNext()) {
            this.insertNodeInto(new DefaultMutableTreeNode(i.next()), this.mapperParentNode, this.mapperParentNode.getChildCount());
        }
        i = this.datasetModel.getData().iterator();
        while (i.hasNext()) {
            this.insertNodeInto(new DefaultMutableTreeNode(i.next()), this.datasetParentNode, this.datasetParentNode.getChildCount());
        }
        i = this.pluginModel.getData().iterator();
        while (i.hasNext()) {
            this.insertNodeInto(new DefaultMutableTreeNode(i.next()), this.pluginParentNode, this.pluginParentNode.getChildCount());
        }
        i = this.txtActorModel.getData().iterator();
        while (i.hasNext()) {
            this.insertNodeInto(new DefaultMutableTreeNode(i.next()), this.txtActorParentNode, this.txtActorParentNode.getChildCount());
        }
        i = this.scalarBarModel.getData().iterator();
        while (i.hasNext()) {
            this.insertNodeInto(new DefaultMutableTreeNode(i.next()), this.scalarParentNode, this.scalarParentNode.getChildCount());
        }
        i = this.lookupTableModel.getData().iterator();
        while (i.hasNext()) {
            this.insertNodeInto(new DefaultMutableTreeNode(i.next()), this.lookupTableParentNode, this.lookupTableParentNode.getChildCount());
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.reload();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        if (e.getSource().equals(this.actorModel)) {
            this.insertNodeInto(new DefaultMutableTreeNode(this.actorModel.getLastVtkObject()), this.actorParentNode, this.actorParentNode.getChildCount());
        }
        if (e.getSource().equals(this.mapperModel)) {
            this.insertNodeInto(new DefaultMutableTreeNode(this.mapperModel.getLastVtkObject()), this.mapperParentNode, this.mapperParentNode.getChildCount());
        }
        if (e.getSource().equals(this.datasetModel)) {
            this.insertNodeInto(new DefaultMutableTreeNode(this.datasetModel.getLastVtkObject()), this.datasetParentNode, this.datasetParentNode.getChildCount());
        }
        if (e.getSource().equals(this.pluginModel)) {
            this.insertNodeInto(new DefaultMutableTreeNode(this.pluginModel.getLastPlugin()), this.pluginParentNode, this.pluginParentNode.getChildCount());
        }
        if (e.getSource().equals(this.txtActorModel)) {
            this.insertNodeInto(new DefaultMutableTreeNode(this.txtActorModel.getLastVtkObject()), this.txtActorParentNode, this.txtActorParentNode.getChildCount());
        }
        if (e.getSource().equals(this.scalarBarModel)) {
            this.insertNodeInto(new DefaultMutableTreeNode(this.scalarBarModel.getLastVtkObject()), this.scalarParentNode, this.scalarParentNode.getChildCount());
        }
        if (e.getSource().equals(this.lookupTableModel)) {
            this.insertNodeInto(new DefaultMutableTreeNode(this.lookupTableModel.getLastVtkObject()), this.lookupTableParentNode, this.lookupTableParentNode.getChildCount());
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        if (e.getSource().equals(this.actorModel)) {
            this.removeNodeFromParent((MutableTreeNode)this.actorParentNode.getChildAt(e.getIndex0()));
        }
        if (e.getSource().equals(this.mapperModel)) {
            this.removeNodeFromParent((MutableTreeNode)this.mapperParentNode.getChildAt(e.getIndex0()));
        }
        if (e.getSource().equals(this.datasetModel)) {
            this.removeNodeFromParent((MutableTreeNode)this.datasetParentNode.getChildAt(e.getIndex0()));
        }
        if (e.getSource().equals(this.pluginModel)) {
            this.removeNodeFromParent((MutableTreeNode)this.pluginParentNode.getChildAt(e.getIndex0()));
        }
        if (e.getSource().equals(this.txtActorModel)) {
            this.removeNodeFromParent((MutableTreeNode)this.txtActorParentNode.getChildAt(e.getIndex0()));
        }
        if (e.getSource().equals(this.scalarBarModel)) {
            this.removeNodeFromParent((MutableTreeNode)this.scalarParentNode.getChildAt(e.getIndex0()));
        }
        if (e.getSource().equals(this.lookupTableModel)) {
            this.removeNodeFromParent((MutableTreeNode)this.lookupTableParentNode.getChildAt(e.getIndex0()));
        }
    }
}

