/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline.io;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.graph.VtkObjectCellAdapter;
import com.artenum.cassandra.pipeline.io.PipelineExporter;
import com.artenum.cassandra.plugin.CassandraPlugInProperty;
import com.artenum.cassandra.plugin.CassandraPlugin;
import java.awt.Point;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import vtk.vtkActor;
import vtk.vtkDataObject;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkObject;
import vtk.vtkScalarBarActor;

public class PipelineToJythonExporter
implements PipelineExporter {
    private Hashtable selectedVtkObjectList;
    private ArrayList<String> exportedScript;
    private static String eol = System.getProperty("line.separator");
    private static String scriptTab = "    ";
    private File fileOut;
    private boolean exportHeader = true;
    private boolean exportNodes = true;
    private boolean exportConnectivity = true;
    private boolean cassandraContext = true;
    private boolean keepCassandraPlugIn = true;
    public static final double REF_FILE_FORMAT_VERSION = 1.0;
    private String scriptHeader = "# Exported from Cassandra's pipeline (see http://www.artenum.com/cassandra)" + eol;
    private String scriptContextSectionRadical = "# loading/deployment context" + eol;
    private String scriptImportSectionRadical = "# imported modules " + eol;
    private String scriptInstanciationSectionRadical = "# objects instanciation" + eol;
    private String scriptConnectivitySectionRadical = "# pipeline connectivity" + eol;
    private String scriptCassandraReloadingSectionRadical = "# reloading section for Cassandra's pipeline through the JyConsole" + eol + "# set CASSANDRA_CONTEXT to 1 for reloading into the reloading into the pipeline active" + eol + "# operationnal in Cassandra only. " + eol + "if CASSANDRA_CONTEXT:" + eol + scriptTab + "pipeline  = cassandra.getPipeLineManager()" + eol;
    private String scriptPlugInConnectivitySectionRadical = "# plug-ins connectivity" + eol;
    private String scriptImportSection = this.scriptImportSectionRadical;
    private String scriptContextSection = this.scriptContextSectionRadical;
    private String scriptInstanciationSection = this.scriptInstanciationSectionRadical;
    private String scriptConnectivitySection = this.scriptConnectivitySectionRadical;
    private String scriptPlugInConnectivitySection = this.scriptPlugInConnectivitySectionRadical;
    private String scriptCassandraReloadingSection = this.scriptCassandraReloadingSectionRadical;
    private PipeLineManager pipeline;

    @Override
    public void setOutputFile(File file) {
        this.fileOut = file;
    }

    @Override
    public void setOutputFile(String canonicalFileName) {
        this.fileOut = new File(canonicalFileName);
    }

    public void write() {
        this.export();
        try {
            FileWriter fw = new FileWriter(this.fileOut, false);
            if (this.exportHeader) {
                fw.write(this.scriptHeader);
                fw.write("FILE_FORMAT_VERSION = 1.0" + eol);
                fw.write(eol);
                fw.flush();
            }
            if (this.exportNodes) {
                fw.write(this.scriptContextSection);
                fw.write(eol);
                fw.write(this.scriptImportSection);
                fw.write(eol);
                fw.flush();
                fw.write(this.scriptInstanciationSection);
                fw.write(eol);
                fw.flush();
            }
            if (this.exportConnectivity) {
                fw.write(this.scriptConnectivitySection);
                fw.write(eol);
                fw.flush();
            }
            if (this.cassandraContext) {
                fw.write(this.scriptCassandraReloadingSection);
                fw.write(eol);
                fw.write(this.scriptPlugInConnectivitySection);
                fw.flush();
            }
            fw.close();
            System.out.println("Pipeline saved.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setPipeline(PipeLineManager pipeline) {
        this.pipeline = pipeline;
    }

    private void resetSectionHeaders() {
        this.scriptImportSection = this.scriptImportSectionRadical;
        this.scriptInstanciationSection = this.scriptInstanciationSectionRadical;
        this.scriptConnectivitySection = this.scriptConnectivitySectionRadical;
        this.scriptCassandraReloadingSection = this.scriptCassandraReloadingSectionRadical;
    }

    @Override
    public void export() {
        vtkObject vtkObj;
        String tmpImportLine;
        CassandraObject obj;
        Object key;
        Enumeration keyList;
        String tmpLine = "";
        String tmpConnectivityLine = "";
        String tmpPlugInsConnectivityLine = "";
        HashMap<Integer, vtkObject> exportedVtkObjArray = new HashMap<Integer, vtkObject>();
        HashMap<Integer, String> exportedVtkObjCanonicalNameArray = new HashMap<Integer, String>();
        this.exportedScript = new ArrayList();
        this.resetSectionHeaders();
        if (this.cassandraContext) {
            this.exportConnectivity = true;
        }
        if (this.exportConnectivity) {
            this.exportNodes = true;
        }
        this.scriptContextSection = this.scriptContextSection + "CASSANDRA_CONTEXT = " + (this.cassandraContext ? 1 : 0) + eol;
        if (this.exportNodes) {
            keyList = this.selectedVtkObjectList.keys();
            while (keyList.hasMoreElements()) {
                String tmpObjectName;
                key = keyList.nextElement();
                obj = (CassandraObject)this.selectedVtkObjectList.get(key);
                if (obj.getVtkObject() instanceof FilterImpl) {
                    System.out.println("Cassandra filter found");
                    Class<?> plugInCanonicalClass = ((FilterImpl)obj.getVtkObject()).getParentPlugin().getClass();
                    if (this.keepCassandraPlugIn) {
                        System.out.println("Keep Cassandra plugin");
                        tmpImportLine = "if CASSANDRA_CONTEXT:" + eol + scriptTab + "from com.artenum.cassandra.util import CassandraToolBox" + eol + scriptTab + "from " + plugInCanonicalClass.getPackage().getName() + " import " + plugInCanonicalClass.getSimpleName().toString() + eol;
                        this.scriptImportSection = this.scriptImportSection + tmpImportLine;
                        tmpObjectName = plugInCanonicalClass.getSimpleName().toString() + "_" + obj.getId();
                        exportedVtkObjCanonicalNameArray.put(obj.getId(), tmpObjectName);
                        tmpLine = "if CASSANDRA_CONTEXT:" + eol + scriptTab + tmpObjectName + " = " + plugInCanonicalClass.getSimpleName().toString() + "(cassandra.getPipeLineManager(), cassandra.getPluginManager(), CassandraToolBox.getParentFrame(cassandra.getDefaultUI()), 0)";
                        this.scriptInstanciationSection = this.scriptInstanciationSection + tmpLine + eol;
                        continue;
                    }
                    System.out.println("Decompose plug-in's internal components");
                    continue;
                }
                if (obj.getVtkObject() instanceof vtkObject) {
                    vtkObj = (vtkObject)obj.getVtkObject();
                    tmpImportLine = "from " + vtkObj.getClass().getPackage().getName() + " import " + vtkObj.getClass().getSimpleName().toString() + eol;
                    this.scriptImportSection = this.scriptImportSection + tmpImportLine;
                    tmpObjectName = vtkObj.getClass().getSimpleName().toString() + "_" + obj.getId();
                    System.out.println(this.pipeline.getCassandraVtkObjectByTrueVtkObject(vtkObj) + " expoterd as " + tmpObjectName);
                    exportedVtkObjCanonicalNameArray.put(obj.getId(), tmpObjectName);
                    exportedVtkObjArray.put(obj.getId(), vtkObj);
                    tmpLine = tmpObjectName + " = " + vtkObj.getClass().getSimpleName().toString() + "()";
                    this.scriptInstanciationSection = this.scriptInstanciationSection + tmpLine + eol;
                    continue;
                }
                System.out.println("Object class not supported. Can not be exported.");
            }
        }
        if (this.exportConnectivity) {
            keyList = this.selectedVtkObjectList.keys();
            while (keyList.hasMoreElements()) {
                key = keyList.nextElement();
                obj = (CassandraObject)this.selectedVtkObjectList.get(key);
                if (obj.getVtkObject() instanceof FilterImpl) {
                    System.out.println("Cassandra filter found");
                    CassandraPlugin parentPlugIn = ((FilterImpl)obj.getVtkObject()).getParentPlugin();
                    CassandraPlugInProperty plugInProperty = parentPlugIn.getPlugInProperty();
                    HashMap propertyMap = plugInProperty.getPropertyMap();
                    tmpImportLine = "if CASSANDRA_CONTEXT:" + eol + scriptTab + "from com.artenum.cassandra.util import CassandraToolBox" + eol + scriptTab + "from " + plugInProperty.getClass().getPackage().getName() + " import " + plugInProperty.getClass().getSimpleName().toString() + eol;
                    this.scriptImportSection = this.scriptImportSection + tmpImportLine;
                    String tmpPlugInPropertyInstanceName = plugInProperty.getClass().getSimpleName() + "_" + obj.getId();
                    tmpPlugInsConnectivityLine = "if CASSANDRA_CONTEXT:" + eol + scriptTab + tmpPlugInPropertyInstanceName + " = " + plugInProperty.getClass().getSimpleName() + "()" + eol;
                    block2: for (Map.Entry currentEntry : propertyMap.entrySet()) {
                        if (currentEntry.getValue() instanceof vtkObject) {
                            vtkObject tmpVtkObject = (vtkObject)currentEntry.getValue();
                            if (exportedVtkObjCanonicalNameArray.containsValue(tmpVtkObject)) {
                                System.out.println("found in exported list");
                            } else {
                                System.out.println("not found in exported list");
                            }
                            for (Map.Entry tmpEntry : exportedVtkObjArray.entrySet()) {
                                if (!tmpVtkObject.equals(tmpEntry.getValue())) continue;
                                tmpPlugInsConnectivityLine = tmpPlugInsConnectivityLine + scriptTab + tmpPlugInPropertyInstanceName + ".put( \"" + currentEntry.getKey() + "\", " + (String)exportedVtkObjCanonicalNameArray.get(tmpEntry.getKey()) + ")" + eol;
                                continue block2;
                            }
                            continue;
                        }
                        tmpPlugInsConnectivityLine = tmpPlugInsConnectivityLine + scriptTab + tmpPlugInPropertyInstanceName + ".put( \"" + currentEntry.getKey() + "\", " + currentEntry.getValue() + ")" + eol;
                    }
                    tmpPlugInsConnectivityLine = tmpPlugInsConnectivityLine + scriptTab + (String)exportedVtkObjCanonicalNameArray.get(obj.getId()) + ".initAndUpdate(" + tmpPlugInPropertyInstanceName + " )" + eol;
                    this.scriptPlugInConnectivitySection = this.scriptPlugInConnectivitySection + tmpPlugInsConnectivityLine;
                    continue;
                }
                if (!(obj.getVtkObject() instanceof vtkObject)) continue;
                vtkObj = (vtkObject)obj.getVtkObject();
                ArrayList<Integer> inputConnectivityList = obj.getInputConnectivityList();
                if (inputConnectivityList.isEmpty()) continue;
                for (Integer tmpId : inputConnectivityList) {
                    if (obj.getVtkObject() instanceof vtkMapper) {
                        tmpConnectivityLine = (String)exportedVtkObjCanonicalNameArray.get(obj.getId()) + ".SetInput(" + (String)exportedVtkObjCanonicalNameArray.get(tmpId) + ")";
                    } else if (!(obj.getVtkObject() instanceof vtkDataObject)) {
                        if (obj.getVtkObject() instanceof vtkActor) {
                            tmpConnectivityLine = (String)exportedVtkObjCanonicalNameArray.get(obj.getId()) + ".SetMapper(" + (String)exportedVtkObjCanonicalNameArray.get(tmpId) + ")";
                        } else if (obj.getVtkObject() instanceof vtkScalarBarActor) {
                            tmpConnectivityLine = (String)exportedVtkObjCanonicalNameArray.get(obj.getId()) + ".SetLookupTable(" + (String)exportedVtkObjCanonicalNameArray.get(tmpId) + ")";
                        } else if (obj.getVtkObject() instanceof vtkLookupTable) {
                            tmpConnectivityLine = (String)exportedVtkObjCanonicalNameArray.get(tmpId) + ".SetLookupTable(" + (String)exportedVtkObjCanonicalNameArray.get(obj.getId()) + ")";
                        } else {
                            System.out.println("not supported yet ");
                        }
                    }
                    this.scriptConnectivitySection = this.scriptConnectivitySection + tmpConnectivityLine + eol;
                }
            }
        }
        if (this.cassandraContext) {
            keyList = this.selectedVtkObjectList.keys();
            while (keyList.hasMoreElements()) {
                key = keyList.nextElement();
                obj = (CassandraObject)this.selectedVtkObjectList.get(key);
                if (obj.getVtkObject() instanceof FilterImpl) {
                    System.out.println("Cassandra filter found");
                    continue;
                }
                if (!(obj.getVtkObject() instanceof vtkObject)) continue;
                vtkObj = (vtkObject)obj.getVtkObject();
                Point cellPosition = ((VtkObjectCellAdapter)obj.getMetaData().get("CELL")).getPosition();
                if (obj.getVtkObject() instanceof vtkMapper) {
                    tmpLine = scriptTab + "pipeline.addMapper(" + (String)exportedVtkObjCanonicalNameArray.get(obj.getId()) + ", \"" + (String)exportedVtkObjCanonicalNameArray.get(obj.getId()) + "\", " + cellPosition.x + ", " + cellPosition.y + ")";
                } else if (obj.getVtkObject() instanceof vtkDataObject) {
                    tmpLine = scriptTab + "pipeline.addDataSet(" + (String)exportedVtkObjCanonicalNameArray.get(obj.getId()) + ", \"" + (String)exportedVtkObjCanonicalNameArray.get(obj.getId()) + "\", " + cellPosition.x + ", " + cellPosition.y + ")";
                } else if (obj.getVtkObject() instanceof vtkActor) {
                    tmpLine = scriptTab + "pipeline.addActor(" + (String)exportedVtkObjCanonicalNameArray.get(obj.getId()) + ", \"" + (String)exportedVtkObjCanonicalNameArray.get(obj.getId()) + "\", " + cellPosition.x + ", " + cellPosition.y + ")";
                } else if (obj.getVtkObject() instanceof vtkScalarBarActor) {
                    tmpLine = scriptTab + "pipeline.addScalarBar(" + (String)exportedVtkObjCanonicalNameArray.get(obj.getId()) + ", \"" + (String)exportedVtkObjCanonicalNameArray.get(obj.getId()) + "\", " + cellPosition.x + ", " + cellPosition.y + ")";
                } else if (obj.getVtkObject() instanceof vtkLookupTable) {
                    tmpLine = scriptTab + "pipeline.addLookupTable(" + (String)exportedVtkObjCanonicalNameArray.get(obj.getId()) + ", \"" + (String)exportedVtkObjCanonicalNameArray.get(obj.getId()) + "\", " + cellPosition.x + ", " + cellPosition.y + ")";
                } else {
                    System.out.println("not supported yet ");
                }
                this.scriptCassandraReloadingSection = this.scriptCassandraReloadingSection + tmpLine + eol;
            }
        }
    }

    @Override
    public void setSelectedVtkObjectList(Hashtable selectedVtkObjectList) {
        this.selectedVtkObjectList = selectedVtkObjectList;
    }

    public boolean getCassandraContext() {
        return this.cassandraContext;
    }

    public void setCassandraReloadable(boolean cassandraReloadable) {
        this.cassandraContext = cassandraReloadable;
    }

    public String getScriptImportSectionRadical() {
        return this.scriptImportSectionRadical;
    }

    public void setScriptImportSectionRadical(String scriptImportSectionRadical) {
        this.scriptImportSectionRadical = scriptImportSectionRadical;
    }

    public String getScriptInstanciationSectionRadical() {
        return this.scriptInstanciationSectionRadical;
    }

    public void setScriptInstanciationSectionRadical(String scriptInstanciationSectionRadical) {
        this.scriptInstanciationSectionRadical = scriptInstanciationSectionRadical;
    }

    public String getScriptConnectivitySectionRadical() {
        return this.scriptConnectivitySectionRadical;
    }

    public void setScriptConnectivitySectionRadical(String scriptConnectivitySectionRadical) {
        this.scriptConnectivitySectionRadical = scriptConnectivitySectionRadical;
    }

    public String getScriptCassandraReloadingSectionRadical() {
        return this.scriptCassandraReloadingSectionRadical;
    }

    public void setScriptCassandraReloadingSectionRadical(String scriptCassandraReloadingSectionRadical) {
        this.scriptCassandraReloadingSectionRadical = scriptCassandraReloadingSectionRadical;
    }
}

