/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui;

import com.artenum.cassandra.action.CassandraActionListener;
import com.artenum.cassandra.plugin.DynamicPluginMenu;
import com.artenum.cassandra.ui.CassandraToolBar;
import com.artenum.cassandra.util.BookmarkManager;
import com.artenum.cassandra.util.RecentFilesManager;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class CassandraMenu
extends JMenuBar
implements DynamicPluginMenu {
    private CassandraActionListener listener;
    private ArrayList pluginClassNameList;
    private JMenu file;
    private JMenuItem open;
    private JMenuItem save;
    private BookmarkManager bookmarkManager;
    private RecentFilesManager recentFileManager;
    private JMenu openFromBookMark;
    private JMenuItem bookMarkPath;
    private JMenu importFile;
    private JMenu exportFile;
    private JMenu importPipeline;
    private JMenuItem importPipelineFromJython;
    private JMenu exportPipeline;
    private JMenuItem exportPipelineToJython;
    private JMenuItem saveImage;
    private JMenuItem exit;
    private JMenu edit;
    private JMenuItem loadPlugin;
    private JMenu view;
    private JCheckBoxMenuItem pipeLineManager;
    private JCheckBoxMenuItem renderer;
    private JCheckBoxMenuItem console;
    private JMenuItem setBg;
    private JMenuItem setAmbiantLight;
    private JCheckBoxMenuItem axis;
    private JMenuItem setTitle;
    private JCheckBoxMenuItem parallelProjection;
    private JMenu source;
    private JMenu filter;
    private JMenu tool;
    private JMenu help;
    private JMenuItem about;
    private CassandraToolBar mainToolBar;

    public CassandraMenu(CassandraActionListener listener) {
        this.listener = listener;
        this.pluginClassNameList = new ArrayList();
        listener.setDynamicPluginMenu(this);
        listener.setParentComponent(this);
        this.file = new JMenu("File");
        this.edit = new JMenu("Edit");
        this.view = new JMenu("View");
        this.source = new JMenu("Sources");
        this.filter = new JMenu("Filters");
        this.tool = new JMenu("Tools");
        this.help = new JMenu("Help");
        this.open = new JMenuItem("Open");
        this.open.setActionCommand("OPEN_VTK_FILE");
        this.open.addActionListener(listener);
        this.save = new JMenuItem("Save");
        this.save.setActionCommand("SAVE_VTK_FILE");
        this.save.addActionListener(listener);
        this.recentFileManager = new RecentFilesManager();
        this.recentFileManager.setAutoSave(false);
        this.recentFileManager.readFileListFromProperties();
        this.recentFileManager.setAutoSave(true);
        this.recentFileManager.addActionListener(listener);
        listener.setRecentFileManager(this.recentFileManager);
        this.bookmarkManager = new BookmarkManager();
        this.bookmarkManager.setAutoSave(false);
        this.bookmarkManager.readBookmarkListFromProperties();
        this.bookmarkManager.setAutoSave(true);
        this.bookmarkManager.addActionListener(listener);
        this.importFile = new JMenu("Import");
        this.importFile.setActionCommand("IMPORT_DATA_FILE");
        this.importFile.addActionListener(listener);
        this.exportFile = new JMenu("Export");
        this.exportFile.setActionCommand("EXPORT_DATA_FILE");
        this.exportFile.addActionListener(listener);
        this.importPipeline = new JMenu("Import Pipeline from");
        this.importPipelineFromJython = new JMenuItem("Jython");
        this.importPipelineFromJython.setActionCommand("import.pipeline.from.jython");
        this.importPipelineFromJython.addActionListener(listener);
        this.exportPipeline = new JMenu("Export Pipeline to");
        this.exportPipelineToJython = new JMenuItem("Jython");
        this.exportPipelineToJython.setActionCommand("export.pipeline.to.jython");
        this.exportPipelineToJython.addActionListener(listener);
        this.saveImage = new JMenuItem("Save image");
        this.saveImage.setActionCommand("SAVE_VTK_VIEW");
        this.saveImage.addActionListener(listener);
        this.exit = new JMenuItem("Exit");
        this.exit.setActionCommand("EXIT");
        this.exit.addActionListener(listener);
        this.file.add(this.open);
        this.file.add(this.save);
        this.file.addSeparator();
        this.file.add(this.recentFileManager);
        this.file.add(this.bookmarkManager);
        this.file.addSeparator();
        this.file.add(this.importFile);
        this.file.add(this.exportFile);
        this.file.addSeparator();
        this.file.add(this.importPipeline);
        this.importPipeline.add(this.importPipelineFromJython);
        this.file.add(this.exportPipeline);
        this.exportPipeline.add(this.exportPipelineToJython);
        this.file.addSeparator();
        this.file.add(this.saveImage);
        this.file.addSeparator();
        this.file.add(this.exit);
        this.loadPlugin = new JMenuItem("Load plugin");
        this.loadPlugin.setActionCommand("LOAD_PLUGIN");
        this.loadPlugin.addActionListener(listener);
        this.edit.addSeparator();
        this.edit.add(this.loadPlugin);
        this.pipeLineManager = new JCheckBoxMenuItem("View Pipeline");
        this.pipeLineManager.setActionCommand("PIPELINE");
        this.pipeLineManager.addActionListener(listener);
        this.pipeLineManager.setSelected(true);
        this.renderer = new JCheckBoxMenuItem("View renderer");
        this.renderer.setActionCommand("RENDERER");
        this.renderer.addActionListener(listener);
        this.renderer.setSelected(true);
        this.console = new JCheckBoxMenuItem("View console");
        this.console.setActionCommand("CONSOLE");
        this.console.addActionListener(listener);
        this.console.setSelected(false);
        this.setBg = new JMenuItem("Background color");
        this.setBg.setActionCommand("SET_BG_COLOR");
        this.setBg.addActionListener(listener);
        this.setAmbiantLight = new JMenuItem("Ambiant light");
        this.setAmbiantLight.setActionCommand("SET_AMBIANT_LIGHT");
        this.setAmbiantLight.addActionListener(listener);
        this.setTitle = new JMenuItem("Title");
        this.setTitle.setActionCommand("SET_TITLE");
        this.setTitle.addActionListener(listener);
        this.axis = new JCheckBoxMenuItem("View axis");
        this.axis.setActionCommand("AXIS");
        this.axis.addActionListener(listener);
        this.axis.setSelected(false);
        this.parallelProjection = new JCheckBoxMenuItem("Parallel projection");
        this.parallelProjection.setActionCommand("PARALLEL_PROJECTION");
        this.parallelProjection.addActionListener(listener);
        this.parallelProjection.setSelected(false);
        this.view.add(this.pipeLineManager);
        this.view.add(this.renderer);
        this.view.add(this.console);
        this.view.addSeparator();
        this.view.add(this.setAmbiantLight);
        this.view.add(this.setBg);
        this.view.add(this.parallelProjection);
        this.view.add(this.axis);
        this.about = new JMenuItem("About");
        this.about.setActionCommand("ABOUT_CASSANDRA");
        this.about.addActionListener(listener);
        this.help.add(this.about);
        this.add(this.file);
        this.add(this.edit);
        this.add(this.view);
        this.add(this.source);
        this.add(this.filter);
        this.add(this.tool);
        this.add(this.help);
    }

    @Override
    public void addImportMenuComponent(Component importComponent) {
        this.importFile.add(importComponent);
    }

    @Override
    public void addExportMenuComponent(Component exportComponent) {
        this.exportFile.add(exportComponent);
    }

    public void addRecentFileComponent(Component recentFile) {
        this.recentFileManager.add(recentFile);
    }

    @Override
    public void addSourceMenuComponent(Component sourceComponent) {
        this.source.add(sourceComponent);
    }

    @Override
    public void addFilterMenuComponent(Component filterComponent) {
        this.filter.add(filterComponent);
    }

    @Override
    public void addToolMenuComponent(Component toolComponent) {
        this.tool.add(toolComponent);
    }

    @Override
    public CassandraToolBar getMainToolBar() {
        return this.mainToolBar;
    }

    public void setMainToolBar(CassandraToolBar mainToolBar) {
        this.mainToolBar = mainToolBar;
    }
}

