/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import vtk.vtkAlgorithm;

public class ThreadedProgressBarDialog
extends Thread {
    vtkAlgorithm algorithm;
    double minProgressValue;
    double maxProgressValue;
    double progressValue;
    double nextTime;
    double samplingPeriod = 10.0;
    JLabel messageLabel;
    boolean cont = true;
    JPanel messagePanel;
    JProgressBar progressBar;
    double initTime;
    double endTime;
    JDialog dialogFrame;
    Thread controlThread;
    String message;

    public ThreadedProgressBarDialog() {
        this.nextTime = (double)System.currentTimeMillis() + this.samplingPeriod;
        this.initTime = System.currentTimeMillis();
        this.endTime = this.initTime + 20000.0;
    }

    public ThreadedProgressBarDialog(vtkAlgorithm algorithm) {
        this.algorithm = algorithm;
        this.minProgressValue = this.algorithm.GetProgressMinValue();
        this.maxProgressValue = this.algorithm.GetProgressMaxValue();
        this.nextTime = (double)System.currentTimeMillis() + this.samplingPeriod;
        this.initTime = System.currentTimeMillis();
        this.endTime = this.initTime + 20000.0;
    }

    public void setProgressMinValue(double min) {
        this.minProgressValue = min;
    }

    public void setProgressMaxValue(double max) {
        this.maxProgressValue = max;
    }

    public void showDialog(Frame owner, String message) {
        this.dialogFrame = new JDialog(owner);
        this.dialogFrame.getContentPane().setLayout(new BorderLayout());
        this.messagePanel = new JPanel();
        this.messagePanel.setLayout(new BorderLayout());
        this.messageLabel = new JLabel("no message");
        this.messageLabel.setHorizontalAlignment(0);
        this.messagePanel.add((Component)this.messageLabel, "Center");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        this.progressBar.setIndeterminate(true);
        this.dialogFrame.getContentPane().add((Component)this.messagePanel, "Center");
        this.dialogFrame.getContentPane().add((Component)this.progressBar, "South");
        this.dialogFrame.setSize(300, 150);
        this.dialogFrame.setLocationRelativeTo(null);
        this.dialogFrame.setVisible(true);
    }

    public void close() {
        this.cont = false;
        this.dialogFrame.dispose();
    }

    public void setMessage(String message) {
        this.message = message;
        this.messageLabel.setText(message);
    }

    public void setProgressValue(double progressValue) {
        this.progressValue = progressValue;
    }

    @Override
    public void run() {
        while (this.cont) {
            if ((double)System.currentTimeMillis() > this.nextTime) {
                this.nextTime = (double)System.currentTimeMillis() + this.samplingPeriod;
            }
            this.messageLabel.setText(this.message);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue((int)(this.progressValue * (this.maxProgressValue - this.minProgressValue) * 100.0));
            if (this.progressValue != this.maxProgressValue) continue;
            this.cont = false;
        }
        this.close();
    }
}

