/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.popup;

import com.artenum.cassandra.action.menu.RenameVtkObject;
import com.artenum.cassandra.pipeline.CascadeRemoveManager;
import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.ui.popup.VtkObjectPopupMenu;
import com.artenum.cassandra.util.VtkObjectInformationPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkScalarsToColors;

public class MapperPopupMenu
extends JPopupMenu
implements ActionListener,
VtkObjectPopupMenu {
    public static final String MAPPER_SCALAR_VISIBILITY = "mapper.scalar.visibility";
    public static final String MAPPER_INTERPOLATE_BEFORE = "mapper.interpolate.before";
    public static final String MAPPER_GET_INFO = "mapper.get.info";
    public static final String MAPPER_REMOVE = "mapper.remove";
    private PipeLineManager pipeLineManager;
    private CascadeRemoveManager cascadeRemoveManager;
    private CassandraObject currentVtkObject;
    private JCheckBoxMenuItem viewScalarData;
    private JCheckBoxMenuItem interpolateScalarsBeforeMapping;
    private JCheckBoxMenuItem chooseLookupTable;
    private RenameVtkObject mapperRename;
    private JMenuItem mapperGetInfo;
    private JMenuItem mapperRemove;
    private JMenu lookupTableList;

    public MapperPopupMenu(PipeLineManager pipeLineManager, CascadeRemoveManager cascadeRemoveManager) {
        this.pipeLineManager = pipeLineManager;
        this.cascadeRemoveManager = cascadeRemoveManager;
        this.viewScalarData = new JCheckBoxMenuItem("View scalar data");
        this.viewScalarData.setActionCommand(MAPPER_SCALAR_VISIBILITY);
        this.viewScalarData.addActionListener(this);
        this.add(this.viewScalarData);
        this.interpolateScalarsBeforeMapping = new JCheckBoxMenuItem("Interpolate before mpping");
        this.interpolateScalarsBeforeMapping.setActionCommand(MAPPER_INTERPOLATE_BEFORE);
        this.interpolateScalarsBeforeMapping.addActionListener(this);
        this.add(this.interpolateScalarsBeforeMapping);
        this.lookupTableList = new JMenu("Link to lookup table...");
        this.add(this.lookupTableList);
        this.mapperRename = new RenameVtkObject("Rename", "Rename mapper", null);
        this.add(this.mapperRename);
        this.mapperGetInfo = new JMenuItem("Get information");
        this.mapperGetInfo.setActionCommand(MAPPER_GET_INFO);
        this.mapperGetInfo.addActionListener(this);
        this.add(this.mapperGetInfo);
        this.addSeparator();
        this.mapperRemove = new JMenuItem("Remove");
        this.mapperRemove.setActionCommand(MAPPER_REMOVE);
        this.mapperRemove.addActionListener(this);
        this.add(this.mapperRemove);
    }

    private void updateLookupTableList() {
        CassandraObject lookupTable2 = null;
        this.lookupTableList.removeAll();
        JMenuItem item = null;
        for (CassandraObject lookupTable2 : this.pipeLineManager.getLookupTableList().getData()) {
            item = new JMenuItem(lookupTable2.getName());
            item.addActionListener(new LookupTableSetter((vtkLookupTable)lookupTable2.getVtkObject()));
            this.lookupTableList.add(item);
        }
    }

    @Override
    public void setCurrentVtkOject(CassandraObject currentVtkObject) {
        this.currentVtkObject = currentVtkObject;
        this.mapperRename.setVtkObject(currentVtkObject);
        this.updateLookupTableList();
        this.viewScalarData.setSelected(((vtkMapper)currentVtkObject.getVtkObject()).GetScalarVisibility() == 1);
        this.interpolateScalarsBeforeMapping.setSelected(((vtkMapper)currentVtkObject.getVtkObject()).GetInterpolateScalarsBeforeMapping() == 1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(MAPPER_SCALAR_VISIBILITY)) {
            ((vtkMapper)this.currentVtkObject.getVtkObject()).SetScalarVisibility((((vtkMapper)this.currentVtkObject.getVtkObject()).GetScalarVisibility() + 1) % 2);
            this.pipeLineManager.validateViewAndGo();
        } else if (command.equals(MAPPER_GET_INFO)) {
            VtkObjectInformationPane infoPane = new VtkObjectInformationPane(this.currentVtkObject);
            infoPane.showMessageDialog();
        } else if (command.equals(MAPPER_REMOVE)) {
            this.cascadeRemoveManager.removeMapper(this.currentVtkObject);
        } else if (command.equals(MAPPER_INTERPOLATE_BEFORE)) {
            ((vtkMapper)this.currentVtkObject.getVtkObject()).SetInterpolateScalarsBeforeMapping((((vtkMapper)this.currentVtkObject.getVtkObject()).GetInterpolateScalarsBeforeMapping() + 1) % 2);
            this.pipeLineManager.validateViewAndGo();
        }
    }

    private class LookupTableSetter
    implements ActionListener {
        private vtkLookupTable lookupTable;

        public LookupTableSetter(vtkLookupTable lookupTable) {
            this.lookupTable = lookupTable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((vtkMapper)MapperPopupMenu.this.currentVtkObject.getVtkObject()).SetLookupTable((vtkScalarsToColors)this.lookupTable);
            MapperPopupMenu.this.pipeLineManager.notifyConnectivityChange(MapperPopupMenu.this.currentVtkObject);
            MapperPopupMenu.this.pipeLineManager.validateViewAndGo();
        }
    }
}

