/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.util;

import vtk.vtkActor;
import vtk.vtkContourFilter;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolyDataNormals;

public class IsoLevelPipeLine {
    private vtkDataSet dataset;
    private vtkPolyDataMapper mapper;
    private vtkActor actor;
    private double level;
    private boolean normal;
    private vtkContourFilter contour;
    private vtkPolyDataNormals normals;

    public IsoLevelPipeLine(vtkDataSet dataset, double level, boolean normal) {
        this.dataset = dataset;
        this.level = level;
        this.normal = normal;
        this.contour = new vtkContourFilter();
        this.contour.SetValue(0, level);
        this.contour.SetInput((vtkDataObject)dataset);
        this.normals = new vtkPolyDataNormals();
        this.normals.SetInput((vtkDataObject)this.contour.GetOutput());
        this.normals.SetFeatureAngle(45.0);
        this.mapper = new vtkPolyDataMapper();
        if (dataset.GetPointData().GetScalars() != null) {
            this.mapper.SetScalarRange(dataset.GetPointData().GetScalars().GetRange());
        }
        this.mapper.ScalarVisibilityOn();
        this.mapper.ColorByArrayComponent("Magnitude", 0);
        this.setNormal(normal);
        this.actor = new vtkActor();
        this.actor.SetMapper((vtkMapper)this.mapper);
        dataset.Update();
    }

    public void setNormal(boolean normalFlag) {
        if (normalFlag) {
            if (this.normals.GetOutput() != null) {
                this.mapper.SetInput(this.normals.GetOutput());
            } else {
                System.out.println("No data to generate normals for!");
                this.mapper.SetInput(this.contour.GetOutput());
            }
        } else {
            this.mapper.SetInput(this.contour.GetOutput());
        }
        this.dataset.Update();
    }

    public void setLevel(double level) {
        this.level = level;
        this.contour.SetValue(0, level);
        this.contour.Update();
    }

    public void updatePipeLine() {
        this.dataset.Update();
    }

    public vtkActor getActor() {
        return this.actor;
    }

    public vtkDataSet getDataset() {
        return this.dataset;
    }

    public vtkMapper getMapper() {
        return this.mapper;
    }
}

