/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.vtk;

import com.artenum.penelope.field.interfaces.DataField;
import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.interfaces.Polyhedron;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.mesh.iterator.SingleVertexIterator;
import com.artenum.penelope.plugin.vtk.VtkDataSetBuilder;
import com.artenum.penelope.plugin.vtk.VtkGridBuilder;
import com.artenum.penelope.plugin.vtk.VtkToolBox;
import java.util.Iterator;
import vtk.vtkDataSet;
import vtk.vtkUnstructuredGrid;

public class PolyhedronVtkDataSetBuilder
implements VtkDataSetBuilder<Polyhedron> {
    public static final int VTK_TYPE_CELL = 10;
    private VtkGridBuilder gridBuilder;

    @Override
    public vtkDataSet buildVtkDataSet(DataField<?, Polyhedron> datafield, MeshType localisation) {
        vtkUnstructuredGrid polyhedronDataSet = this.buildVtkUnstructuredGrid(datafield, localisation);
        polyhedronDataSet.GetCellData().SetScalars(VtkToolBox.mapData(datafield));
        return polyhedronDataSet;
    }

    @Override
    public vtkUnstructuredGrid buildVtkUnstructuredGrid(DataField<?, Polyhedron> datafield, MeshType localisation) {
        vtkUnstructuredGrid grid = null;
        if (localisation != MeshType.POLYHEDRON) {
            throw new UnsupportedOperationException("Unsupported visualisation location: " + localisation);
        }
        Iterator meshElementIterator = datafield.getMeshMask().getMeshElementIterator();
        SingleVertexIterator vertexIterator = new SingleVertexIterator(meshElementIterator);
        Iterator meshElementIterator2 = datafield.getMeshMask().getMeshElementIterator();
        this.gridBuilder = new VtkGridBuilder((Iterator<Vertex>)vertexIterator, meshElementIterator2, localisation);
        grid = this.gridBuilder.buildVtkUnstructuredGrid();
        return grid;
    }

    @Override
    public MeshType[] getAvailableVisualisationLocations() {
        return new MeshType[]{MeshType.POLYHEDRON};
    }

    @Override
    public VtkGridBuilder getGridBuilder() {
        return this.gridBuilder;
    }
}

