/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.vtk;

import com.artenum.penelope.field.interfaces.DataField;
import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.mesh.iterator.SingleEdgeIteratorFromVertexIds;
import com.artenum.penelope.mesh.iterator.SingleFaceIteratorFromVertexIds;
import com.artenum.penelope.mesh.iterator.SinglePolyhedronIteratorFromVertexIds;
import com.artenum.penelope.plugin.vtk.VtkDataSetBuilder;
import com.artenum.penelope.plugin.vtk.VtkGridBuilder;
import com.artenum.penelope.plugin.vtk.VtkToolBox;
import java.util.Iterator;
import vtk.vtkDataSet;
import vtk.vtkUnstructuredGrid;

public class VertexVtkDataSetBuilder
implements VtkDataSetBuilder<Vertex> {
    private VtkGridBuilder gridBuilder;

    @Override
    public vtkDataSet buildVtkDataSet(DataField<?, Vertex> datafield, MeshType localisation) {
        vtkUnstructuredGrid vertexDataSet = this.buildVtkUnstructuredGrid(datafield, localisation);
        vertexDataSet.GetPointData().SetScalars(VtkToolBox.mapData(datafield));
        return vertexDataSet;
    }

    @Override
    public vtkUnstructuredGrid buildVtkUnstructuredGrid(DataField<?, Vertex> datafield, MeshType localisation) {
        vtkUnstructuredGrid buildVtkUnstructuredGrid;
        this.gridBuilder = null;
        Mesh mesh = datafield.getMeshMask().getMesh();
        int[] vertexIds = datafield.getMeshMask().getMeshElementIds();
        switch (localisation) {
            case VERTEX: {
                Iterator meshElementIterator = datafield.getMeshMask().getMeshElementIterator();
                this.gridBuilder = new VtkGridBuilder(meshElementIterator, null, MeshType.VERTEX);
                buildVtkUnstructuredGrid = this.gridBuilder.buildVtkUnstructuredGrid();
                meshElementIterator = null;
                break;
            }
            case EDGE: {
                SingleEdgeIteratorFromVertexIds edgeIterator = new SingleEdgeIteratorFromVertexIds(mesh, vertexIds);
                this.gridBuilder = new VtkGridBuilder(datafield.getMeshMask().getMeshElementIterator(), (Iterator<? extends Edge>)edgeIterator, MeshType.EDGE);
                buildVtkUnstructuredGrid = this.gridBuilder.buildVtkUnstructuredGrid();
                edgeIterator.clear();
                edgeIterator = null;
                break;
            }
            case FACE: {
                SingleFaceIteratorFromVertexIds faceIterator = new SingleFaceIteratorFromVertexIds(mesh, vertexIds);
                this.gridBuilder = new VtkGridBuilder(datafield.getMeshMask().getMeshElementIterator(), (Iterator<? extends Edge>)faceIterator, MeshType.FACE);
                buildVtkUnstructuredGrid = this.gridBuilder.buildVtkUnstructuredGrid();
                faceIterator.clear();
                faceIterator = null;
                break;
            }
            case POLYHEDRON: {
                SinglePolyhedronIteratorFromVertexIds polyhedronIterator = new SinglePolyhedronIteratorFromVertexIds(mesh, vertexIds);
                this.gridBuilder = new VtkGridBuilder(datafield.getMeshMask().getMeshElementIterator(), (Iterator<? extends Edge>)polyhedronIterator, MeshType.POLYHEDRON);
                buildVtkUnstructuredGrid = this.gridBuilder.buildVtkUnstructuredGrid();
                polyhedronIterator.clear();
                polyhedronIterator = null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported visualisation location: " + localisation);
            }
        }
        return buildVtkUnstructuredGrid;
    }

    @Override
    public MeshType[] getAvailableVisualisationLocations() {
        return MeshType.values();
    }

    @Override
    public VtkGridBuilder getGridBuilder() {
        return this.gridBuilder;
    }
}

