/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.cutter;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObjectListModel;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.cutter.CutterPlugin;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataListener;
import vtk.vtkDataSet;

public class CutterControlUI
extends PlugInControlUI {
    private PipeLineManager pipeLineManager;
    private JComboBox input;
    private JTabbedPane tab;
    private JFormattedTextField planeCenterX;
    private JFormattedTextField planeCenterY;
    private JFormattedTextField planeCenterZ;
    private JFormattedTextField planeNormalX;
    private JFormattedTextField planeNormalY;
    private JFormattedTextField planeNormalZ;
    private JSlider planeSlider;
    private JFormattedTextField sphereCenterX;
    private JFormattedTextField sphereCenterY;
    private JFormattedTextField sphereCenterZ;
    private JFormattedTextField sphereRadius;
    private JFormattedTextField cylinderCenterX;
    private JFormattedTextField cylinderCenterY;
    private JFormattedTextField cylinderCenterZ;
    private JFormattedTextField cylinderRx;
    private JFormattedTextField cylinderRy;
    private JFormattedTextField cylinderRz;
    private JFormattedTextField cylinderRadius;
    private CutterPlugin plugin;

    public CutterControlUI(PipeLineManager pipeLineManager, CutterPlugin plugin, Frame owner) {
        super(owner, "Generic cutter configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = plugin;
        this.input = new JComboBox(new DataSetListModel(pipeLineManager.getDataSetList()));
        JPanel line1 = new JPanel();
        line1.setLayout(new BoxLayout(line1, 2));
        line1.add(new JLabel("Input Dataset"));
        line1.add(this.input);
        JPanel planeCutPanel = new JPanel();
        planeCutPanel.setLayout(new BoxLayout(planeCutPanel, 3));
        this.planeCenterX = new JFormattedTextField((Object)"0");
        this.planeCenterX.setValue(new Double(0.0));
        this.planeCenterY = new JFormattedTextField((Object)"0");
        this.planeCenterY.setValue(new Double(0.0));
        this.planeCenterZ = new JFormattedTextField((Object)"0");
        this.planeCenterZ.setValue(new Double(0.0));
        this.planeNormalX = new JFormattedTextField((Object)"0");
        this.planeNormalX.setValue(new Double(0.0));
        this.planeNormalY = new JFormattedTextField((Object)"0");
        this.planeNormalY.setValue(new Double(0.0));
        this.planeNormalZ = new JFormattedTextField((Object)"0");
        this.planeNormalZ.setValue(new Double(1.0));
        JPanel grid = new JPanel(new GridLayout(3, 4));
        grid.add(new JLabel());
        grid.add(new JLabel("X"));
        grid.add(new JLabel("Y"));
        grid.add(new JLabel("Z"));
        grid.add(new JLabel("Center"));
        grid.add(this.planeCenterX);
        grid.add(this.planeCenterY);
        grid.add(this.planeCenterZ);
        grid.add(new JLabel("Normal"));
        grid.add(this.planeNormalX);
        grid.add(this.planeNormalY);
        grid.add(this.planeNormalZ);
        Hashtable<Integer, JLabel> label = new Hashtable<Integer, JLabel>();
        label.put(new Integer(-10), new JLabel("-1"));
        label.put(new Integer(10), new JLabel("1"));
        label.put(new Integer(0), new JLabel("0"));
        this.planeSlider = new JSlider(-10, 10, 0);
        this.planeSlider.setMinorTickSpacing(1);
        this.planeSlider.setMajorTickSpacing(10);
        this.planeSlider.setLabelTable(label);
        this.planeSlider.setPaintLabels(true);
        this.planeSlider.setPaintLabels(true);
        this.planeSlider.addChangeListener((ChangeListener)((Object)this));
        this.planeSlider.setToolTipText("Translation based on center point with the normal vector has unit");
        planeCutPanel.add(grid);
        planeCutPanel.add(this.planeSlider);
        JPanel sphereCutPanel = new JPanel();
        sphereCutPanel.setLayout(new BoxLayout(sphereCutPanel, 3));
        this.sphereCenterX = new JFormattedTextField((Object)"0");
        this.sphereCenterX.setValue(new Double(0.0));
        this.sphereCenterY = new JFormattedTextField((Object)"0");
        this.sphereCenterY.setValue(new Double(0.0));
        this.sphereCenterZ = new JFormattedTextField((Object)"0");
        this.sphereCenterZ.setValue(new Double(0.0));
        this.sphereRadius = new JFormattedTextField((Object)"0");
        this.sphereRadius.setValue(new Double(1.0));
        grid = new JPanel(new GridLayout(3, 4));
        grid.add(new JLabel());
        grid.add(new JLabel("X"));
        grid.add(new JLabel("Y"));
        grid.add(new JLabel("Z"));
        grid.add(new JLabel("Center"));
        grid.add(this.sphereCenterX);
        grid.add(this.sphereCenterY);
        grid.add(this.sphereCenterZ);
        grid.add(new JLabel("Radius"));
        grid.add(this.sphereRadius);
        sphereCutPanel.add(grid);
        JPanel cylinderCutPanel = new JPanel();
        cylinderCutPanel.setLayout(new BoxLayout(cylinderCutPanel, 3));
        this.cylinderCenterX = new JFormattedTextField((Object)"0");
        this.cylinderCenterX.setValue(new Double(0.0));
        this.cylinderCenterY = new JFormattedTextField((Object)"0");
        this.cylinderCenterY.setValue(new Double(0.0));
        this.cylinderCenterZ = new JFormattedTextField((Object)"0");
        this.cylinderCenterZ.setValue(new Double(0.0));
        this.cylinderRx = new JFormattedTextField((Object)"0");
        this.cylinderRx.setValue(new Double(0.0));
        this.cylinderRy = new JFormattedTextField((Object)"0");
        this.cylinderRy.setValue(new Double(0.0));
        this.cylinderRz = new JFormattedTextField((Object)"0");
        this.cylinderRz.setValue(new Double(0.0));
        this.cylinderRadius = new JFormattedTextField((Object)"0");
        this.cylinderRadius.setValue(new Double(1.0));
        grid = new JPanel(new GridLayout(3, 4));
        grid.add(new JLabel());
        grid.add(new JLabel("X"));
        grid.add(new JLabel("Y"));
        grid.add(new JLabel("Z"));
        grid.add(new JLabel("Center"));
        grid.add(this.cylinderCenterX);
        grid.add(this.cylinderCenterY);
        grid.add(this.cylinderCenterZ);
        grid.add(new JLabel("Rotate"));
        grid.add(this.cylinderRx);
        grid.add(this.cylinderRy);
        grid.add(this.cylinderRz);
        JPanel line = new JPanel();
        line.setLayout(new BoxLayout(line, 2));
        line.add(new JLabel("Radius"));
        line.add(this.cylinderRadius);
        cylinderCutPanel.add(grid);
        cylinderCutPanel.add(line);
        JButton exec = new JButton("Update");
        exec.setActionCommand("UPDATE");
        exec.addActionListener((ActionListener)((Object)this));
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener((ActionListener)((Object)this));
        JPanel cmdLine = new JPanel();
        cmdLine.setLayout(new BoxLayout(cmdLine, 2));
        cmdLine.add(Box.createHorizontalGlue());
        cmdLine.add(exec);
        cmdLine.add(cancel);
        this.tab = new JTabbedPane();
        this.tab.add("Plane", planeCutPanel);
        this.tab.add("Sphere", sphereCutPanel);
        this.tab.add("Cylinder", cylinderCutPanel);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(line1);
        this.getContentPane().add(this.tab);
        this.getContentPane().add(cmdLine);
        this.pack();
        Dimension size = this.getSize();
        size.setSize(size.getWidth() + 100.0, size.getHeight());
        this.setSize(size);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("UPDATE")) {
            if (this.input.getSelectedItem() == null) {
                return;
            }
            switch (this.tab.getSelectedIndex()) {
                case 0: {
                    this.planeSlider.setValue(0);
                    this.plugin.updateCuttingPlane(((Number)this.planeCenterX.getValue()).doubleValue(), ((Number)this.planeCenterY.getValue()).doubleValue(), ((Number)this.planeCenterZ.getValue()).doubleValue(), ((Number)this.planeNormalX.getValue()).doubleValue(), ((Number)this.planeNormalY.getValue()).doubleValue(), ((Number)this.planeNormalZ.getValue()).doubleValue(), (vtkDataSet)((CassandraObject)this.input.getSelectedItem()).getVtkObject());
                    break;
                }
                case 1: {
                    this.plugin.updateCuttingSphere(((Number)this.sphereCenterX.getValue()).doubleValue(), ((Number)this.sphereCenterY.getValue()).doubleValue(), ((Number)this.sphereCenterZ.getValue()).doubleValue(), ((Number)this.sphereRadius.getValue()).doubleValue(), (vtkDataSet)((CassandraObject)this.input.getSelectedItem()).getVtkObject());
                    break;
                }
                case 2: {
                    this.plugin.updateCuttingCylinder(((Number)this.cylinderCenterX.getValue()).doubleValue(), ((Number)this.cylinderCenterY.getValue()).doubleValue(), ((Number)this.cylinderCenterZ.getValue()).doubleValue(), ((Number)this.cylinderRx.getValue()).doubleValue(), ((Number)this.cylinderRy.getValue()).doubleValue(), ((Number)this.cylinderRz.getValue()).doubleValue(), ((Number)this.cylinderRadius.getValue()).doubleValue(), (vtkDataSet)((CassandraObject)this.input.getSelectedItem()).getVtkObject());
                    break;
                }
            }
            this.pipeLineManager.validateViewAndGo();
        }
        if (command.equals("CANCEL")) {
            this.dispose();
        }
    }

    public void stateChanged(ChangeEvent e) {
        double value = (double)this.planeSlider.getValue() / 10.0;
        double nx = ((Number)this.planeNormalX.getValue()).doubleValue();
        double ny = ((Number)this.planeNormalY.getValue()).doubleValue();
        double nz = ((Number)this.planeNormalZ.getValue()).doubleValue();
        double cx = ((Number)this.planeCenterX.getValue()).doubleValue();
        double cy = ((Number)this.planeCenterY.getValue()).doubleValue();
        double cz = ((Number)this.planeCenterZ.getValue()).doubleValue();
        if (this.input.getSelectedItem() != null) {
            this.plugin.updateCuttingPlane(cx + nx * value, cy + ny * value, cz + nz * value, nx, ny, nz, (vtkDataSet)((CassandraObject)this.input.getSelectedItem()).getVtkObject());
            this.pipeLineManager.validateViewAndGo();
        }
    }

    public void itemStateChanged(ItemEvent arg0) {
    }

    class DataSetListModel
    implements ComboBoxModel {
        private VtkObjectListModel datasetModel;
        private Object selectedItem;

        public DataSetListModel(VtkObjectListModel datasetModel) {
            this.datasetModel = datasetModel;
        }

        @Override
        public Object getElementAt(int index) {
            return this.datasetModel.getElementAt(index);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public int getSize() {
            return this.datasetModel.getSize();
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectedItem = anItem;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.datasetModel.addListDataListener(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.datasetModel.removeListDataListener(l);
        }
    }
}

