/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.x3dexporter;

import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.CassandraPlugInProperty;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.x3dexporter.X3DExporterControlUI;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import vtk.vtkX3DExporter;

public class X3DExporterPlugin
implements CassandraPlugin {
    private String name = "3D Exporter Plugin";
    private Frame owner;
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private Filter filterImpl;
    private X3DExporterControlUI controlUI;

    public X3DExporterPlugin() {
    }

    public X3DExporterPlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this();
        this.pipelineManager = pipelineManager;
        this.pluginManager = pluginManager;
        this.owner = owner;
        this.controlUI = new X3DExporterControlUI();
    }

    public void update() {
        int fileType = this.controlUI.showSelectionBinaryPanel();
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        if (fileType == 1) {
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".x3db");
                }

                @Override
                public String getDescription() {
                    return "X3D files (x3d)";
                }
            });
        } else {
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".x3d");
                }

                @Override
                public String getDescription() {
                    return "X3D files (x3d)";
                }
            });
        }
        if (chooser.showSaveDialog(this.owner) == 0) {
            String fileX3D = chooser.getSelectedFile().getAbsolutePath();
            try {
                if (!fileX3D.toLowerCase().endsWith(".x3d") && !fileX3D.toLowerCase().endsWith(".x3db")) {
                    fileX3D = fileType == 1 ? fileX3D + ".x3db" : fileX3D + ".x3d";
                }
                this.export(fileX3D, fileType);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.owner, "Unable to save: " + fileX3D);
            }
        }
    }

    public void export(String fileX3D, int exportType) {
        System.out.println("Exporting to X3D...");
        vtkX3DExporter exporter = new vtkX3DExporter();
        System.out.println(fileX3D);
        exporter.SetFileName(fileX3D);
        if (exportType == 1) {
            System.out.println("BINARY EXPORT");
            exporter.BinaryOn();
        } else {
            System.out.println("ASCII EXPORT");
            exporter.BinaryOff();
        }
        exporter.SetInput(this.pipelineManager.getCassandraView().GetRenderWindow());
        exporter.Update();
        exporter.Write();
        System.out.println("DONE");
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public JPopupMenu getContextualMenu() {
        return null;
    }

    public void remove() {
    }

    public Filter getInternalFilter() {
        return this.filterImpl;
    }

    public PlugInControlUI getControlUI() {
        return null;
    }

    public CassandraPlugInProperty getPlugInProperty() {
        return null;
    }

    public void initAndUpdate(CassandraPlugInProperty prop) {
    }
}

