/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.info2d;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.info2d.Infos2DPlugin;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import vtk.vtkDataSet;

public class Info2DControlUI
extends PlugInControlUI {
    private PipeLineManager pipeLineManager;
    private Infos2DPlugin plugin;
    private VtkObjectComboBoxModel datasetModel;
    private JComboBox inputDataset;
    private JComboBox dataToShow;

    public Info2DControlUI(PipeLineManager pipeLineManager, Infos2DPlugin plugin, Frame owner) {
        super(owner, "Info 2D configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = plugin;
        this.datasetModel = new VtkObjectComboBoxModel(pipeLineManager.getDataSetList(), null);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel line = new JPanel(new BorderLayout());
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Input dataset"));
        this.inputDataset = new JComboBox(this.datasetModel);
        line.add((Component)this.inputDataset, "Center");
        line.setMaximumSize(new Dimension(10000, this.inputDataset.getHeight()));
        this.getContentPane().add(line);
        line = new JPanel(new BorderLayout());
        line.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(line);
        line = new JPanel(new BorderLayout());
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Data type to show"));
        this.dataToShow = new JComboBox<String>(new String[]{"Ids", "Data field", "Normal", "Scalar", "Coord", "Tensor", "Vector"});
        line.add((Component)this.dataToShow, "Center");
        line.setMaximumSize(new Dimension(10000, this.dataToShow.getHeight()));
        this.getContentPane().add(line);
        line = new JPanel(new BorderLayout());
        line.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(line);
        line = new JPanel();
        JButton update = new JButton("Update");
        update.setActionCommand("UPDATE");
        update.addActionListener((ActionListener)((Object)this));
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener((ActionListener)((Object)this));
        line.setLayout(new BoxLayout(line, 2));
        line.add(Box.createHorizontalGlue());
        line.add(update);
        line.add(cancel);
        this.getContentPane().add(line);
        this.pack();
        Dimension d = this.getSize();
        this.setSize(300, d.height);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("UPDATE")) {
            if (this.inputDataset.getSelectedItem() != null) {
                this.plugin.updateInfo2D((vtkDataSet)((CassandraObject)this.datasetModel.getSelectedItem()).getVtkObject(), this.dataToShow.getSelectedIndex());
                this.pipeLineManager.validateViewAndGo();
            }
        } else if (command.equals("CANCEL")) {
            this.dispose();
        }
    }

    public void stateChanged(ChangeEvent arg0) {
    }

    public void itemStateChanged(ItemEvent arg0) {
    }
}

