/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui;

import com.artenum.cassandra.pipeline.SimplePipeLineManager;
import vtk.vtkActor;
import vtk.vtkAssembly;
import vtk.vtkAxes;
import vtk.vtkConeSource;
import vtk.vtkDataObject;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkProp3D;
import vtk.vtkTextActor;
import vtk.vtkTubeFilter;

public class DefaultAxes {
    private final double axisLength = 0.8;
    private final SimplePipeLineManager pipelineManager;
    private final vtkTextActor xactor;
    private final vtkTextActor yactor;
    private final vtkTextActor zactor;
    private final vtkConeSource xcone;
    private final vtkConeSource ycone;
    private final vtkConeSource zcone;
    private final vtkAssembly assembly;

    public DefaultAxes(SimplePipeLineManager pipelineManager) {
        this.pipelineManager = pipelineManager;
        vtkAxes axes = new vtkAxes();
        axes.SetOrigin(0.0, 0.0, 0.0);
        axes.SetScaleFactor(this.axisLength);
        this.xactor = new vtkTextActor();
        this.yactor = new vtkTextActor();
        this.zactor = new vtkTextActor();
        this.xactor.SetInput("X");
        this.yactor.SetInput("Y");
        this.zactor.SetInput("Z");
        this.xactor.SetTextScaleMode(1);
        this.yactor.SetTextScaleMode(1);
        this.zactor.SetTextScaleMode(1);
        this.xactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.yactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.zactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.xactor.GetPositionCoordinate().SetValue(this.axisLength, 0.0, 0.0);
        this.yactor.GetPositionCoordinate().SetValue(0.0, this.axisLength, 0.0);
        this.zactor.GetPositionCoordinate().SetValue(0.0, 0.0, this.axisLength);
        this.xactor.GetTextProperty().SetColor(1.0, 1.0, 1.0);
        this.xactor.GetTextProperty().ShadowOn();
        this.xactor.GetTextProperty().ItalicOn();
        this.xactor.GetTextProperty().BoldOff();
        this.yactor.GetTextProperty().SetColor(1.0, 1.0, 1.0);
        this.yactor.GetTextProperty().ShadowOn();
        this.yactor.GetTextProperty().ItalicOn();
        this.yactor.GetTextProperty().BoldOff();
        this.zactor.GetTextProperty().SetColor(1.0, 1.0, 1.0);
        this.zactor.GetTextProperty().ShadowOn();
        this.zactor.GetTextProperty().ItalicOn();
        this.zactor.GetTextProperty().BoldOff();
        this.xactor.SetMaximumLineHeight(0.25);
        this.yactor.SetMaximumLineHeight(0.25);
        this.zactor.SetMaximumLineHeight(0.25);
        vtkTubeFilter tube = new vtkTubeFilter();
        tube.SetInput((vtkDataObject)axes.GetOutput());
        tube.SetRadius(0.05);
        tube.SetNumberOfSides(8);
        vtkPolyDataMapper tubeMapper = new vtkPolyDataMapper();
        tubeMapper.SetInput(tube.GetOutput());
        vtkActor tubeActor = new vtkActor();
        tubeActor.SetMapper((vtkMapper)tubeMapper);
        tubeActor.PickableOff();
        int coneRes = 12;
        double coneScale = 0.3;
        this.xcone = new vtkConeSource();
        this.xcone.SetResolution(12);
        vtkPolyDataMapper xconeMapper = new vtkPolyDataMapper();
        xconeMapper.SetInput(this.xcone.GetOutput());
        vtkActor xconeActor = new vtkActor();
        xconeActor.SetMapper((vtkMapper)xconeMapper);
        xconeActor.GetProperty().SetColor(1.0, 0.0, 0.0);
        xconeActor.SetScale(0.3, 0.3, 0.3);
        xconeActor.SetPosition(this.axisLength, 0.0, 0.0);
        this.ycone = new vtkConeSource();
        this.ycone.SetResolution(12);
        vtkPolyDataMapper yconeMapper = new vtkPolyDataMapper();
        yconeMapper.SetInput(this.ycone.GetOutput());
        vtkActor yconeActor = new vtkActor();
        yconeActor.SetMapper((vtkMapper)yconeMapper);
        yconeActor.GetProperty().SetColor(1.0, 1.0, 0.0);
        yconeActor.RotateZ(90.0);
        yconeActor.SetScale(0.3, 0.3, 0.3);
        yconeActor.SetPosition(0.0, this.axisLength, 0.0);
        this.zcone = new vtkConeSource();
        this.zcone.SetResolution(12);
        vtkPolyDataMapper zconeMapper = new vtkPolyDataMapper();
        zconeMapper.SetInput(this.zcone.GetOutput());
        vtkActor zconeActor = new vtkActor();
        zconeActor.SetMapper((vtkMapper)zconeMapper);
        zconeActor.GetProperty().SetColor(0.0, 1.0, 0.0);
        zconeActor.RotateY(-90.0);
        zconeActor.SetScale(0.3, 0.3, 0.3);
        zconeActor.SetPosition(0.0, 0.0, this.axisLength);
        this.assembly = new vtkAssembly();
        this.assembly.AddPart((vtkProp3D)tubeActor);
        this.assembly.AddPart((vtkProp3D)xconeActor);
        this.assembly.AddPart((vtkProp3D)yconeActor);
        this.assembly.AddPart((vtkProp3D)zconeActor);
    }

    public void setVisible(boolean view) {
        if (view) {
            this.pipelineManager.getCassandraView().GetRenderer().AddActor2D((vtkProp)this.xactor);
            this.pipelineManager.getCassandraView().GetRenderer().AddActor2D((vtkProp)this.yactor);
            this.pipelineManager.getCassandraView().GetRenderer().AddActor2D((vtkProp)this.zactor);
            this.pipelineManager.getCassandraView().GetRenderer().AddActor((vtkProp)this.assembly);
        } else {
            this.pipelineManager.getCassandraView().GetRenderer().RemoveActor2D((vtkProp)this.xactor);
            this.pipelineManager.getCassandraView().GetRenderer().RemoveActor2D((vtkProp)this.yactor);
            this.pipelineManager.getCassandraView().GetRenderer().RemoveActor2D((vtkProp)this.zactor);
            this.pipelineManager.getCassandraView().GetRenderer().RemoveActor((vtkProp)this.assembly);
        }
    }
}

