/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.dialog;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.util.CassandraToolBox;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import vtk.vtkDataSet;
import vtk.vtkLookupTable;

public class LookUpTableControlDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private CassandraObject lookupTable;
    private PipeLineManager pipelineManager;
    private VtkObjectComboBoxModel datasetModel;
    private JList multiDatasetForRange;
    private JFormattedTextField nbColor;
    private JFormattedTextField min;
    private JFormattedTextField max;
    private JFormattedTextField minHue;
    private JFormattedTextField maxHue;
    private JRadioButton rampLinear;
    private JRadioButton rampSCurve;
    private JRadioButton rampSQRT;
    private JRadioButton scaleLinear;
    private JRadioButton scaleLog10;
    private JButton exit;
    private JButton update;

    public LookUpTableControlDialog(Frame parentFrame, PipeLineManager pipelineManager) {
        super(parentFrame, "Lookup Table Control");
        this.pipelineManager = pipelineManager;
        this.datasetModel = new VtkObjectComboBoxModel(pipelineManager.getDataSetList(), null);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel line = new JPanel(new BorderLayout());
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Dataset scalar range"));
        this.multiDatasetForRange = new JList(this.datasetModel);
        this.multiDatasetForRange.addListSelectionListener(this);
        line.add((Component)new JScrollPane(this.multiDatasetForRange), "Center");
        this.getContentPane().add(line);
        line = new JPanel(new BorderLayout());
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Range"));
        JPanel colA = new JPanel(new GridLayout(3, 0));
        JPanel colB = new JPanel(new GridLayout(3, 0));
        this.nbColor = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.nbColor.setColumns(20);
        this.min = new JFormattedTextField((Object)"0");
        this.min.setValue(new Double(0.0));
        this.max = new JFormattedTextField((Object)"0");
        this.max.setValue(new Double(1.0));
        colA.add(new JLabel("Number of color : ", 4));
        colA.add(new JLabel("Min : ", 4));
        colA.add(new JLabel("Max : ", 4));
        colB.add(this.nbColor);
        colB.add(this.min);
        colB.add(this.max);
        line.add((Component)colA, "West");
        line.add((Component)colB, "Center");
        this.getContentPane().add(line);
        line = new JPanel(new BorderLayout());
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Huge range"));
        colA = new JPanel(new GridLayout(2, 0));
        colB = new JPanel(new GridLayout(2, 0));
        this.minHue = new JFormattedTextField((Object)"0");
        this.minHue.setValue(new Double(0.0));
        this.maxHue = new JFormattedTextField((Object)"0");
        this.maxHue.setValue(new Double(0.0));
        colA.add(new JLabel("Min : ", 4));
        colA.add(new JLabel("Max : ", 4));
        colB.add(this.minHue);
        colB.add(this.maxHue);
        line.add((Component)colA, "West");
        line.add((Component)colB, "Center");
        this.getContentPane().add(line);
        line = new JPanel(new GridLayout(0, 4));
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Ramp"));
        ButtonGroup group = new ButtonGroup();
        this.rampLinear = new JRadioButton("Linear");
        this.rampSCurve = new JRadioButton("Curve");
        this.rampSQRT = new JRadioButton("Square root");
        group.add(this.rampLinear);
        group.add(this.rampSCurve);
        group.add(this.rampSQRT);
        line.add(this.rampLinear);
        line.add(this.rampSCurve);
        line.add(this.rampSQRT);
        this.getContentPane().add(line);
        line = new JPanel(new GridLayout(0, 2));
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Scale"));
        ButtonGroup groupScale = new ButtonGroup();
        this.scaleLinear = new JRadioButton("Linear");
        this.scaleLog10 = new JRadioButton("log10");
        groupScale.add(this.scaleLinear);
        groupScale.add(this.scaleLog10);
        line.add(this.scaleLinear);
        line.add(this.scaleLog10);
        this.getContentPane().add(line);
        this.update = new JButton("Update");
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LookUpTableControlDialog.this.updateLookupTable();
            }
        });
        this.exit = new JButton("Cancel");
        this.exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LookUpTableControlDialog.this.dispose();
            }
        });
        line = new JPanel();
        line.setLayout(new BoxLayout(line, 2));
        line.add(Box.createHorizontalGlue());
        line.add(this.update);
        line.add(this.exit);
        this.getContentPane().add(line);
        this.pack();
        this.setLocationRelativeTo(parentFrame);
    }

    public void setLookupTable(CassandraObject lookupTable) {
        this.lookupTable = lookupTable;
        switch (this.getVtkLookUpTable().GetRamp()) {
            case 0: {
                this.rampLinear.setSelected(true);
                break;
            }
            case 1: {
                this.rampSCurve.setSelected(true);
                break;
            }
            case 2: {
                this.rampSQRT.setSelected(true);
            }
        }
        switch (this.getVtkLookUpTable().GetScale()) {
            case 0: {
                this.scaleLinear.setSelected(true);
                break;
            }
            case 1: {
                this.scaleLog10.setSelected(true);
            }
        }
        double[] range = this.getVtkLookUpTable().GetTableRange();
        double[] hueRange = this.getVtkLookUpTable().GetHueRange();
        this.min.setValue(new Double(range[0]));
        this.max.setValue(new Double(range[1]));
        this.minHue.setValue(new Double(hueRange[0]));
        this.maxHue.setValue(new Double(hueRange[1]));
        this.nbColor.setValue(new Integer(this.getVtkLookUpTable().GetNumberOfColors()));
    }

    public void updateLookupTable() {
        if (this.rampLinear.isSelected()) {
            this.getVtkLookUpTable().SetRampToLinear();
        }
        if (this.rampSCurve.isSelected()) {
            this.getVtkLookUpTable().SetRampToSCurve();
        }
        if (this.rampSQRT.isSelected()) {
            this.getVtkLookUpTable().SetRampToSQRT();
        }
        if (this.scaleLinear.isSelected()) {
            this.getVtkLookUpTable().SetScaleToLinear();
        }
        if (this.scaleLog10.isSelected()) {
            this.getVtkLookUpTable().SetScaleToLog10();
        }
        this.getVtkLookUpTable().SetNumberOfColors(((Number)this.nbColor.getValue()).intValue());
        this.getVtkLookUpTable().SetRange(((Number)this.min.getValue()).doubleValue(), ((Number)this.max.getValue()).doubleValue());
        this.getVtkLookUpTable().SetHueRange(((Number)this.minHue.getValue()).doubleValue(), ((Number)this.maxHue.getValue()).doubleValue());
        CassandraToolBox.updateMapper(this.pipelineManager, this.getVtkLookUpTable());
        this.getVtkLookUpTable().Build();
        this.pipelineManager.notifyConnectivityChange(this.lookupTable);
        this.pipelineManager.validateViewAndGo();
    }

    public vtkLookupTable getVtkLookUpTable() {
        return (vtkLookupTable)this.lookupTable.getVtkObject();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = this.multiDatasetForRange.getSelectedValue();
        if (obj != null) {
            double[] range = ((vtkDataSet)((CassandraObject)obj).getVtkObject()).GetScalarRange();
            this.min.setValue(new Double(range[0]));
            this.max.setValue(new Double(range[1]));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        double min = 0.0;
        double max = 0.0;
        Object[] selectedObjects = this.multiDatasetForRange.getSelectedValues();
        for (int i = 0; i < selectedObjects.length; ++i) {
            double[] range = ((vtkDataSet)((CassandraObject)selectedObjects[i]).getVtkObject()).GetScalarRange();
            if (i == 0) {
                min = range[0];
                max = range[1];
            }
            if (min > range[0]) {
                min = range[0];
            }
            if (!(max < range[1])) continue;
            max = range[1];
        }
        if (min != max) {
            this.min.setValue(new Double(min));
            this.max.setValue(new Double(max));
        }
    }
}

