/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.util;

import com.artenum.cassandra.util.FileItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class BookmarkManager
extends JMenu
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTIES_PREFIX = "com.artenum.cassandra.bookmarks";
    public static final String ADD_BOOKMARK_ACTION = "add.bookmark.action";
    public static final String MANAGE_ACTION = "manage.items";
    public static final String REMOVE_BOOKMARK_ACTION = "remove.bookmark";
    public static final String CANCEL_BOOKMARK_ACTION = "cancel.bookmark.action";
    public static final String SELECTED_BOOKMARK_ACTION = "selected.bookmark.action";
    public final String LENGTH_FLAG = "length";
    private ArrayList<File> bookmark = new ArrayList();
    private boolean autoSave = true;
    private JFrame managmentFrame;
    private JList marksList;
    private FileItem selectedItem;
    private ArrayList<ActionListener> externalActionListener = new ArrayList();

    public BookmarkManager() {
        this.setText("Bookmark");
        JMenuItem bookmarkItem = new JMenuItem("Add bookmark");
        bookmarkItem.addActionListener(this);
        bookmarkItem.setActionCommand(ADD_BOOKMARK_ACTION);
        this.add(bookmarkItem);
        JMenuItem manageItem = new JMenuItem("Remove bookmark");
        manageItem.addActionListener(this);
        manageItem.setActionCommand(MANAGE_ACTION);
        this.add(manageItem);
        this.addSeparator();
    }

    @Override
    public void addActionListener(ActionListener listener) {
        super.addActionListener(listener);
        this.externalActionListener.add(listener);
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (this.getItem(i) == null) continue;
            this.getItem(i).addActionListener(listener);
        }
    }

    public void saveBookmarkListToProperties() {
        Preferences.userRoot().putInt("com.artenum.cassandra.bookmarks.length", this.bookmark.size());
        for (File file : this.bookmark) {
            Preferences.userRoot().put("com.artenum.cassandra.bookmarks." + this.bookmark.indexOf(file), file.getAbsolutePath());
        }
    }

    public void readBookmarkListFromProperties() {
        int bookMarkTmpSize = Preferences.userRoot().getInt("com.artenum.cassandra.bookmarks.length", 0);
        for (int i = 0; i < bookMarkTmpSize; ++i) {
            this.addBookmark(new File(Preferences.userRoot().get("com.artenum.cassandra.bookmarks." + i, new File(".").getAbsolutePath())));
        }
    }

    public void addBookmark(File file) {
        this.bookmark.add(file);
        this.updateView(file);
        if (this.autoSave) {
            this.saveBookmarkListToProperties();
        }
    }

    private void updateView(File file) {
        FileItem item = new FileItem();
        item.setFile(file);
        item.setText(file.getAbsolutePath());
        item.setActionCommand(SELECTED_BOOKMARK_ACTION);
        item.addActionListener(this);
        Iterator<ActionListener> iter = this.externalActionListener.iterator();
        while (iter.hasNext()) {
            item.addActionListener(iter.next());
        }
        this.add(item);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command == ADD_BOOKMARK_ACTION) {
            File selectedFile;
            JFileChooser chooser = new JFileChooser();
            if (chooser.showOpenDialog(this) == 0 && (selectedFile = chooser.getSelectedFile()) != null) {
                this.addBookmark(selectedFile);
            }
        } else if (command == MANAGE_ACTION) {
            this.manageBookMarkList();
        } else {
            this.selectedItem = (FileItem)evt.getSource();
        }
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public ArrayList<File> getBookmarkList() {
        return this.bookmark;
    }

    public void setBookmarkList(ArrayList<File> bookmark) {
        this.bookmark = bookmark;
        for (int i = 0; i < this.getItemCount(); ++i) {
            this.remove(this.getItem(0));
        }
        Iterator<File> iter = this.bookmark.iterator();
        while (iter.hasNext()) {
            this.updateView(iter.next());
        }
    }

    public void removeBookmark(File file) {
        int shift = 3;
        int index = this.bookmark.indexOf(file);
        this.bookmark.remove(file);
        this.remove(this.getItem(index + shift));
        Preferences.userRoot().remove("com.artenum.cassandra.bookmarks." + index);
        if (this.autoSave) {
            this.saveBookmarkListToProperties();
        }
    }

    private void manageBookMarkList() {
        this.managmentFrame = new JFrame();
        this.marksList = new JList<Object>(this.bookmark.toArray());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.marksList);
        JPanel mainPane = new JPanel();
        mainPane.setLayout(new BorderLayout());
        mainPane.add((Component)scrollPane, "Center");
        mainPane.setPreferredSize(new Dimension(400, 600));
        Object[] options = new Object[]{"Remove", "Cancel"};
        int answer = JOptionPane.showOptionDialog(this.managmentFrame, mainPane, "Bookmark Managment", 0, 3, null, options, options[0]);
        if (answer == 0) {
            File selectedMark = (File)this.marksList.getSelectedValue();
            this.managmentFrame.setVisible(false);
            this.removeBookmark(selectedMark);
        } else {
            this.managmentFrame.setVisible(false);
        }
    }

    public FileItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(FileItem selectedItem) {
        this.selectedItem = selectedItem;
    }
}

