/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.penelope;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.io.FileFormatException;
import com.artenum.penelope.plugin.gmsh.mesh.GMSHFilePart22;
import com.artenum.penelope.plugin.gmsh.mesh.GmshMeshBuilder10;
import com.artenum.penelope.plugin.gmsh.mesh.GmshMeshBuilder22;
import com.artenum.penelope.plugin.vtk.VtkGridBuilder;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import vtk.vtkActor;
import vtk.vtkDataSet;
import vtk.vtkDataSetMapper;
import vtk.vtkMapper;

public class LoadMsh
implements ActionListener {
    private final PipeLineManager pipelineManager;
    private final Frame owner;

    public LoadMsh(PipeLineManager pipeLineManager, PluginManager pluginManager, Frame owner) {
        this.pipelineManager = pipeLineManager;
        System.out.println("Loede pipeline manager ------> " + this.pipelineManager.toString());
        this.owner = owner;
        Logger.getLogger("Memory").setUseParentHandlers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showOpenDialog(this.owner) == 0) {
            File[] mshFiles;
            for (File mshFile : mshFiles = chooser.getSelectedFiles()) {
                if (!mshFile.isFile()) continue;
                Mesh mesh = null;
                try {
                    System.out.println("Loading " + mshFile.getAbsolutePath() + "... ");
                    int versionNumber = 1;
                    FileReader fileReader = null;
                    BufferedReader lineReader = null;
                    try {
                        String currentLine;
                        fileReader = new FileReader(mshFile.getAbsolutePath());
                        lineReader = new LineNumberReader(fileReader);
                        while ((currentLine = ((LineNumberReader)lineReader).readLine()) != null) {
                            if (GMSHFilePart22.HEADER_SECTION.getStartTag().compareToIgnoreCase(currentLine) != 0) continue;
                            System.out.println("Header found, version higher than 1");
                            versionNumber = 2;
                        }
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException loadingException) {
                        loadingException.printStackTrace();
                    }
                    finally {
                        if (fileReader != null) {
                            fileReader.close();
                        }
                        if (lineReader != null) {
                            lineReader.close();
                        }
                    }
                    try {
                        GmshMeshBuilder10 builder;
                        if (versionNumber == 1) {
                            builder = new GmshMeshBuilder10(mshFile);
                            mesh = builder.buildMeshAndIdReset();
                        } else {
                            builder = new GmshMeshBuilder22(mshFile);
                            mesh = builder.buildMeshAndIdReset();
                        }
                    }
                    catch (FileFormatException loadingException) {
                        loadingException.printStackTrace();
                        System.out.println("File format error.");
                    }
                    catch (IOException loadingException) {
                        loadingException.printStackTrace();
                    }
                    System.out.println("DONE");
                    VtkGridBuilder gridBuilder = null;
                    Object result = JOptionPane.showInputDialog(this.owner, "Choose the type of object to import:", "Gmsh importer", 3, null, new Object[]{"Node", "Edge", "Face", "Cell"}, "Edge");
                    if (result == null) {
                        result = "Edge";
                    }
                    if (result.equals("Node")) {
                        gridBuilder = new VtkGridBuilder(mesh, MeshType.VERTEX);
                    }
                    if (result.equals("Edge")) {
                        gridBuilder = new VtkGridBuilder(mesh, MeshType.EDGE);
                    }
                    if (result.equals("Face")) {
                        gridBuilder = new VtkGridBuilder(mesh, MeshType.FACE);
                    }
                    if (result.equals("Cell")) {
                        gridBuilder = new VtkGridBuilder(mesh, MeshType.POLYHEDRON);
                    }
                    this.buildDefaultPipeLine((vtkDataSet)gridBuilder.buildVtkUnstructuredGrid(), mshFile.getName());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this.owner, ex.getMessage());
                }
            }
        }
    }

    private void buildDefaultPipeLine(vtkDataSet dataset, String fileName) {
        vtkDataSetMapper mapper = new vtkDataSetMapper();
        mapper.SetInput(dataset);
        mapper.Update();
        vtkActor actor = new vtkActor();
        actor.SetMapper((vtkMapper)mapper);
        System.out.println(this.pipelineManager.getDataSetList().getElementAt(0).toString());
    }
}

