/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.vtk;

import com.artenum.penelope.field.data.DoubleDataArray;
import com.artenum.penelope.field.data.FloatDataArray;
import com.artenum.penelope.field.data.IntDataArray;
import com.artenum.penelope.field.data.TupleOfDoubleDataArray;
import com.artenum.penelope.field.data.TupleOfFloatDataArray;
import com.artenum.penelope.field.interfaces.DataArray;
import com.artenum.penelope.field.interfaces.DataField;
import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Polyhedron;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.plugin.vtk.EdgeVtkDataSetBuilder;
import com.artenum.penelope.plugin.vtk.FaceVtkDataSetBuilder;
import com.artenum.penelope.plugin.vtk.PolyhedronVtkDataSetBuilder;
import com.artenum.penelope.plugin.vtk.VertexVtkDataSetBuilder;
import com.artenum.penelope.plugin.vtk.VtkDataSetDTO;
import vtk.vtkDataArray;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkDataSetWriter;
import vtk.vtkDoubleArray;
import vtk.vtkFloatArray;
import vtk.vtkIntArray;

public class VtkToolBox {
    public static vtkDataSet buildVtkDataSet(DataField<?, ?> datafield, MeshType localisation) {
        switch (datafield.getMeshType()) {
            case VERTEX: {
                VertexVtkDataSetBuilder vertexBuilder = new VertexVtkDataSetBuilder();
                return vertexBuilder.buildVtkDataSet((DataField<?, Vertex>)datafield, localisation);
            }
            case EDGE: {
                EdgeVtkDataSetBuilder edgeBuilder = new EdgeVtkDataSetBuilder();
                return edgeBuilder.buildVtkDataSet((DataField<?, Edge>)datafield, localisation);
            }
            case FACE: {
                FaceVtkDataSetBuilder faceBuilder = new FaceVtkDataSetBuilder();
                return faceBuilder.buildVtkDataSet((DataField<?, Face>)datafield, localisation);
            }
            case POLYHEDRON: {
                PolyhedronVtkDataSetBuilder polyhedronBuilder = new PolyhedronVtkDataSetBuilder();
                return polyhedronBuilder.buildVtkDataSet((DataField<?, Polyhedron>)datafield, localisation);
            }
        }
        return null;
    }

    public static VtkDataSetDTO buildVtkDataSetDTO(DataField<?, ?> datafield, MeshType localisation) {
        VtkDataSetDTO answer;
        vtkDataSet vtkDataSet2 = null;
        switch (datafield.getMeshType()) {
            case VERTEX: {
                VertexVtkDataSetBuilder vertexBuilder = new VertexVtkDataSetBuilder();
                vtkDataSet2 = vertexBuilder.buildVtkDataSet((DataField<?, Vertex>)datafield, localisation);
                answer = new VtkDataSetDTO(vtkDataSet2, localisation, vertexBuilder.getGridBuilder().getPenelopeVertexIdToVtkNodeId(), vertexBuilder.getGridBuilder().getVtkCellIdToMeshElementPenelopeId());
                break;
            }
            case EDGE: {
                EdgeVtkDataSetBuilder edgeBuilder = new EdgeVtkDataSetBuilder();
                vtkDataSet2 = edgeBuilder.buildVtkDataSet((DataField<?, Edge>)datafield, localisation);
                answer = new VtkDataSetDTO(vtkDataSet2, localisation, edgeBuilder.getGridBuilder().getPenelopeVertexIdToVtkNodeId(), edgeBuilder.getGridBuilder().getVtkCellIdToMeshElementPenelopeId());
                break;
            }
            case FACE: {
                FaceVtkDataSetBuilder faceBuilder = new FaceVtkDataSetBuilder();
                vtkDataSet2 = faceBuilder.buildVtkDataSet((DataField<?, Face>)datafield, localisation);
                answer = new VtkDataSetDTO(vtkDataSet2, localisation, faceBuilder.getGridBuilder().getPenelopeVertexIdToVtkNodeId(), faceBuilder.getGridBuilder().getVtkCellIdToMeshElementPenelopeId());
                break;
            }
            case POLYHEDRON: {
                PolyhedronVtkDataSetBuilder polyhedronBuilder = new PolyhedronVtkDataSetBuilder();
                vtkDataSet2 = polyhedronBuilder.buildVtkDataSet((DataField<?, Polyhedron>)datafield, localisation);
                answer = new VtkDataSetDTO(vtkDataSet2, localisation, polyhedronBuilder.getGridBuilder().getPenelopeVertexIdToVtkNodeId(), polyhedronBuilder.getGridBuilder().getVtkCellIdToMeshElementPenelopeId());
                break;
            }
            default: {
                throw new IllegalArgumentException("The localisation :" + localisation + " is unknown");
            }
        }
        return answer;
    }

    public static void writeVtkDataSetToFile(vtkDataSet vtkDataSetIn, String filePath) {
        VtkToolBox.writeVtkDataSetToFile(vtkDataSetIn, filePath, true);
    }

    public static void writeVtkDataSetToFile(vtkDataSet vtkDataSetIn, String filePath, boolean binaryFlag) {
        vtkDataSetWriter writer = new vtkDataSetWriter();
        writer.SetInput((vtkDataObject)vtkDataSetIn);
        if (binaryFlag) {
            writer.SetFileTypeToBinary();
        } else {
            writer.SetFileTypeToASCII();
        }
        writer.SetFileName(filePath);
        writer.Write();
        writer.Delete();
    }

    public static vtkDataArray mapData(DataField<?, ?> datafield) {
        String dataName = datafield.getName();
        DataArray data = datafield.getDataArray();
        if (data instanceof FloatDataArray) {
            vtkFloatArray outputDataArray = new vtkFloatArray();
            outputDataArray.SetName(dataName);
            outputDataArray.SetNumberOfComponents(1);
            outputDataArray.SetNumberOfTuples(data.getNbData());
            for (int index = 0; index < data.getNbData(); ++index) {
                outputDataArray.InsertTuple1(index, (double)((Float)data.get(index)).floatValue());
            }
            return outputDataArray;
        }
        if (data instanceof DoubleDataArray) {
            vtkDoubleArray outputDataArray = new vtkDoubleArray();
            outputDataArray.SetName(dataName);
            outputDataArray.SetNumberOfComponents(1);
            outputDataArray.SetNumberOfTuples(data.getNbData());
            for (int index = 0; index < data.getNbData(); ++index) {
                outputDataArray.InsertTuple1(index, ((Double)data.get(index)).doubleValue());
            }
            return outputDataArray;
        }
        if (data instanceof IntDataArray) {
            vtkIntArray outputDataArray = new vtkIntArray();
            outputDataArray.SetName(dataName);
            outputDataArray.SetNumberOfComponents(1);
            outputDataArray.SetNumberOfTuples(data.getNbData());
            for (int index = 0; index < data.getNbData(); ++index) {
                outputDataArray.InsertTuple1(index, (double)((Integer)data.get(index)).intValue());
            }
            return outputDataArray;
        }
        if (data instanceof TupleOfFloatDataArray) {
            TupleOfFloatDataArray tmpArray = (TupleOfFloatDataArray)data;
            vtkFloatArray outputDataArray = new vtkFloatArray();
            outputDataArray.SetName(dataName);
            outputDataArray.SetNumberOfComponents(data.getDataDimension());
            outputDataArray.SetNumberOfTuples(data.getNbData());
            switch (data.getDataDimension()) {
                case 1: {
                    for (int index = 0; index < data.getNbData(); ++index) {
                        outputDataArray.InsertTuple1(index, (double)tmpArray.get(index)[0]);
                    }
                    break;
                }
                case 2: {
                    for (int index = 0; index < data.getNbData(); ++index) {
                        outputDataArray.InsertTuple2(index, (double)tmpArray.get(index)[0], (double)tmpArray.get(index)[1]);
                    }
                    break;
                }
                case 3: {
                    for (int index = 0; index < data.getNbData(); ++index) {
                        outputDataArray.InsertTuple3(index, (double)tmpArray.get(index)[0], (double)tmpArray.get(index)[1], (double)tmpArray.get(index)[2]);
                    }
                    break;
                }
                case 4: {
                    for (int index = 0; index < data.getNbData(); ++index) {
                        outputDataArray.InsertTuple4(index, (double)tmpArray.get(index)[0], (double)tmpArray.get(index)[1], (double)tmpArray.get(index)[2], (double)tmpArray.get(index)[3]);
                    }
                    break;
                }
                case 9: {
                    for (int index = 0; index < data.getNbData(); ++index) {
                        outputDataArray.InsertTuple9(index, (double)tmpArray.get(index)[0], (double)tmpArray.get(index)[1], (double)tmpArray.get(index)[2], (double)tmpArray.get(index)[3], (double)tmpArray.get(index)[4], (double)tmpArray.get(index)[5], (double)tmpArray.get(index)[6], (double)tmpArray.get(index)[7], (double)tmpArray.get(index)[8]);
                    }
                    break;
                }
                default: {
                    System.out.println("data field name " + datafield.getName());
                    throw new RuntimeException("DataSize of " + data.getDataDimension() + " is not supported by Vtk.");
                }
            }
            return outputDataArray;
        }
        if (data instanceof TupleOfDoubleDataArray) {
            TupleOfDoubleDataArray tmpArray = null;
            vtkDoubleArray outputDataArray = new vtkDoubleArray();
            outputDataArray.SetName(dataName);
            int dataDimension = data.getDataDimension();
            int nbData = data.getNbData();
            outputDataArray.SetNumberOfComponents(dataDimension);
            outputDataArray.SetNumberOfTuples(nbData);
            switch (data.getDataDimension()) {
                case 1: {
                    tmpArray = (TupleOfDoubleDataArray)data;
                    for (int index = 0; index < data.getNbData(); ++index) {
                        outputDataArray.InsertTuple1(index, tmpArray.get(index)[0]);
                    }
                    break;
                }
                case 2: {
                    tmpArray = (TupleOfDoubleDataArray)data;
                    for (int index = 0; index < data.getNbData(); ++index) {
                        outputDataArray.InsertTuple2(index, tmpArray.get(index)[0], tmpArray.get(index)[1]);
                    }
                    break;
                }
                case 3: {
                    tmpArray = (TupleOfDoubleDataArray)data;
                    for (int index = 0; index < data.getNbData(); ++index) {
                        double id1 = tmpArray.get(index)[0];
                        double id2 = tmpArray.get(index)[1];
                        double id3 = tmpArray.get(index)[2];
                        outputDataArray.InsertTuple3(index, id1, id2, id3);
                    }
                    break;
                }
                case 4: {
                    tmpArray = (TupleOfDoubleDataArray)data;
                    for (int index = 0; index < data.getNbData(); ++index) {
                        outputDataArray.InsertTuple4(index, tmpArray.get(index)[0], tmpArray.get(index)[1], tmpArray.get(index)[2], tmpArray.get(index)[3]);
                    }
                    break;
                }
                case 9: {
                    tmpArray = (TupleOfDoubleDataArray)data;
                    for (int index = 0; index < data.getNbData(); ++index) {
                        outputDataArray.InsertTuple9(index, tmpArray.get(index)[0], tmpArray.get(index)[1], tmpArray.get(index)[2], tmpArray.get(index)[3], tmpArray.get(index)[4], tmpArray.get(index)[5], tmpArray.get(index)[6], tmpArray.get(index)[7], tmpArray.get(index)[8]);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("DataSize on node of " + data.getDataDimension() + " data is not supported by Vtk.");
                }
            }
            return outputDataArray;
        }
        System.out.println("Data type not supported");
        System.out.println("Data type: " + data.getClass().toString());
        return null;
    }
}

