/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.glyph;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObjectListModel;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.glyph.GlyphPlugin;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataListener;
import vtk.vtkDataSet;

public class GlyphControlUI
extends PlugInControlUI {
    private static final long serialVersionUID = -6854692922870232665L;
    private final PipeLineManager pipeLineManager;
    private JFormattedTextField centerX;
    private final JCheckBox useNormalcheckbox;
    private final JComboBox input;
    private final JComboBox sourceCombo;
    private final JComboBox scaleModeCombo;
    private final JComboBox colorModeCombo;
    private final JFormattedTextField maskOnRatioTF;
    private final JFormattedTextField scalingFactorTF;
    private final JFormattedTextField resolutionTF;
    private final GlyphPlugin plugin;

    public GlyphControlUI(PipeLineManager pipeLineManager, final GlyphPlugin plugin, Frame owner) {
        super(owner, "Glyph configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = plugin;
        this.useNormalcheckbox = new JCheckBox("Normal oriented glyphs (instead of vector)");
        JPanel vertexControlPanel = new JPanel();
        vertexControlPanel.add(this.useNormalcheckbox);
        this.input = new JComboBox(new DataSetListModel(pipeLineManager.getDataSetList()));
        JButton exec = new JButton("Update");
        exec.setActionCommand("UPDATE");
        exec.addActionListener((ActionListener)((Object)this));
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener((ActionListener)((Object)this));
        JPanel globalConfPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.insets.set(5, 5, 0, 10);
        c.weightx = 0.1;
        c.gridx = 0;
        c.gridy = 0;
        globalConfPanel.add((Component)new JLabel("Input Dataset:"), c);
        c.gridy = 1;
        globalConfPanel.add((Component)new JLabel("Mask-on ratio:"), c);
        c.gridy = 2;
        globalConfPanel.add((Component)new JLabel("Scaling ratio:"), c);
        c.gridy = 3;
        globalConfPanel.add((Component)new JLabel("Scale mode:"), c);
        c.gridy = 4;
        globalConfPanel.add((Component)new JLabel("Color mode:"), c);
        c.gridy = 5;
        globalConfPanel.add((Component)new JLabel("Force normal:"), c);
        c.gridy = 6;
        globalConfPanel.add((Component)new JLabel("Glyph Type:"), c);
        c.gridy = 7;
        final JLabel resolutionLabel = new JLabel("Glyph resolution:");
        globalConfPanel.add((Component)resolutionLabel, c);
        c.fill = 2;
        c.anchor = 10;
        c.insets.set(5, 5, 0, 5);
        c.weightx = 0.9;
        c.gridx = 1;
        c.gridy = 0;
        globalConfPanel.add((Component)this.input, c);
        c.gridy = 1;
        this.maskOnRatioTF = new JFormattedTextField((Object)"0");
        this.maskOnRatioTF.setValue(plugin.maskOnRatio);
        this.maskOnRatioTF.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                GlyphControlUI.this.maskOnRationTFMouseWheelMoved(evt);
            }
        });
        globalConfPanel.add((Component)this.maskOnRatioTF, c);
        c.gridy = 2;
        this.scalingFactorTF = new JFormattedTextField((Object)"1.0");
        this.scalingFactorTF.setValue(plugin.scalFactor);
        this.scalingFactorTF.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                GlyphControlUI.this.scalingFactorTFMouseWheelMoved(evt);
            }
        });
        globalConfPanel.add((Component)this.scalingFactorTF, c);
        c.gridy = 3;
        this.scaleModeCombo = new JComboBox<GlyphPlugin.glyph_scale_mode>(GlyphPlugin.glyph_scale_mode.values());
        globalConfPanel.add((Component)this.scaleModeCombo, c);
        c.gridy = 4;
        this.colorModeCombo = new JComboBox<GlyphPlugin.glyph_color_mode>(GlyphPlugin.glyph_color_mode.values());
        globalConfPanel.add((Component)this.colorModeCombo, c);
        c.gridy = 5;
        globalConfPanel.add((Component)this.useNormalcheckbox, c);
        c.gridy = 6;
        this.sourceCombo = new JComboBox<GlyphPlugin.glyph_source>(GlyphPlugin.glyph_source.values());
        globalConfPanel.add((Component)this.sourceCombo, c);
        this.sourceCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlyphControlUI.this.resolutionTF.setVisible(((GlyphPlugin.glyph_source)((Object)GlyphControlUI.this.sourceCombo.getSelectedItem())).hasResolution());
                int resolt = ((GlyphPlugin.glyph_source)((Object)GlyphControlUI.this.sourceCombo.getSelectedItem())).getBaseResolution();
                GlyphControlUI.this.resolutionTF.setText(Integer.toString(resolt));
                plugin.resolution = resolt;
                resolutionLabel.setVisible(((GlyphPlugin.glyph_source)((Object)GlyphControlUI.this.sourceCombo.getSelectedItem())).hasResolution());
                GlyphControlUI.this.pack();
                Dimension size = GlyphControlUI.this.getSize();
                size.setSize(size.getWidth() + 100.0, size.getHeight());
                GlyphControlUI.this.setSize(size);
            }
        });
        c.gridy = 7;
        this.resolutionTF = new JFormattedTextField((Object)Integer.toString(plugin.resolution));
        this.resolutionTF.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                GlyphControlUI.this.resolutionTFMouseWheelMoved(evt);
            }
        });
        globalConfPanel.add((Component)this.resolutionTF, c);
        JPanel cmdLine = new JPanel();
        cmdLine.setLayout(new BoxLayout(cmdLine, 2));
        cmdLine.add(Box.createHorizontalGlue());
        cmdLine.add(exec);
        cmdLine.add(cancel);
        this.getContentPane().add("Center", globalConfPanel);
        this.getContentPane().add("South", cmdLine);
        this.pack();
        Dimension size = this.getSize();
        size.setSize(size.getWidth() + 100.0, size.getHeight());
        this.setSize(size);
        this.setLocationRelativeTo(null);
    }

    private void maskOnRationTFMouseWheelMoved(MouseWheelEvent evt) {
        int tmpLevel = ((Number)this.maskOnRatioTF.getValue()).intValue() - evt.getWheelRotation();
        if (tmpLevel < 1) {
            tmpLevel = 1;
        }
        this.maskOnRatioTF.setValue(tmpLevel);
        this.plugin.maskOnRatio = ((Number)this.maskOnRatioTF.getValue()).intValue();
    }

    private void scalingFactorTFMouseWheelMoved(MouseWheelEvent evt) {
        double tmpScaling = ((Number)this.scalingFactorTF.getValue()).doubleValue() - (double)evt.getWheelRotation() * 0.1;
        if (tmpScaling < 0.0) {
            tmpScaling = 0.0;
        }
        this.scalingFactorTF.setValue(tmpScaling);
        this.plugin.scalFactor = ((Number)this.scalingFactorTF.getValue()).doubleValue();
    }

    private void resolutionTFMouseWheelMoved(MouseWheelEvent evt) {
        int tmpScaling = (int)Double.parseDouble(this.resolutionTF.getText()) - evt.getWheelRotation();
        if (tmpScaling < 0) {
            tmpScaling = 0;
        }
        this.resolutionTF.setText(String.valueOf(tmpScaling));
        this.plugin.resolution = tmpScaling;
    }

    public void setSelectedInput(CassandraObject selectedInput) {
        if (selectedInput != null) {
            this.input.getModel().setSelectedItem(selectedInput);
        } else {
            System.out.println("Selection is null");
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("UPDATE")) {
            if (this.input.getSelectedItem() == null) {
                return;
            }
            this.plugin.maskOnRatio = ((Number)this.maskOnRatioTF.getValue()).intValue();
            this.plugin.scalFactor = ((Number)this.scalingFactorTF.getValue()).doubleValue();
            this.plugin.resolution = (int)Double.parseDouble(this.resolutionTF.getText());
            this.plugin.updateGlyph((vtkDataSet)((CassandraObject)this.input.getSelectedItem()).getVtkObject(), (GlyphPlugin.glyph_source)((Object)this.sourceCombo.getSelectedItem()), (GlyphPlugin.glyph_scale_mode)((Object)this.scaleModeCombo.getSelectedItem()), (GlyphPlugin.glyph_color_mode)((Object)this.colorModeCombo.getSelectedItem()), this.useNormalcheckbox.isSelected());
            this.pipeLineManager.validateViewAndGo();
        }
        if (command.equals("CANCEL")) {
            this.dispose();
        }
    }

    public void stateChanged(ChangeEvent e) {
    }

    public void itemStateChanged(ItemEvent arg0) {
    }

    class DataSetListModel
    implements ComboBoxModel {
        private final VtkObjectListModel datasetModel;
        private Object selectedItem;

        public DataSetListModel(VtkObjectListModel datasetModel) {
            this.datasetModel = datasetModel;
        }

        @Override
        public Object getElementAt(int index) {
            return this.datasetModel.getElementAt(index);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public int getSize() {
            return this.datasetModel.getSize();
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectedItem = anItem;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.datasetModel.addListDataListener(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.datasetModel.removeListDataListener(l);
        }
    }
}

