/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.cutter;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.plugin.CassandraPlugInProperty;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.cutter.CutterControlUI;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkAbstractTransform;
import vtk.vtkActor;
import vtk.vtkBoxWidget;
import vtk.vtkCone;
import vtk.vtkCutter;
import vtk.vtkCylinder;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkImplicitFunction;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkPlane;
import vtk.vtkPolyDataMapper;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;
import vtk.vtkSphere;
import vtk.vtkTransform;

public class CutterPlugin
implements CassandraPlugin,
RemoveListener {
    private String name = "Generic Cutter";
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private int nbUpdate = 0;
    private CutterControlUI controlUI;
    private vtkPlane plane;
    private vtkBoxWidget box;
    private vtkCylinder cylinder;
    private vtkCone cone;
    private vtkSphere sphere;
    private vtkTransform cylinderTransform;
    private vtkDataSet lastDataSet;
    private vtkLookupTable lookupTable;
    private vtkScalarBarActor scalarBar;
    private vtkCutter cutter;
    private vtkPolyDataMapper cutMapper;
    private vtkActor cutActor;
    private Filter filterImpl;
    private CassandraObject actor;
    private CassandraObject mapper;
    private CassandraObject dataset;
    private CassandraObject filter;

    public CutterPlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this.pipelineManager = pipelineManager;
        this.pluginManager = pluginManager;
        this.filterImpl = new FilterImpl();
        this.filterImpl.addRemoveListener((RemoveListener)this);
        this.controlUI = new CutterControlUI(pipelineManager, this, owner);
        this.contextualMenu = new JPopupMenu("Generic Cutter");
        JMenuItem showControl = new JMenuItem("Show control");
        showControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CutterPlugin.this.controlUI.setVisible(true);
            }
        });
        this.contextualMenu.add(showControl);
        this.contextualMenu.addSeparator();
        JMenuItem remove = new JMenuItem("Remove");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CutterPlugin.this.remove();
            }
        });
        this.contextualMenu.add(remove);
        this.plane = new vtkPlane();
        this.plane.SetOrigin(0.0, 0.0, 0.0);
        this.plane.SetNormal(0.0, 0.0, 1.0);
        this.cone = new vtkCone();
        this.cone.SetAngle(15.0);
        this.box = new vtkBoxWidget();
        this.sphere = new vtkSphere();
        this.sphere.SetCenter(0.0, 0.0, 0.0);
        this.sphere.SetRadius(10.0);
        this.cylinder = new vtkCylinder();
        this.cylinder.SetCenter(0.0, 0.0, 0.0);
        this.cylinder.SetRadius(10.0);
        this.cylinderTransform = new vtkTransform();
        this.cylinder.SetTransform((vtkAbstractTransform)this.cylinderTransform);
        this.cutter = new vtkCutter();
        this.cutter.SetCutFunction((vtkImplicitFunction)this.plane);
        this.cutMapper = new vtkPolyDataMapper();
        this.cutMapper.SetInput(this.cutter.GetOutput());
        this.cutActor = new vtkActor();
        this.cutActor.SetMapper((vtkMapper)this.cutMapper);
        try {
            this.lookupTable = new vtkLookupTable();
            this.lookupTable.SetHueRange(0.66667, 0.0);
            this.lookupTable.Build();
            this.cutMapper.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        }
        catch (Exception e1) {
            // empty catch block
        }
        vtkScalarBarActor scalBar = null;
        try {
            scalBar = new vtkScalarBarActor();
            scalBar.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        }
        catch (Exception e1) {
            // empty catch block
        }
        try {
            this.actor = pipelineManager.addActor((Object)this.cutActor, "Cutter");
        }
        catch (Exception e1) {
            // empty catch block
        }
        try {
            this.mapper = pipelineManager.addMapper((Object)this.cutMapper, "Cutter");
        }
        catch (Exception e1) {
            // empty catch block
        }
        try {
            this.dataset = pipelineManager.addDataSet((Object)this.cutter.GetOutput(), "Cutter");
        }
        catch (Exception e1) {
            // empty catch block
        }
        try {
            this.filter = pipelineManager.addFilter(this.filterImpl, "Cutter");
        }
        catch (Exception e1) {
            // empty catch block
        }
        try {
            pipelineManager.addLookupTable(this.lookupTable, "Cutter");
        }
        catch (Exception e1) {
            // empty catch block
        }
        try {
            if (scalBar != null) {
                pipelineManager.setActorVisible(pipelineManager.addScalarBar(scalBar, "Cutter"), true);
            }
        }
        catch (Exception e1) {
            // empty catch block
        }
        this.filter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
        this.actor.setValide(false);
    }

    public void updateCuttingPlane(double cx, double cy, double cz, double nx, double ny, double nz, vtkDataSet vtkDataSet2) {
        if (vtkDataSet2 == null) {
            return;
        }
        this.actor.setValide(true);
        this.plane.SetOrigin(cx, cy, cz);
        this.plane.SetNormal(nx, ny, nz);
        this.cutter.SetCutFunction((vtkImplicitFunction)this.plane);
        this.cutter.SetInput((vtkDataObject)vtkDataSet2);
        if ((this.lastDataSet == null || !this.lastDataSet.equals(vtkDataSet2)) && this.cutMapper.GetLookupTable().equals(this.lookupTable)) {
            this.cutMapper.SetScalarRange(vtkDataSet2.GetScalarRange());
            this.lookupTable.SetTableRange(vtkDataSet2.GetScalarRange());
            this.lastDataSet = vtkDataSet2;
        }
        if (this.nbUpdate++ == 0 && this.pipelineManager.getActorList().getData().contains(this.actor)) {
            this.pipelineManager.setActorVisible(this.actor, true);
        }
        this.filterImpl.getInputDataSet().clear();
        this.filterImpl.getInputDataSet().add(vtkDataSet2);
        this.filterImpl.getOutputDataSet().clear();
        this.filterImpl.getOutputDataSet().add(this.cutter.GetOutput());
        this.pipelineManager.notifyConnectivityChange(this.filter);
    }

    public void updateCuttingSphere(double cx, double cy, double cz, double radius, vtkDataSet vtkDataSet2) {
        if (vtkDataSet2 == null) {
            return;
        }
        this.actor.setValide(true);
        this.sphere.SetCenter(cx, cy, cz);
        this.sphere.SetRadius(radius);
        this.cutter.SetCutFunction((vtkImplicitFunction)this.sphere);
        this.cutter.SetInput((vtkDataObject)vtkDataSet2);
        if ((this.lastDataSet == null || !this.lastDataSet.equals(vtkDataSet2)) && this.cutMapper.GetLookupTable().equals(this.lookupTable)) {
            this.cutMapper.SetScalarRange(vtkDataSet2.GetScalarRange());
            this.lookupTable.SetTableRange(vtkDataSet2.GetScalarRange());
            this.lastDataSet = vtkDataSet2;
        }
        if (this.nbUpdate++ == 0 && this.pipelineManager.getActorList().getData().contains(this.actor)) {
            this.pipelineManager.setActorVisible(this.actor, true);
        }
        this.filterImpl.getInputDataSet().clear();
        this.filterImpl.getInputDataSet().add(vtkDataSet2);
        this.filterImpl.getOutputDataSet().clear();
        this.filterImpl.getOutputDataSet().add(this.cutter.GetOutput());
        this.pipelineManager.notifyConnectivityChange(this.filter);
    }

    public void updateCuttingCylinder(double cx, double cy, double cz, double rx, double ry, double rz, double radius, vtkDataSet vtkDataSet2) {
        if (vtkDataSet2 == null) {
            return;
        }
        this.actor.setValide(true);
        this.cylinder.SetCenter(cx, cy, cz);
        this.cylinder.SetRadius(radius);
        this.cylinderTransform.RotateX(rx);
        this.cylinderTransform.RotateY(ry);
        this.cylinderTransform.RotateY(rz);
        this.cutter.SetCutFunction((vtkImplicitFunction)this.cylinder);
        this.cutter.SetInput((vtkDataObject)vtkDataSet2);
        if ((this.lastDataSet == null || !this.lastDataSet.equals(vtkDataSet2)) && this.cutMapper.GetLookupTable().equals(this.lookupTable)) {
            this.cutMapper.SetScalarRange(vtkDataSet2.GetScalarRange());
            this.lookupTable.SetTableRange(vtkDataSet2.GetScalarRange());
            this.lastDataSet = vtkDataSet2;
        }
        if (this.nbUpdate++ == 0 && this.pipelineManager.getActorList().getData().contains(this.actor)) {
            this.pipelineManager.setActorVisible(this.actor, true);
        }
        this.filterImpl.getInputDataSet().clear();
        this.filterImpl.getInputDataSet().add(vtkDataSet2);
        this.filterImpl.getOutputDataSet().clear();
        this.filterImpl.getOutputDataSet().add(this.cutter.GetOutput());
        this.pipelineManager.notifyConnectivityChange(this.filter);
    }

    public String getName() {
        return this.name;
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.actor);
        this.pipelineManager.removeVtkObject(this.mapper);
        this.pipelineManager.removeVtkObject(this.dataset);
        this.pipelineManager.removeVtkObject(this.filter);
    }

    public String toString() {
        return this.getName();
    }

    public Filter getInternalFilter() {
        return this.filterImpl;
    }

    public CassandraPlugInProperty getPlugInProperty() {
        return null;
    }

    public PlugInControlUI getControlUI() {
        return this.controlUI;
    }

    public void initAndUpdate(CassandraPlugInProperty prop) {
    }
}

