/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.nisaba.util;

public class VectorUtilDouble {
    public static final double[] X_AXIS = new double[]{1.0, 0.0, 0.0};
    public static final double[] Y_AXIS = new double[]{0.0, 1.0, 0.0};
    public static final double[] Z_AXIS = new double[]{0.0, 0.0, 1.0};
    public static final double[] vNull3 = new double[]{0.0, 0.0, 0.0};

    private VectorUtilDouble() {
    }

    public static double distanceLinf(double[] a, double[] b) {
        if (a == null || b == null || a.length != b.length) {
            throw new IllegalArgumentException("arrays must have the same length when computing L inf distance");
        }
        double maxLength = 0.0;
        double length = 0.0;
        for (int i = 0; i < a.length; ++i) {
            if (!((length += Math.abs(a[i] - b[i])) > maxLength)) continue;
            maxLength = length;
        }
        return maxLength;
    }

    public static double distanceL2(double[] a, double[] b) {
        if (a == null || b == null || a.length != b.length) {
            throw new IllegalArgumentException("arrays must have the same length when computing L\u00d4\u00f8\u03a9 distance");
        }
        double sqrSum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sqrSum += (a[i] - b[i]) * (a[i] - b[i]);
        }
        return Math.sqrt(sqrSum);
    }

    public static double distanceL1(double[] a, double[] b) {
        if (a == null || b == null || a.length != b.length) {
            throw new IllegalArgumentException("arrays must have the same length when computing L1 distance");
        }
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += Math.abs(a[i] - b[i]);
        }
        return sum;
    }

    public static boolean compare(double[] a, double[] b, double tolerance) {
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (!(Math.abs(a[i] - b[i]) > tolerance)) continue;
            return false;
        }
        return true;
    }

    public static final void normalize3(double[] vector) {
        double norm = VectorUtilDouble.norm3(vector);
        if (norm == 1.0) {
            return;
        }
        if (norm == 0.0) {
            return;
        }
        VectorUtilDouble.div3(vector, norm);
    }

    public static final void normalize(double[] vector) {
        double norm = VectorUtilDouble.norm(vector);
        if (norm == 1.0) {
            return;
        }
        if (norm == 0.0) {
            return;
        }
        VectorUtilDouble.div(vector, norm);
    }

    public static final double normSqr(double[] vector) {
        double norm = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            norm += vector[i] * vector[i];
        }
        return norm;
    }

    public static final double norm(double[] vector) {
        return Math.sqrt(VectorUtilDouble.normSqr(vector));
    }

    public static final double normSqr3(double[] vector) {
        double norm = 0.0;
        for (int i = 0; i < 3; ++i) {
            norm += vector[i] * vector[i];
        }
        return norm;
    }

    public static final double norm3(double[] vector) {
        return Math.sqrt(VectorUtilDouble.normSqr3(vector));
    }

    public static final double[] dotProduct(double[] vectA, double[] vectB) {
        double[] result = new double[]{vectA[1] * vectB[2] - vectA[2] * vectB[1], vectA[2] * vectB[0] - vectA[0] * vectB[2], vectA[0] * vectB[1] - vectA[1] * vectB[0]};
        return result;
    }

    public static void dotProduct3(double[] a, double[] b, double[] result) {
        if (result == a || result == b) {
            throw new IllegalArgumentException("result cannot be one of the input vector");
        }
        result[0] = a[1] * b[2] - b[1] * a[2];
        result[1] = a[2] * b[0] - b[2] * a[0];
        result[2] = a[0] * b[1] - b[0] * a[1];
    }

    public static double[] dotProduct3(double[] a, double[] b) {
        return new double[]{a[1] * b[2] - b[1] * a[2], a[2] * b[0] - b[2] * a[0], a[0] * b[1] - b[0] * a[1]};
    }

    public static boolean isNull(double[] a, double tolerance) {
        return VectorUtilDouble.norm(a) < tolerance;
    }

    public static final double scalarProduct(double[] vectA, double[] vectB) {
        if (vectA.length != vectB.length) {
            throw new IllegalArgumentException("vectors must have the same size when computing the scalar product");
        }
        double scalarProduct = 0.0;
        for (int i = 0; i < vectA.length; ++i) {
            scalarProduct += vectA[i] * vectB[i];
        }
        return scalarProduct;
    }

    public static final double[] add(double[] vectorResult, double[] vectorToAdd) {
        int nb = vectorResult.length;
        for (int i = 0; i < nb; ++i) {
            int n = i;
            vectorResult[n] = vectorResult[n] + vectorToAdd[i];
        }
        return vectorResult;
    }

    public static final double[] minus(double[] vectorResult, double[] vector) {
        int nb = vectorResult.length;
        for (int i = 0; i < nb; ++i) {
            int n = i;
            vectorResult[n] = vectorResult[n] - vector[i];
        }
        return vectorResult;
    }

    public static final double[] minusWithNew(double[] a, double[] b) {
        double[] vectorResult = new double[]{a[0], a[1], a[2]};
        int nb = vectorResult.length;
        for (int i = 0; i < nb; ++i) {
            int n = i;
            vectorResult[n] = vectorResult[n] - b[i];
        }
        return vectorResult;
    }

    public static final double[] mult(double[] vectorResult, double[] vector) {
        int nb = vectorResult.length;
        for (int i = 0; i < nb; ++i) {
            int n = i;
            vectorResult[n] = vectorResult[n] * vector[i];
        }
        return vectorResult;
    }

    public static final double[] div(double[] vectorResult, double[] vector) {
        int nb = vectorResult.length;
        for (int i = 0; i < nb; ++i) {
            int n = i;
            vectorResult[n] = vectorResult[n] / vector[i];
        }
        return vectorResult;
    }

    public static final double[] add(double[] vectorResult, double valueToAdd) {
        int i = 0;
        int nb = vectorResult.length;
        while (i < nb) {
            int n = i++;
            vectorResult[n] = vectorResult[n] + valueToAdd;
        }
        return vectorResult;
    }

    public static final double[] minus(double[] vectorResult, double value) {
        int i = 0;
        int nb = vectorResult.length;
        while (i < nb) {
            int n = i++;
            vectorResult[n] = vectorResult[n] - value;
        }
        return vectorResult;
    }

    public static final double[] mult(double[] vectorResult, double value) {
        int i = 0;
        int nb = vectorResult.length;
        while (i < nb) {
            int n = i++;
            vectorResult[n] = vectorResult[n] * value;
        }
        return vectorResult;
    }

    public static final double[] div(double[] vectorResult, double value) {
        int i = 0;
        int nb = vectorResult.length;
        while (i < nb) {
            int n = i++;
            vectorResult[n] = vectorResult[n] / value;
        }
        return vectorResult;
    }

    public static final double[] div3(double[] vectorResult, double value) {
        int i = 0;
        while (i < 3) {
            int n = i++;
            vectorResult[n] = vectorResult[n] / value;
        }
        return vectorResult;
    }

    public static final double sum(double[] vector) {
        double value = 0.0;
        int nb = vector.length;
        for (int i = 0; i < nb; ++i) {
            value += vector[i];
        }
        return value;
    }

    public static final double sum3(double[] vector) {
        double value = 0.0;
        int nb = vector.length;
        for (int i = 0; i < nb; ++i) {
            value += vector[i];
        }
        return value;
    }

    public static final void sphericalToRectangularCoordinates(double[] vector) {
        if (vector == null) {
            throw new IllegalArgumentException("spherical coordinates cannot be null");
        }
        if (vector.length != 3) {
            throw new IllegalArgumentException("spherical coordinates must be 3D (not " + vector.length + "D)");
        }
        double rho = vector[0];
        double theta = vector[1];
        double phi = vector[2];
        double sinTheta = Math.sin(theta);
        vector[0] = rho * sinTheta * Math.cos(phi);
        vector[1] = rho * sinTheta * Math.sin(phi);
        vector[2] = rho * Math.cos(theta);
    }

    public static final void rectangularToSphericalCoordinates(double[] vector) {
        if (vector == null) {
            throw new IllegalArgumentException("rectangular coordinates cannot be null");
        }
        if (vector.length != 3) {
            throw new IllegalArgumentException("rectangular coordinates must be 3D (not " + vector.length + "D)");
        }
        double EPSILON = 1.0E-7;
        double x = vector[0];
        double y = vector[1];
        double z = vector[2];
        double rho = Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2]);
        if (rho < 1.0E-7) {
            vector[2] = 0.0;
            vector[1] = 0.0;
            vector[0] = 0.0;
            return;
        }
        vector[0] = rho;
        if (Math.abs(z / rho) > 0.9999999) {
            vector[1] = z < 0.0 ? Math.PI : 0.0;
            vector[2] = 0.0;
        } else {
            vector[1] = Math.acos(z / rho);
            vector[2] = Math.atan2(y, x);
        }
    }

    public static final void copy(double[] src, double[] dest) {
        int nb = Math.min(src.length, dest.length);
        for (int i = 0; i < nb; ++i) {
            dest[i] = src[i];
        }
    }

    public static final void copy3(double[] src, double[] dest) {
        for (int i = 0; i < 3; ++i) {
            dest[i] = src[i];
        }
    }

    public static final double[] copy(double[] src) {
        if (src == null) {
            return null;
        }
        double[] dst = new double[src.length];
        VectorUtilDouble.copy(src, dst);
        return dst;
    }

    public static final double[] copy3(double[] src) {
        double[] dst = new double[3];
        VectorUtilDouble.copy3(src, dst);
        return dst;
    }

    public static double getAbsoluteMax(double[] array) {
        double max = 0.0;
        for (int i = 0; i < array.length; ++i) {
            max = Math.max(max, Math.abs(array[i]));
        }
        return max;
    }

    public static double getAbsoluteMin(double[] array) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < array.length; ++i) {
            min = Math.min(min, Math.abs(array[i]));
        }
        return min;
    }

    public static boolean isInvalide(double[] array) {
        for (double value : array) {
            if (value != Double.NEGATIVE_INFINITY && value != Double.POSITIVE_INFINITY && !Double.isNaN(value)) continue;
            return true;
        }
        return false;
    }
}

