/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.field.data;

import com.artenum.penelope.field.data.AbstractDataArray;
import com.artenum.penelope.field.data.DataType;
import java.util.Arrays;
import java.util.List;

public class DoubleDataArray
extends AbstractDataArray<Double> {
    private double[] data;

    public DoubleDataArray() {
        this.data = new double[40960];
    }

    public DoubleDataArray(int size) {
        this.nbData = 0;
        this.data = new double[size];
    }

    public DoubleDataArray(double[] data) {
        this.nbData = data.length;
        this.data = data;
    }

    public DoubleDataArray(List<Double> data) {
        this.nbData = data.size();
        this.data = new double[data.size()];
        for (int index = 0; index < data.size(); ++index) {
            this.data[index] = data.get(index);
        }
    }

    @Override
    public void set(int index, Double value) throws IndexOutOfBoundsException {
        this.data[index] = value;
        if (index > this.currentLastIndex) {
            this.currentLastIndex = index;
        }
    }

    @Override
    public Double get(int index) throws IndexOutOfBoundsException {
        return this.data[index];
    }

    public double getAsSimpleDouble(int index) throws IndexOutOfBoundsException {
        return this.data[index];
    }

    @Override
    public void add(Double value) {
        if (this.currentLastIndex > this.data.length - 1) {
            this.extendArraySize(this.data.length + 40960);
        }
        this.data[this.currentLastIndex] = value;
        ++this.currentLastIndex;
        ++this.nbData;
    }

    @Override
    public void extendArraySize(int newSize) {
        double[] newArray = new double[newSize];
        System.arraycopy(this.data, 0, newArray, 0, this.data.length);
        this.data = newArray;
    }

    @Override
    public void packArray() {
        double[] newArray = new double[this.nbData];
        System.arraycopy(this.data, 0, newArray, 0, this.nbData);
        this.data = newArray;
    }

    @Override
    public int getNbData() {
        return this.nbData;
    }

    @Override
    public int getArraySize() {
        return this.data.length;
    }

    @Override
    public int getDataDimension() {
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleDataArray other = (DoubleDataArray)obj;
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public DataType getDataType() {
        return DataType.DOUBLE;
    }
}

