/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.iterator;

import com.artenum.penelope.mesh.interfaces.Face;
import java.util.Iterator;
import java.util.List;

public class BasicEdgeIdsIterator
implements Iterator<Integer> {
    private final List<? extends Face> meshElementList;
    private int meshElementIndex;
    private int edgeIndex;
    private int nbEdgesInCurrentMeshElement;

    public BasicEdgeIdsIterator(List<? extends Face> aMeshElementList) {
        this.meshElementList = aMeshElementList;
        if (!this.meshElementList.isEmpty()) {
            this.nbEdgesInCurrentMeshElement = this.meshElementList.get(0).getNbEdges();
        }
        this.meshElementIndex = 0;
        this.edgeIndex = 0;
    }

    @Override
    public boolean hasNext() {
        boolean answer = false;
        if (this.meshElementIndex != this.meshElementList.size()) {
            answer = true;
        }
        return answer;
    }

    @Override
    public Integer next() {
        Face meshElement = this.meshElementList.get(this.meshElementIndex);
        int[] edgeIds = meshElement.getEdgeIds();
        int answer = edgeIds[this.edgeIndex];
        if (this.edgeIndex != this.nbEdgesInCurrentMeshElement - 1) {
            ++this.edgeIndex;
        } else {
            ++this.meshElementIndex;
            this.edgeIndex = 0;
        }
        return answer;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }
}

