/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.splitting;

import com.artenum.penelope.field.DataFieldManager;
import com.artenum.penelope.field.EdgeDataField;
import com.artenum.penelope.field.FaceDataField;
import com.artenum.penelope.field.VertexDataField;
import com.artenum.penelope.field.data.IntDataArray;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.MeshMask;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.mesh.mask.EdgeMeshMask;
import com.artenum.penelope.mesh.mask.FaceMeshMask;
import com.artenum.penelope.mesh.mask.VertexMeshMask;
import java.util.Map;
import java.util.Set;

public class OutputMeshSplitting {
    private final Map<Integer, Face> originalFaceIdToDuplicatedFace;
    private final Map<Integer, Edge> originalEdgeIdToDuplicatedEdge;
    private final Mesh mesh;
    private final Map<Integer, Edge> originalEdgeIdToClone;
    private final Map<Integer, Vertex> originalVertexIdToClone;
    private final Map<Integer, Face> originalFaceIdToClone;
    public static final String nameOfOriginalThinPlateToDuplicatedIdFace = "originalThinPlateToDuplicatedIdFace";
    public static final String nameOfDuplicatedThinSurfaceOnFace = "duplicatedThinSurfaceOnFace";
    public static final String nameOfDuplicatedThinPlateToOriginalIdFace = "duplicatedThinPlateToOriginalIdFace";
    public static final String nameOfDuplicatedThinPlateToOriginalIdEdge = "duplicatedThinPlateToOriginalIdEdge";
    public static final String nameOfDuplicatedThinSurfaceOnEdge = "duplicatedThinPlateToOriginalIdEdge";
    public static final String nameOfDuplicatedThinPlateToOriginalIdVertex = "duplicatedThinPlateToOriginalIdVertex";
    public static final String nameOfDuplicatedThinSurfaceOnVertex = "duplicatedThinPlateToOriginalIdVertex";
    public static final String nameOfOriginalThinPlateToDuplicatedIdEdge = "originalThinPlateToDuplicatedIdEdge";
    public static final String nameOfOriginalThinSurfaceOnEdge = "originalThinPlateToDuplicatedIdEdge";
    public static final String nameOfOriginalThinPlateToDuplicatedIdVertex = "originalThinPlateToDuplicatedIdVertex";
    public static final String nameOfOriginalThinSurfaceOnVertex = "originalThinPlateToDuplicatedIdVertex";
    public static final String nameOfNoPhysicalDuplicatedThinSurfaceToOriginalIdEdge = "noPhysicalDuplicatedThinSurfaceToOriginalIdEdge";
    public static final String nameOfNoPhysicalDuplicatedThinSurfaceOnEdge = "noPhysicalDuplicatedThinSurfaceOnEdge";
    public static final String nameOfNoPhysicalOriginalThinPlateToDuplicatedIdEdge = "noPhysicalOriginalThinPlateToDuplicatedIdEdge";
    public static final String nameOfNoPhysicalOriginalThinSurfaceOnEdge = "noPhysicalOriginalThinPlateToDuplicatedIdEdge";
    public static final String nameOfNoPhysicalDuplicatedThinPlateToOriginalIdFace = "noPhysicalDuplicatedThinPlateToOriginalIdFace";
    public static final String nameOfNoPhysicalDuplicatedThinSurfaceOnFace = "noPhysicalDuplicatedThinPlateToOriginalIdFace";
    public static final String nameOfNoPhysicalOriginalThinPlateToDuplicatedIdFace = "noPhysicalOriginalThinPlateToDuplicatedIdFace";
    public static final String nameOfNoPhysicalOriginalThinSurfaceOnFace = "noPhysicalOoriginalThinPlateToDuplicatedIdFace";
    private int duplicatedBorderMeshMaskId = -1;
    private int originalBorderMeshMaskId = -1;
    private int noPhysicalDuplicatedThinPlateId = -1;
    private int noPhysicalOriginalThinPlateId = -1;
    private int idOfDuplicatedThinSurfaceOnFace = -1;
    private int idOfDuplicatedThinSurfaceOnEdge = -1;
    private int idOfOriginalThinSurfaceOnEdge = -1;
    private int idOfDuplicatedThinSurfaceOnVertex = -1;
    private int idOfOriginalThinSurfaceOnVertex = -1;
    private int idOfNoPhysicalDuplicatedThinSurfaceOnEdge = -1;
    private int idOfNoPhysicalOriginalThinSurfaceOnEdge = -1;

    public OutputMeshSplitting(Map<Integer, Face> originalFaceIdToDuplicatedFace, Map<Integer, Edge> originalEdgeIdToDuplicatedEdge, Mesh mesh, Map<Integer, Edge> originalEdgeIdToClone, Map<Integer, Vertex> originalVertexIdToClone, Map<Integer, Face> originalFaceIdToClone, MeshMask<Face> meshMask) {
        this.originalFaceIdToDuplicatedFace = originalFaceIdToDuplicatedFace;
        this.originalEdgeIdToDuplicatedEdge = originalEdgeIdToDuplicatedEdge;
        this.mesh = mesh;
        this.originalEdgeIdToClone = originalEdgeIdToClone;
        this.originalVertexIdToClone = originalVertexIdToClone;
        this.originalFaceIdToClone = originalFaceIdToClone;
        this.createDataFields(meshMask);
    }

    private void createDataFields(MeshMask<Face> meshMask) {
        int[] noPhysicalDuplicatedThinPlateFaceMeshElementIds;
        int[] noPhysicalOriginalThinPlateFaceMeshElementIds;
        DataFieldManager localDataFieldManager = this.mesh.getDataFieldManager();
        this.idOfDuplicatedThinSurfaceOnFace = this.computeMaxMeshMaskId() + 1;
        String descriptionOfDuplicatedThinSurfaceOnFace = "face mesh mask which stores face id of the duplicated thin surface";
        FaceMeshMask duplicatedThinSurfaceOnFace = new FaceMeshMask(this.idOfDuplicatedThinSurfaceOnFace, nameOfDuplicatedThinSurfaceOnFace, "face mesh mask which stores face id of the duplicated thin surface", this.mesh);
        int[] originalThinSurfaceFaceIds = meshMask.getMeshElementIds();
        int[] dataOfDuplicatedThinSurfaceFaceId = new int[originalThinSurfaceFaceIds.length];
        int[] dataOfOriginalThinSurfaceFaceId = new int[originalThinSurfaceFaceIds.length];
        for (int index = 0; index < originalThinSurfaceFaceIds.length; ++index) {
            int duplicatedThinSurfaceFaceId;
            int originalThinSurfaceFaceId = originalThinSurfaceFaceIds[index];
            Face duplicatedFace = this.originalFaceIdToClone.get(originalThinSurfaceFaceId);
            dataOfDuplicatedThinSurfaceFaceId[index] = duplicatedThinSurfaceFaceId = duplicatedFace.getId();
            dataOfOriginalThinSurfaceFaceId[index] = originalThinSurfaceFaceId;
            duplicatedThinSurfaceOnFace.addMeshElementId(duplicatedThinSurfaceFaceId);
            localDataFieldManager.addMeshMaskToFaceId(duplicatedThinSurfaceOnFace, duplicatedThinSurfaceFaceId);
        }
        localDataFieldManager.addFaceMeshMask(duplicatedThinSurfaceOnFace);
        IntDataArray dataArrayOfDuplicatedThinSurfaceFaceId = new IntDataArray(dataOfDuplicatedThinSurfaceFaceId);
        FaceDataField<Integer> originalThinPlateToDuplicatedIdFace = new FaceDataField<Integer>(meshMask.getId(), nameOfOriginalThinPlateToDuplicatedIdFace, "this data field associates id of the original thin surface and id of the duplicated thin surface on face", meshMask, dataArrayOfDuplicatedThinSurfaceFaceId);
        localDataFieldManager.addDataField(originalThinPlateToDuplicatedIdFace);
        IntDataArray dataArrayOfOriginalThinSurfaceFaceId = new IntDataArray(dataOfOriginalThinSurfaceFaceId);
        int idOfOriginalThinSurfaceOnFace = this.computeMaxMeshMaskId() + 1;
        FaceDataField<Integer> duplicatedThinPlateToOriginalIdFace = new FaceDataField<Integer>(idOfOriginalThinSurfaceOnFace, nameOfDuplicatedThinPlateToOriginalIdFace, "this data field associates id of the duplicated thin surface and id of the original thin surface on face", duplicatedThinSurfaceOnFace, dataArrayOfOriginalThinSurfaceFaceId);
        localDataFieldManager.addDataField(duplicatedThinPlateToOriginalIdFace);
        this.idOfDuplicatedThinSurfaceOnEdge = this.computeMaxMeshMaskId() + 1;
        String descriptionOfDuplicatedThinSurfaceOnEdge = "edge mesh mask which stores edge id of the duplicated thin surface";
        EdgeMeshMask duplicatedThinSurfaceOnEdge = new EdgeMeshMask(this.idOfDuplicatedThinSurfaceOnEdge, "duplicatedThinPlateToOriginalIdEdge", "edge mesh mask which stores edge id of the duplicated thin surface", this.mesh);
        int[] dataOfOriginalThinSurfaceEdgeId = new int[this.originalEdgeIdToClone.size()];
        int[] dataOfDuplicatedThinSurfaceEdgeId = new int[this.originalEdgeIdToClone.size()];
        this.idOfOriginalThinSurfaceOnEdge = this.computeMaxMeshMaskId() + 2;
        String descriptionOfOriginalThinSurfaceOnEdge = "edge mesh mask which stores edge id of the original thin surface";
        EdgeMeshMask originalThinSurfaceOnEdge = new EdgeMeshMask(this.idOfOriginalThinSurfaceOnEdge, "originalThinPlateToDuplicatedIdEdge", "edge mesh mask which stores edge id of the original thin surface", this.mesh);
        Set<Map.Entry<Integer, Edge>> entrySet = this.originalEdgeIdToClone.entrySet();
        int index = 0;
        for (Map.Entry<Integer, Edge> entry : entrySet) {
            Integer edgeIdOnOriginalThinSurface = entry.getKey();
            int edgeIdOnDuplicatedThinSurface = entry.getValue().getId();
            duplicatedThinSurfaceOnEdge.addMeshElementId(edgeIdOnDuplicatedThinSurface);
            localDataFieldManager.addMeshMaskToEdgeId(duplicatedThinSurfaceOnEdge, edgeIdOnDuplicatedThinSurface);
            dataOfOriginalThinSurfaceEdgeId[index] = edgeIdOnOriginalThinSurface;
            originalThinSurfaceOnEdge.addMeshElementId(edgeIdOnOriginalThinSurface);
            localDataFieldManager.addMeshMaskToEdgeId(originalThinSurfaceOnEdge, edgeIdOnOriginalThinSurface);
            dataOfDuplicatedThinSurfaceEdgeId[index] = edgeIdOnDuplicatedThinSurface;
            ++index;
        }
        localDataFieldManager.addEdgeMeshMask(duplicatedThinSurfaceOnEdge);
        localDataFieldManager.addEdgeMeshMask(originalThinSurfaceOnEdge);
        IntDataArray dataArrayOfOriginalThinSurfaceEdgeId = new IntDataArray(dataOfOriginalThinSurfaceEdgeId);
        EdgeDataField<Integer> duplicatedThinPlateToOriginalIdEdge = new EdgeDataField<Integer>(this.idOfDuplicatedThinSurfaceOnEdge, "duplicatedThinPlateToOriginalIdEdge", "this data field associates id of the duplicated thin surface and id of the original thin surface on edge", duplicatedThinSurfaceOnEdge, dataArrayOfOriginalThinSurfaceEdgeId);
        localDataFieldManager.addDataField(duplicatedThinPlateToOriginalIdEdge);
        IntDataArray dataArrayOfDuplicatedThinSurfaceEdgeId = new IntDataArray(dataOfDuplicatedThinSurfaceEdgeId);
        EdgeDataField<Integer> originalThinPlateToDuplicatedIdEdge = new EdgeDataField<Integer>(this.idOfOriginalThinSurfaceOnEdge, "originalThinPlateToDuplicatedIdEdge", "this data field associates id of the original thin surface and id of the duplicated thin surface on edge", originalThinSurfaceOnEdge, dataArrayOfDuplicatedThinSurfaceEdgeId);
        localDataFieldManager.addDataField(originalThinPlateToDuplicatedIdEdge);
        this.idOfDuplicatedThinSurfaceOnVertex = this.computeMaxMeshMaskId() + 1;
        String descriptionOfDuplicatedThinSurfaceOnVertex = "vertex mesh mask which stores vertex id of the duplicated thin surface";
        VertexMeshMask duplicatedThinSurfaceOnVertex = new VertexMeshMask(this.idOfDuplicatedThinSurfaceOnVertex, "duplicatedThinPlateToOriginalIdVertex", "vertex mesh mask which stores vertex id of the duplicated thin surface", this.mesh);
        int[] dataOfOriginalThinSurfaceVertexId = new int[this.originalVertexIdToClone.size()];
        int[] dataOfDuplicatedThinSurfaceVertexId = new int[this.originalVertexIdToClone.size()];
        this.idOfOriginalThinSurfaceOnVertex = this.computeMaxMeshMaskId() + 2;
        String descriptionOfOriginalThinSurfaceOnVertex = "vertex mesh mask which stores vertex id of the original thin surface";
        VertexMeshMask originalThinSurfaceOnVertex = new VertexMeshMask(this.idOfOriginalThinSurfaceOnVertex, "originalThinPlateToDuplicatedIdVertex", "vertex mesh mask which stores vertex id of the original thin surface", this.mesh);
        Set<Map.Entry<Integer, Vertex>> vertexEntrySet = this.originalVertexIdToClone.entrySet();
        index = 0;
        for (Map.Entry<Integer, Vertex> entry : vertexEntrySet) {
            Integer vertexIdOnOriginalThinSurface = entry.getKey();
            int vertexIdOnDuplicatedThinSurface = entry.getValue().getId();
            duplicatedThinSurfaceOnVertex.addMeshElementId(vertexIdOnDuplicatedThinSurface);
            localDataFieldManager.addMeshMaskToVertexId(duplicatedThinSurfaceOnVertex, vertexIdOnDuplicatedThinSurface);
            dataOfOriginalThinSurfaceVertexId[index] = vertexIdOnOriginalThinSurface;
            originalThinSurfaceOnVertex.addMeshElementId(vertexIdOnOriginalThinSurface);
            localDataFieldManager.addMeshMaskToVertexId(originalThinSurfaceOnVertex, vertexIdOnOriginalThinSurface);
            dataOfDuplicatedThinSurfaceVertexId[index] = vertexIdOnDuplicatedThinSurface;
            ++index;
        }
        localDataFieldManager.addVertexMeshMask(originalThinSurfaceOnVertex);
        localDataFieldManager.addVertexMeshMask(duplicatedThinSurfaceOnVertex);
        IntDataArray dataArrayOfOriginalThinSurfaceVertexId = new IntDataArray(dataOfOriginalThinSurfaceVertexId);
        VertexDataField<Integer> duplicatedThinPlateToOriginalIdVertex = new VertexDataField<Integer>(this.idOfDuplicatedThinSurfaceOnVertex, "duplicatedThinPlateToOriginalIdVertex", "this data field associates id of the duplicated thin surface and id of the original thin surface on vertex", duplicatedThinSurfaceOnVertex, dataArrayOfOriginalThinSurfaceVertexId);
        localDataFieldManager.addDataField(duplicatedThinPlateToOriginalIdVertex);
        IntDataArray dataArrayOfDuplicatedThinSurfaceVertexId = new IntDataArray(dataOfDuplicatedThinSurfaceVertexId);
        VertexDataField<Integer> originalThinPlateToDuplicatedIdVertex = new VertexDataField<Integer>(this.idOfOriginalThinSurfaceOnVertex, "originalThinPlateToDuplicatedIdVertex", "this data field associates id of the original thin surface and id of the duplicated thin surface on vertex", originalThinSurfaceOnVertex, dataArrayOfDuplicatedThinSurfaceVertexId);
        localDataFieldManager.addDataField(originalThinPlateToDuplicatedIdVertex);
        this.idOfNoPhysicalDuplicatedThinSurfaceOnEdge = this.computeMaxMeshMaskId() + 1;
        String descriptionOfNoPhysicalDuplicatedThinSurfaceOnEdge = "edge mesh mask which stores edge id of the no physical duplicated thin surface";
        EdgeMeshMask noPhysicalDuplicatedThinSurfaceOnEdge = new EdgeMeshMask(this.idOfNoPhysicalDuplicatedThinSurfaceOnEdge, nameOfNoPhysicalDuplicatedThinSurfaceOnEdge, "edge mesh mask which stores edge id of the no physical duplicated thin surface", this.mesh);
        int[] dataOfNoPhysicalOriginalThinSurfaceEdgeId = new int[this.originalEdgeIdToDuplicatedEdge.size()];
        int[] dataOfNoPhysicalDuplicatedThinSurfaceEdgeId = new int[this.originalEdgeIdToDuplicatedEdge.size()];
        this.idOfNoPhysicalOriginalThinSurfaceOnEdge = this.computeMaxMeshMaskId() + 2;
        String descriptionOfNoPhysicalOriginalThinSurfaceOnEdge = "edge mesh mask which stores edge id of the no physical original thin surface";
        EdgeMeshMask noPhysicalOriginalThinSurfaceOnEdge = new EdgeMeshMask(this.idOfNoPhysicalOriginalThinSurfaceOnEdge, "noPhysicalOriginalThinPlateToDuplicatedIdEdge", "edge mesh mask which stores edge id of the no physical original thin surface", this.mesh);
        Set<Map.Entry<Integer, Edge>> noPhysicalEntrySet = this.originalEdgeIdToDuplicatedEdge.entrySet();
        index = 0;
        for (Map.Entry<Integer, Edge> entry : noPhysicalEntrySet) {
            Integer edgeIdOnNoPhysicalOriginalThinSurface = entry.getKey();
            int edgeIdOnNoPhysicalDuplicatedThinSurface = entry.getValue().getId();
            noPhysicalDuplicatedThinSurfaceOnEdge.addMeshElementId(edgeIdOnNoPhysicalDuplicatedThinSurface);
            localDataFieldManager.addMeshMaskToEdgeId(noPhysicalDuplicatedThinSurfaceOnEdge, edgeIdOnNoPhysicalDuplicatedThinSurface);
            dataOfNoPhysicalOriginalThinSurfaceEdgeId[index] = edgeIdOnNoPhysicalOriginalThinSurface;
            noPhysicalOriginalThinSurfaceOnEdge.addMeshElementId(edgeIdOnNoPhysicalOriginalThinSurface);
            localDataFieldManager.addMeshMaskToEdgeId(noPhysicalOriginalThinSurfaceOnEdge, edgeIdOnNoPhysicalOriginalThinSurface);
            dataOfNoPhysicalDuplicatedThinSurfaceEdgeId[index] = edgeIdOnNoPhysicalDuplicatedThinSurface;
            ++index;
        }
        localDataFieldManager.addEdgeMeshMask(noPhysicalOriginalThinSurfaceOnEdge);
        localDataFieldManager.addEdgeMeshMask(noPhysicalDuplicatedThinSurfaceOnEdge);
        IntDataArray dataArrayOfNoPhysicalOriginalThinSurfaceEdgeId = new IntDataArray(dataOfNoPhysicalOriginalThinSurfaceEdgeId);
        EdgeDataField<Integer> noPhysicalDuplicatedThinPlateToOriginalIdEdge = new EdgeDataField<Integer>(this.idOfNoPhysicalDuplicatedThinSurfaceOnEdge, nameOfNoPhysicalDuplicatedThinSurfaceToOriginalIdEdge, "this data field associates id of the no physical duplicated thin surface and id of the no physical original thin surface on edge", noPhysicalDuplicatedThinSurfaceOnEdge, dataArrayOfNoPhysicalOriginalThinSurfaceEdgeId);
        localDataFieldManager.addDataField(noPhysicalDuplicatedThinPlateToOriginalIdEdge);
        IntDataArray dataArrayOfNoPhysicalDuplicatedThinSurfaceEdgeId = new IntDataArray(dataOfNoPhysicalDuplicatedThinSurfaceEdgeId);
        EdgeDataField<Integer> noPhysicalOriginalThinPlateToDuplicatedIdEdge = new EdgeDataField<Integer>(this.idOfNoPhysicalOriginalThinSurfaceOnEdge, "noPhysicalOriginalThinPlateToDuplicatedIdEdge", "this data field associates id of no physical the original thin surface and id of the no physical duplicated thin surface on edge", noPhysicalOriginalThinSurfaceOnEdge, dataArrayOfNoPhysicalDuplicatedThinSurfaceEdgeId);
        localDataFieldManager.addDataField(noPhysicalOriginalThinPlateToDuplicatedIdEdge);
        int idOfNoPhysicalDuplicatedThinSurfaceOnFace = this.computeMaxMeshMaskId() + 1;
        String descriptionOfNoPhysicalDuplicatedThinSurfaceOnFace = "Face mesh mask which stores Face id of the no physical duplicated thin surface";
        FaceMeshMask noPhysicalDuplicatedThinSurfaceOnFace = new FaceMeshMask(idOfNoPhysicalDuplicatedThinSurfaceOnFace, "noPhysicalDuplicatedThinPlateToOriginalIdFace", "Face mesh mask which stores Face id of the no physical duplicated thin surface", this.mesh);
        int[] dataOfNoPhysicalOriginalThinSurfaceFaceId = new int[this.originalFaceIdToDuplicatedFace.size()];
        int[] dataOfNoPhysicalDuplicatedThinSurfaceFaceId = new int[this.originalFaceIdToDuplicatedFace.size()];
        int idOfNoPhysicalOriginalThinSurfaceOnFace = idOfNoPhysicalDuplicatedThinSurfaceOnFace + 1;
        String descriptionOfNoPhysicalOriginalThinSurfaceOnFace = "Face mesh mask which stores Face id of the no physical original thin surface";
        FaceMeshMask noPhysicalOriginalThinSurfaceOnFace = new FaceMeshMask(idOfNoPhysicalOriginalThinSurfaceOnFace, nameOfNoPhysicalOriginalThinSurfaceOnFace, "Face mesh mask which stores Face id of the no physical original thin surface", this.mesh);
        Set<Map.Entry<Integer, Face>> faceEntrySet = this.originalFaceIdToDuplicatedFace.entrySet();
        index = 0;
        for (Map.Entry<Integer, Face> entry : faceEntrySet) {
            Integer faceIdOnNoPhysicalOriginalThinSurface = entry.getKey();
            int faceIdOnNoPhysicalDuplicatedThinSurface = entry.getValue().getId();
            noPhysicalDuplicatedThinSurfaceOnFace.addMeshElementId(faceIdOnNoPhysicalDuplicatedThinSurface);
            localDataFieldManager.addMeshMaskToFaceId(noPhysicalDuplicatedThinSurfaceOnFace, faceIdOnNoPhysicalDuplicatedThinSurface);
            dataOfNoPhysicalOriginalThinSurfaceFaceId[index] = faceIdOnNoPhysicalOriginalThinSurface;
            noPhysicalOriginalThinSurfaceOnFace.addMeshElementId(faceIdOnNoPhysicalOriginalThinSurface);
            localDataFieldManager.addMeshMaskToFaceId(noPhysicalOriginalThinSurfaceOnFace, faceIdOnNoPhysicalOriginalThinSurface);
            dataOfNoPhysicalDuplicatedThinSurfaceFaceId[index] = faceIdOnNoPhysicalDuplicatedThinSurface;
            ++index;
        }
        localDataFieldManager.addFaceMeshMask(noPhysicalDuplicatedThinSurfaceOnFace);
        localDataFieldManager.addFaceMeshMask(noPhysicalOriginalThinSurfaceOnFace);
        IntDataArray dataArrayOfNoPhysicalOriginalThinSurfaceFaceId = new IntDataArray(dataOfNoPhysicalOriginalThinSurfaceFaceId);
        FaceDataField<Integer> noPhysicalDuplicatedThinPlateToOriginalIdFace = new FaceDataField<Integer>(idOfNoPhysicalDuplicatedThinSurfaceOnFace, "noPhysicalDuplicatedThinPlateToOriginalIdFace", "this data field associates id of the no physical duplicated thin surface and id of the no physical original thin surface on Face", noPhysicalDuplicatedThinSurfaceOnFace, dataArrayOfNoPhysicalOriginalThinSurfaceFaceId);
        this.noPhysicalDuplicatedThinPlateId = idOfNoPhysicalDuplicatedThinSurfaceOnFace;
        localDataFieldManager.addDataField(noPhysicalDuplicatedThinPlateToOriginalIdFace);
        IntDataArray dataArrayOfNoPhysicalDuplicatedThinSurfaceFaceId = new IntDataArray(dataOfNoPhysicalDuplicatedThinSurfaceFaceId);
        FaceDataField<Integer> noPhysicalOriginalThinPlateToDuplicatedIdFace = new FaceDataField<Integer>(idOfNoPhysicalOriginalThinSurfaceOnFace, nameOfNoPhysicalOriginalThinPlateToDuplicatedIdFace, "this data field associates id of the no physical original thin surface and id of the no physical duplicated thin surface on Face", noPhysicalOriginalThinSurfaceOnFace, dataArrayOfNoPhysicalDuplicatedThinSurfaceFaceId);
        this.noPhysicalOriginalThinPlateId = idOfNoPhysicalOriginalThinSurfaceOnFace;
        localDataFieldManager.addDataField(noPhysicalOriginalThinPlateToDuplicatedIdFace);
        MeshMask noPhysicalOriginalThinPlateFaceMeshMask = noPhysicalOriginalThinPlateToDuplicatedIdFace.getMeshMask();
        MeshMask noPhysicalDuplicatedThinPlateFaceMeshMask = noPhysicalDuplicatedThinPlateToOriginalIdFace.getMeshMask();
        for (int noPhysicalOriginalThinPlateFaceMeshElementId : noPhysicalOriginalThinPlateFaceMeshElementIds = noPhysicalOriginalThinPlateFaceMeshMask.getMeshElementIds()) {
            Face noPhysicalFaceId = this.mesh.getFaceById(noPhysicalOriginalThinPlateFaceMeshElementId);
            this.mesh.addMeshElementAndUpdateConnectivity(noPhysicalFaceId);
        }
        for (int noPhysicalDuplicatedThinPlateFaceMeshElementId : noPhysicalDuplicatedThinPlateFaceMeshElementIds = noPhysicalDuplicatedThinPlateFaceMeshMask.getMeshElementIds()) {
            Face noPhysicalFaceId = this.mesh.getFaceById(noPhysicalDuplicatedThinPlateFaceMeshElementId);
            this.mesh.addMeshElementAndUpdateConnectivity(noPhysicalFaceId);
        }
        int[] noPhysicalDuplicatedThinPlateEdgeMeshElementsIds = noPhysicalDuplicatedThinSurfaceOnEdge.getMeshElementIds();
        int[] duplicatedThinPlateEdgeMeshElementsIds = duplicatedThinSurfaceOnEdge.getMeshElementIds();
        EdgeMeshMask duplicatedBorderMeshMask = new EdgeMeshMask(this.computeMaxMeshMaskId() + 1, this.mesh);
        for (int noPhysicalDuplicatedThinPlateEdgeMeshElementsId : noPhysicalDuplicatedThinPlateEdgeMeshElementsIds) {
            for (int duplicatedThinPlateEdgeMeshElementsId : duplicatedThinPlateEdgeMeshElementsIds) {
                if (duplicatedThinPlateEdgeMeshElementsId != noPhysicalDuplicatedThinPlateEdgeMeshElementsId) continue;
                duplicatedBorderMeshMask.addMeshElementId(duplicatedThinPlateEdgeMeshElementsId);
                localDataFieldManager.addMeshMaskToEdgeId(duplicatedBorderMeshMask, duplicatedThinPlateEdgeMeshElementsId);
            }
        }
        int[] noPhysicalOriginalThinPlateEdgeMeshElementsIds = noPhysicalOriginalThinSurfaceOnEdge.getMeshElementIds();
        int[] originalThinPlateEdgeMeshElementsIds = originalThinSurfaceOnEdge.getMeshElementIds();
        EdgeMeshMask originalBorderMeshMask = new EdgeMeshMask(this.computeMaxMeshMaskId() + 2, this.mesh);
        for (int noPhysicalOriginalThinPlateEdgeMeshElementsId : noPhysicalOriginalThinPlateEdgeMeshElementsIds) {
            for (int originalThinPlateEdgeMeshElementsId : originalThinPlateEdgeMeshElementsIds) {
                if (originalThinPlateEdgeMeshElementsId != noPhysicalOriginalThinPlateEdgeMeshElementsId) continue;
                originalBorderMeshMask.addMeshElementId(originalThinPlateEdgeMeshElementsId);
                localDataFieldManager.addMeshMaskToEdgeId(originalBorderMeshMask, originalThinPlateEdgeMeshElementsId);
            }
        }
        localDataFieldManager.addEdgeMeshMask(duplicatedBorderMeshMask);
        this.duplicatedBorderMeshMaskId = duplicatedBorderMeshMask.getId();
        localDataFieldManager.addEdgeMeshMask(originalBorderMeshMask);
        this.originalBorderMeshMaskId = originalBorderMeshMask.getId();
    }

    private int computeMaxMeshMaskId() {
        DataFieldManager localDataFieldManager = this.mesh.getDataFieldManager();
        int maxVertexMeshMaskId = localDataFieldManager.getMaxVertexMeshMaskId();
        int maxEdgeMeshMaskId = localDataFieldManager.getMaxEdgeMeshMaskId();
        int maxFaceMeshMaskId = localDataFieldManager.getMaxFaceMeshMaskId();
        int maxPolyhedronMeshMaskId = localDataFieldManager.getMaxPolyhedronMeshMaskId();
        return Math.max(Math.max(Math.max(maxVertexMeshMaskId, maxEdgeMeshMaskId), maxFaceMeshMaskId), maxPolyhedronMeshMaskId);
    }

    public Map<Integer, Face> getOriginalFaceIdToDuplicatedFace() {
        return this.originalFaceIdToDuplicatedFace;
    }

    public Map<Integer, Edge> getOriginalEdgeIdToDuplicatedEdge() {
        return this.originalEdgeIdToDuplicatedEdge;
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public Map<Integer, Edge> getOriginalEdgeIdToClone() {
        return this.originalEdgeIdToClone;
    }

    public Map<Integer, Vertex> getOriginalVertexIdToClone() {
        return this.originalVertexIdToClone;
    }

    public Map<Integer, Face> getOriginalFaceIdToClone() {
        return this.originalFaceIdToClone;
    }

    public DataFieldManager getDataFieldManager() {
        return this.mesh.getDataFieldManager();
    }

    public int getDuplicatedBorderMeshMaskId() {
        return this.duplicatedBorderMeshMaskId;
    }

    public int getOriginalBorderMeshMaskId() {
        return this.originalBorderMeshMaskId;
    }

    public int getNoPhysicalDuplicatedThinPlateId() {
        return this.noPhysicalDuplicatedThinPlateId;
    }

    public int getNoPhysicalOriginalThinPlateId() {
        return this.noPhysicalOriginalThinPlateId;
    }

    public int[] getParityMeshMaskIdsWithoutTearedFaces() {
        int[] answer = new int[]{this.idOfDuplicatedThinSurfaceOnFace, this.idOfDuplicatedThinSurfaceOnEdge, this.idOfOriginalThinSurfaceOnEdge, this.idOfDuplicatedThinSurfaceOnVertex, this.idOfOriginalThinSurfaceOnVertex, this.idOfNoPhysicalDuplicatedThinSurfaceOnEdge, this.idOfNoPhysicalOriginalThinSurfaceOnEdge};
        return answer;
    }
}

