/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.unit;

import com.artenum.penelope.mesh.interfaces.Unit;

public class SimpleStringUnit
implements Unit,
Cloneable {
    private String unit;
    private String standardUnit;

    public SimpleStringUnit() {
        this.unit = "";
        this.standardUnit = "";
    }

    public SimpleStringUnit(String standardUnitSymbol) {
        this.setStandardUnitSymbol(standardUnitSymbol);
    }

    @Override
    public String getStandardUnitAsString() {
        return "[" + this.standardUnit + "]";
    }

    @Override
    public Unit getUnit() {
        return this;
    }

    @Override
    public String getUnitAsString() {
        return this.unit;
    }

    @Override
    public void setStandardUnit(Unit unit) {
        this.unit = unit.getUnitAsString().replace("[", "").replace("]", "");
        this.standardUnit = unit.getStandardUnitAsString().replace("[", "").replace("]", "");
    }

    @Override
    public void setStandardUnitSymbol(String symbol) {
        this.standardUnit = symbol.replace("[", "").replace("]", "");
        this.unit = this.convertStandardUnitToUnit(symbol);
    }

    @Override
    public void setUnit(Unit unit) {
        this.unit = unit.getUnitAsString().replace("[", "").replace("]", "");
        this.standardUnit = unit.getStandardUnitAsString().replace("[", "").replace("]", "");
    }

    @Override
    public void setUnitSymbol(String symbol) {
        this.unit = symbol.replace("[", "").replace("]", "");
        this.standardUnit = this.convertUnitToStandardUnit(symbol);
    }

    private String convertUnitToStandardUnit(String unit) {
        return unit;
    }

    private String convertStandardUnitToUnit(String standardUnit) {
        return standardUnit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleStringUnit other = (SimpleStringUnit)obj;
        return !(this.unit == null ? other.unit != null : !this.unit.equals(other.unit));
    }

    public String toString() {
        return "SimpleStringUnit [unit=" + this.unit + ", standardUnit=" + this.standardUnit + "]";
    }

    public Unit clone() {
        Unit duplicatedUnit = null;
        try {
            duplicatedUnit = (Unit)super.clone();
        }
        catch (CloneNotSupportedException excpt) {
            excpt.printStackTrace(System.err);
        }
        return duplicatedUnit;
    }
}

