/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.clipping;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.pipeline.graph.VtkObjectCellAdapter;
import com.artenum.cassandra.plugin.CassandraPlugInProperty;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.SimplePlugInProperty;
import com.artenum.cassandra.plugin.clipping.ClippingPlaneControlUI;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkActor;
import vtk.vtkClipDataSet;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkDataSetMapper;
import vtk.vtkImplicitFunction;
import vtk.vtkImplicitPlaneWidget;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkObject;
import vtk.vtkPlane;
import vtk.vtkRenderWindowInteractor;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;

public class ClippingPlanePlugin
implements CassandraPlugin,
RemoveListener {
    private String name;
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private int nbUpdate = 0;
    private ClippingPlaneControlUI controlUI;
    private vtkDataSet lastDataSet;
    private vtkLookupTable outputLookupTable;
    private vtkScalarBarActor outputScalarBar;
    private vtkPlane sourcePlane;
    private vtkClipDataSet planeClip;
    private vtkDataSetMapper outputMapper;
    private vtkActor outputActor;
    private Filter filterImpl;
    private CassandraObject outputCassActor;
    private CassandraObject outputCassMapper;
    private CassandraObject outputCassDataset;
    private CassandraObject outputCassLookupTable;
    private CassandraObject outputCassScalarBar;
    private CassandraObject cassfilter;
    private vtkImplicitPlaneWidget planWidget;
    public static final String PERSISTENCE_KEY_CX = "persistence.key.cx";
    public static final String PERSISTENCE_KEY_CY = "persistence.key.cy";
    public static final String PERSISTENCE_KEY_CZ = "persistence.key.cz";
    public static final String PERSISTENCE_KEY_NX = "persistence.key.nx";
    public static final String PERSISTENCE_KEY_NY = "persistence.key.ny";
    public static final String PERSISTENCE_KEY_NZ = "persistence.key.nz";
    public static final String PERSISTENCE_KEY_INPUT_DATASET = "persistence.key.inputVtkDataSet";
    public static final String PERSISTENCE_KEY_INOUT = "persistence.key.insideOut";
    public static final String PERSISTENCE_KEY_OUPUT_DATASET = "persistence.key.outputDataSet";
    public static final String PERSISTENCE_KEY_OUPUT_MAPPER = "persistence.key.outputMapper";
    public static final String PERSISTENCE_KEY_OUPUT_LOOKUP_TABLE = "persistence.key.outputlookUpTable";
    public static final String PERSISTENCE_KEY_OUTPUT_ACTOR = "persistence.key.outputActor";
    public static final String PERSISTENCE_KEY_OUTPUT_SCALAR_BAR = "persistence.key.ouputScalarBar";
    public static final String PERSISTENCE_KEY_CELL_POS_X = "persistence.key.cell.PosX";
    public static final String PERSISTENCE_KEY_CELL_POS_Y = "persistence.key.cell.PosY";

    public ClippingPlanePlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this.initPlugIn(pipelineManager, pluginManager, owner);
        this.initPipeline();
    }

    public ClippingPlanePlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner, boolean initPipeline) {
        this.initPlugIn(pipelineManager, pluginManager, owner);
        if (initPipeline) {
            this.initPipeline();
        }
    }

    public ClippingPlanePlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner, int initPipeline) {
        this.initPlugIn(pipelineManager, pluginManager, owner);
        if (initPipeline == 1) {
            this.initPipeline();
        }
    }

    public void initPlugIn(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this.name = "Cliping plane";
        this.pipelineManager = pipelineManager;
        this.pluginManager = pluginManager;
        this.filterImpl = new FilterImpl();
        this.filterImpl.addRemoveListener((RemoveListener)this);
        this.filterImpl.setParentPlugin((CassandraPlugin)this);
        this.controlUI = new ClippingPlaneControlUI(pipelineManager, this, owner);
        this.contextualMenu = new JPopupMenu("Cutting plane menu");
        JMenuItem showControl = new JMenuItem("Show control");
        showControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClippingPlanePlugin.this.controlUI.setVisible(true);
                ClippingPlanePlugin.this.controlUI.update3DWidgetStatus();
            }
        });
        this.contextualMenu.add(showControl);
        this.contextualMenu.addSeparator();
        JMenuItem remove = new JMenuItem("Remove");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClippingPlanePlugin.this.remove();
            }
        });
        this.contextualMenu.add(remove);
    }

    public void initPipeline() {
        if (this.sourcePlane == null) {
            this.sourcePlane = new vtkPlane();
        }
        this.sourcePlane.SetOrigin(0.0, 0.0, 0.0);
        this.sourcePlane.SetNormal(0.0, 0.0, 1.0);
        if (this.planeClip == null) {
            this.planeClip = new vtkClipDataSet();
            this.outputCassDataset = this.pipelineManager.addDataSet((Object)this.planeClip.GetOutput(), "Clipping Plane Output");
        } else {
            this.outputCassDataset = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.planeClip);
        }
        this.planeClip.SetClipFunction((vtkImplicitFunction)this.sourcePlane);
        if (this.outputMapper == null) {
            this.outputMapper = new vtkDataSetMapper();
            this.outputCassMapper = this.pipelineManager.addMapper((Object)this.outputMapper, "Clipping plane Mapper");
        } else {
            this.outputCassMapper = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.outputMapper);
        }
        this.outputMapper.SetInput((vtkDataSet)this.planeClip.GetOutput());
        if (this.outputActor == null) {
            this.outputActor = new vtkActor();
            this.outputCassActor = this.pipelineManager.addActor((Object)this.outputActor, "Clipping plane Actor");
        } else {
            this.outputCassActor = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.outputActor);
        }
        this.outputActor.SetMapper((vtkMapper)this.outputMapper);
        if (this.outputLookupTable == null) {
            this.outputLookupTable = new vtkLookupTable();
            this.outputCassLookupTable = this.pipelineManager.addLookupTable(this.outputLookupTable, "Clipping plane");
        } else {
            this.outputCassLookupTable = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.outputLookupTable);
        }
        this.outputLookupTable.SetHueRange(0.66667, 0.0);
        this.outputLookupTable.Build();
        this.outputMapper.SetLookupTable((vtkScalarsToColors)this.outputLookupTable);
        if (this.outputScalarBar == null) {
            this.outputScalarBar = new vtkScalarBarActor();
            this.outputCassScalarBar = this.pipelineManager.addScalarBar(this.outputScalarBar, "Clipping plane");
        } else {
            this.outputCassScalarBar = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.outputScalarBar);
        }
        this.outputScalarBar.SetLookupTable((vtkScalarsToColors)this.outputLookupTable);
        this.cassfilter = this.pipelineManager.addFilter(this.filterImpl, "Clipping Plane Filter");
        this.cassfilter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
        this.outputCassActor.setValide(false);
        if (this.planWidget != null) {
            this.planWidget.SetNormal(this.sourcePlane.GetNormal());
            this.planWidget.SetOrigin(this.sourcePlane.GetOrigin());
        }
    }

    @Deprecated
    public void setInternalPipelineComponents(vtkPlane plane, vtkClipDataSet planeClip, vtkDataSetMapper cutMapper, vtkActor cutActor) {
        this.sourcePlane = plane;
        this.planeClip = planeClip;
    }

    public void updateClippingPlane(double cx, double cy, double cz, double nx, double ny, double nz, vtkDataSet vtkDataSet2, boolean insideOut) {
        if (vtkDataSet2 == null) {
            return;
        }
        this.outputCassActor.setValide(true);
        this.sourcePlane.SetOrigin(cx, cy, cz);
        this.sourcePlane.SetNormal(nx, ny, nz);
        this.planeClip.SetInput((vtkDataObject)vtkDataSet2);
        this.planeClip.SetInsideOut(insideOut ? 1 : 0);
        this.outputCassLookupTable = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)((vtkLookupTable)this.outputMapper.GetLookupTable()));
        this.outputCassScalarBar = this.pipelineManager.getVtkObject((Integer)this.outputCassLookupTable.getOutputConnectivityList().get(0));
        if (!(vtkDataSet2.GetPointData().GetScalars() == null && vtkDataSet2.GetCellData().GetScalars() == null || this.lastDataSet != null && this.lastDataSet.equals(vtkDataSet2) || !this.outputMapper.GetLookupTable().equals(this.outputLookupTable))) {
            this.outputMapper.SetScalarRange(vtkDataSet2.GetScalarRange());
            this.outputLookupTable.SetTableRange(vtkDataSet2.GetScalarRange());
            this.lastDataSet = vtkDataSet2;
        }
        if (this.pipelineManager.getActorList().getData().contains(this.outputCassActor)) {
            this.pipelineManager.setActorVisible(this.outputCassActor, true);
        }
        this.pipelineManager.hideInputActor(this.outputCassActor, vtkDataSet2);
        this.filterImpl.getInputDataSet().clear();
        this.filterImpl.getInputDataSet().add(vtkDataSet2);
        this.filterImpl.getOutputDataSet().clear();
        this.filterImpl.getOutputDataSet().add(this.planeClip.GetOutput());
        this.filterImpl.getAlgorithm().add(this.planeClip);
        this.filterImpl.getVtkImplicitFunction().clear();
        this.filterImpl.getVtkImplicitFunction().add(this.sourcePlane);
        this.pipelineManager.notifyConnectivityChange(this.cassfilter);
    }

    public String getName() {
        return this.name;
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.outputCassActor);
        this.pipelineManager.removeVtkObject(this.outputCassMapper);
        this.pipelineManager.removeVtkObject(this.outputCassDataset);
        this.pipelineManager.removeVtkObject(this.cassfilter);
    }

    public String toString() {
        return this.getName();
    }

    public void show3DWidget(boolean widgetFlag) {
        if (widgetFlag) {
            if (this.planWidget == null) {
                this.init3DWidget();
            }
            this.planWidget.UpdatePlacement();
            this.planWidget.On();
        } else if (this.planWidget != null) {
            this.planWidget.Off();
        }
    }

    private void init3DWidget() {
        this.planWidget = new vtkImplicitPlaneWidget();
        this.planWidget.SetInteractor((vtkRenderWindowInteractor)this.pipelineManager.getCassandraView().getRenderWindowInteractor());
        this.planWidget.EnabledOn();
        this.planWidget.SetInput(this.lastDataSet);
        this.planWidget.SetPlaceFactor(1.2);
        this.planWidget.PlaceWidget();
        this.planWidget.SetNormal(this.sourcePlane.GetNormal());
        this.planWidget.GetPlaneProperty().SetOpacity(0.3);
        this.planWidget.AddObserver("InteractionEvent", (Object)this, "interactionCallBack");
    }

    private void widgetCharEvent() {
        char code = Character.toLowerCase(this.pipelineManager.getCassandraView().getRenderWindowInteractor().GetKeyCode());
        System.out.println("touch typed:" + code);
        if (code == 'b') {
            this.planWidget.SetEnabled(1);
        }
    }

    private void startInteractionCallBack() {
        System.out.println("wiget interaction started");
    }

    private void interactionCallBack() {
        this.sourcePlane.SetNormal(this.planWidget.GetNormal());
        this.controlUI.setNormalFieldsValues(this.planWidget.GetNormal());
        this.controlUI.setOrigineFieldsValues(this.planWidget.GetOrigin());
        this.sourcePlane.SetOrigin(this.planWidget.GetOrigin()[0], this.planWidget.GetOrigin()[1], this.planWidget.GetOrigin()[2]);
    }

    public Filter getInternalFilter() {
        return this.filterImpl;
    }

    public PlugInControlUI getControlUI() {
        return this.controlUI;
    }

    public void initAndUpdate(CassandraPlugInProperty prop) {
        double cx = 0.0;
        double cy = 0.0;
        double cz = 0.0;
        double nx = 0.0;
        double ny = 0.0;
        double nz = 0.0;
        boolean inOut = false;
        cx = prop.getSafely((Object)PERSISTENCE_KEY_CX, 0.0);
        cy = prop.getSafely((Object)PERSISTENCE_KEY_CY, 0.0);
        cz = prop.getSafely((Object)PERSISTENCE_KEY_CZ, 0.0);
        nx = prop.getSafely((Object)PERSISTENCE_KEY_NX, 1.0);
        ny = prop.getSafely((Object)PERSISTENCE_KEY_NY, 0.0);
        nz = prop.getSafely((Object)PERSISTENCE_KEY_NZ, 0.0);
        this.planeClip = new vtkClipDataSet();
        this.planeClip.SetOutput((vtkDataObject)prop.getSafely((Object)PERSISTENCE_KEY_OUPUT_DATASET, null));
        inOut = prop.getSafely((Object)PERSISTENCE_KEY_INOUT, 1) == 1;
        vtkDataSet tmpInputDataSet = (vtkDataSet)prop.getSafely((Object)PERSISTENCE_KEY_INPUT_DATASET, (Object)((vtkDataSet)this.planeClip.GetInput()));
        this.outputLookupTable = (vtkLookupTable)prop.getSafely((Object)PERSISTENCE_KEY_OUPUT_LOOKUP_TABLE, null);
        this.outputMapper = (vtkDataSetMapper)prop.getSafely((Object)PERSISTENCE_KEY_OUPUT_MAPPER, null);
        this.outputActor = (vtkActor)prop.getSafely((Object)PERSISTENCE_KEY_OUTPUT_ACTOR, null);
        this.outputScalarBar = (vtkScalarBarActor)prop.getSafely((Object)PERSISTENCE_KEY_OUTPUT_SCALAR_BAR, null);
        this.initPipeline();
        this.controlUI.setNormalFieldsValues(nx, ny, nz);
        this.controlUI.setOrigineFieldsValues(cx, cy, cz);
        this.controlUI.setSelectedInput(this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)tmpInputDataSet));
        this.updateClippingPlane(cx, cy, cy, nx, ny, cy, tmpInputDataSet, inOut);
        int cellPosX = prop.getSafely((Object)PERSISTENCE_KEY_CELL_POS_X, -1);
        int cellPosY = prop.getSafely((Object)PERSISTENCE_KEY_CELL_POS_Y, -1);
        if (cellPosX > 0 && cellPosY > 0) {
            ((VtkObjectCellAdapter)this.cassfilter.getMetaData().get("CELL")).setPosition(new Point(cellPosX, cellPosY));
        }
    }

    public CassandraPlugInProperty getPlugInProperty() {
        this.outputCassLookupTable = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)((vtkLookupTable)this.outputMapper.GetLookupTable()));
        this.outputLookupTable = (vtkLookupTable)this.outputCassLookupTable.getVtkObject();
        this.outputCassScalarBar = this.pipelineManager.getVtkObject((Integer)this.outputCassLookupTable.getOutputConnectivityList().get(0));
        this.outputScalarBar = (vtkScalarBarActor)this.outputCassScalarBar.getVtkObject();
        SimplePlugInProperty prop = new SimplePlugInProperty();
        prop.put((Object)PERSISTENCE_KEY_CX, (Object)new Double(this.sourcePlane.GetOrigin()[0]));
        prop.put((Object)PERSISTENCE_KEY_CY, (Object)new Double(this.sourcePlane.GetOrigin()[1]));
        prop.put((Object)PERSISTENCE_KEY_CZ, (Object)new Double(this.sourcePlane.GetOrigin()[2]));
        prop.put((Object)PERSISTENCE_KEY_NX, (Object)new Double(this.sourcePlane.GetNormal()[0]));
        prop.put((Object)PERSISTENCE_KEY_NY, (Object)new Double(this.sourcePlane.GetNormal()[1]));
        prop.put((Object)PERSISTENCE_KEY_NZ, (Object)new Double(this.sourcePlane.GetNormal()[2]));
        prop.put((Object)PERSISTENCE_KEY_INPUT_DATASET, (Object)this.planeClip.GetInput());
        prop.put((Object)PERSISTENCE_KEY_INOUT, (Object)this.planeClip.GetInsideOut());
        prop.put((Object)PERSISTENCE_KEY_OUPUT_DATASET, (Object)this.planeClip.GetOutput());
        prop.put((Object)PERSISTENCE_KEY_OUPUT_MAPPER, (Object)this.outputMapper);
        prop.put((Object)PERSISTENCE_KEY_OUPUT_LOOKUP_TABLE, this.outputCassLookupTable.getVtkObject());
        prop.put((Object)PERSISTENCE_KEY_OUTPUT_ACTOR, this.outputCassActor.getVtkObject());
        prop.put((Object)PERSISTENCE_KEY_OUTPUT_SCALAR_BAR, this.outputCassScalarBar.getVtkObject());
        Point cellPosition = ((VtkObjectCellAdapter)this.cassfilter.getMetaData().get("CELL")).getPosition();
        prop.put((Object)PERSISTENCE_KEY_CELL_POS_X, (Object)cellPosition.x);
        prop.put((Object)PERSISTENCE_KEY_CELL_POS_Y, (Object)cellPosition.y);
        return prop;
    }
}

