/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.renderer.vtk;

import com.artenum.cassandra.renderer.vtk.PickingObserver;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import vtk.vtkAbstractPicker;
import vtk.vtkCamera;
import vtk.vtkCanvas;
import vtk.vtkCellPicker;
import vtk.vtkDataObject;
import vtk.vtkGenericRenderWindowInteractor;
import vtk.vtkInteractorObserver;
import vtk.vtkInteractorStyleTrackballCamera;
import vtk.vtkJPEGWriter;
import vtk.vtkPNGWriter;
import vtk.vtkPointPicker;
import vtk.vtkTIFFWriter;
import vtk.vtkWindow;
import vtk.vtkWindowToImageFilter;

public class CassandraView
extends vtkCanvas
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private double zoomFactor = 0.1;
    private boolean deepValidation = true;
    private int pickMode = 0;
    private final vtkPointPicker pointPicker = new vtkPointPicker();
    private final vtkCellPicker cellPicker;
    private final ArrayList<PickingObserver> pickingObservers;
    public static final int PICK_MODE_TO_NONE = -1;
    public static final int PICK_MODE_TO_NODE = 0;
    public static final int PICK_MODE_TO_CELL = 1;
    public static final double DEFAULT_POINT_PICKER_TOLERANCE = 0.05;
    public static final double DEFAULT_CELL_PICKER_TOLERANCE = 0.05;

    public CassandraView() {
        this.pointPicker.SetTolerance(0.05);
        this.cellPicker = new vtkCellPicker();
        this.cellPicker.SetTolerance(0.05);
        vtkInteractorStyleTrackballCamera style = new vtkInteractorStyleTrackballCamera();
        this.getRenderWindowInteractor().SetInteractorStyle((vtkInteractorObserver)style);
        this.setPickMode(this.pickMode);
        this.pickingObservers = new ArrayList();
    }

    public void setPickMode(int pickMode) {
        this.pickMode = pickMode;
        switch (this.pickMode) {
            case -1: {
                this.getRenderWindowInteractor().SetPicker(null);
                this.pointPicker.RemoveAllObservers();
                this.cellPicker.RemoveAllObservers();
                break;
            }
            case 0: {
                this.getRenderWindowInteractor().SetPicker((vtkAbstractPicker)this.pointPicker);
                this.pointPicker.AddObserver("EndPickEvent", (Object)this, "pick");
                break;
            }
            case 1: {
                this.getRenderWindowInteractor().SetPicker((vtkAbstractPicker)this.cellPicker);
                this.cellPicker.AddObserver("EndPickEvent", (Object)this, "pick");
                break;
            }
        }
    }

    public int getPickingMode() {
        return this.pickMode;
    }

    public void addPickingObserver(PickingObserver po) {
        this.pickingObservers.add(po);
    }

    public void removePickingObserver(PickingObserver po) {
        this.pickingObservers.remove(po);
    }

    public void removePickingObserver(int index) {
        this.pickingObservers.remove(index);
    }

    public double getPointPickerTolerance() {
        return this.pointPicker.GetTolerance();
    }

    public void setPointPickerTolerance(double tolerance) {
        this.pointPicker.SetTolerance(tolerance);
    }

    public double getCellPickerTolerance() {
        return this.cellPicker.GetTolerance();
    }

    public void setCellPickerTolerance(double tolerance) {
        this.cellPicker.SetTolerance(tolerance);
    }

    public void pick() {
        PickingObserver observer2 = null;
        for (PickingObserver observer2 : this.pickingObservers) {
            System.out.println("Picked point: " + this.pointPicker.GetPointId());
            if (this.pickMode == 0) {
                observer2.pickPoint(this.pointPicker);
            }
            if (this.pickMode != 1) continue;
            observer2.pickCell(this.cellPicker);
        }
    }

    public vtkPointPicker getPointPicker() {
        return this.pointPicker;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void setXYView() {
        this.setCameraPosition(0.0, 0.0, this.ren.GetActiveCamera().GetDistance(), 0.0);
        this.UpdateLight();
        this.resetCamera();
    }

    public void setYXView() {
        this.setCameraPosition(0.0, 0.0, -this.ren.GetActiveCamera().GetDistance(), 0.0);
        this.UpdateLight();
        this.resetCamera();
    }

    public void setYZView() {
        this.setCameraPosition(this.ren.GetActiveCamera().GetDistance(), 0.0, 0.0, 0.0);
        this.UpdateLight();
        this.resetCamera();
    }

    public void setZYView() {
        this.setCameraPosition(-this.ren.GetActiveCamera().GetDistance(), 0.0, 0.0, 0.0);
        this.UpdateLight();
        this.resetCamera();
    }

    public void setXZView() {
        this.setCameraPosition(0.0, this.ren.GetActiveCamera().GetDistance(), 0.0, 45.0);
        this.UpdateLight();
        this.resetCamera();
    }

    public void setZXView() {
        this.setCameraPosition(0.0, -this.ren.GetActiveCamera().GetDistance(), 0.0, 45.0);
        this.UpdateLight();
        this.resetCamera();
    }

    protected void setCameraPosition(double xCam, double yCam, double zCam, double rollCam) {
        System.out.println("Origin: " + this.GetRenderer().GetOrigin()[0] + ", " + this.GetRenderer().GetOrigin()[0] + ", " + this.GetRenderer().GetOrigin()[0]);
        this.ren.GetActiveCamera().SetPosition(xCam, yCam, zCam);
        this.ren.GetActiveCamera().SetRoll(rollCam);
    }

    public void setBackground(Color c) {
        double r = (float)c.getRed() / 255.0f;
        double g = (float)c.getGreen() / 255.0f;
        double b = (float)c.getBlue() / 255.0f;
        this.GetRenderer().SetBackground(r, g, b);
    }

    public void setAmbiantLight(Color c) {
        double r = (float)c.getRed() / 255.0f;
        double g = (float)c.getGreen() / 255.0f;
        double b = (float)c.getBlue() / 255.0f;
        this.GetRenderer().SetAmbient(r, g, b);
    }

    public void resetCamera() {
        super.resetCamera();
    }

    public void zoom(double zoomFactor) {
        vtkCamera cam = this.GetRenderer().GetActiveCamera();
        if (cam.GetParallelProjection() == 1) {
            cam.SetParallelScale(cam.GetParallelScale() / zoomFactor);
        } else {
            cam.Dolly(zoomFactor);
            this.resetCameraClippingRange();
        }
    }

    public void rotate(double xx, double yy) {
        vtkCamera cam = this.GetRenderer().GetActiveCamera();
        cam.Azimuth(xx);
        cam.Elevation(yy);
        cam.OrthogonalizeViewUp();
        this.resetCameraClippingRange();
        if (this.LightFollowCamera == 1) {
            this.lgt.SetPosition(cam.GetPosition());
            this.lgt.SetFocalPoint(cam.GetFocalPoint());
        }
        System.out.println("Origin: " + this.GetRenderer().GetOrigin()[0] + ", " + this.GetRenderer().GetOrigin()[0] + ", " + this.GetRenderer().GetOrigin()[0]);
    }

    public synchronized void deepValidateView() {
        if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1) {
            this.Render();
            this.invalidate();
            this.validate();
            this.repaint();
        } else {
            this.repaint();
        }
        Dimension d = this.getPreferredSize();
        if (!this.getSize().equals(d)) {
            this.setSize(1, 1);
            this.setSize(d);
            this.invalidate();
            this.validate();
            this.repaint();
        } else if (this.deepValidation) {
            this.deepValidation = false;
            this.setSize(1, 1);
            this.setSize(d);
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void validateViewAndWait() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1) {
                        CassandraView.this.Render();
                        CassandraView.this.invalidate();
                        CassandraView.this.validate();
                        CassandraView.this.repaint();
                    } else {
                        CassandraView.this.repaint();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void validateViewAndGo() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1) {
                        CassandraView.this.Render();
                        CassandraView.this.invalidate();
                        CassandraView.this.validate();
                        CassandraView.this.repaint();
                    } else {
                        CassandraView.this.repaint();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 73) {
            this.zoom(1.0 + this.zoomFactor);
        } else if (e.getKeyCode() == 79) {
            this.zoom(1.0 - this.zoomFactor);
        } else if (e.getKeyCode() == 38) {
            this.rotate(0.0, -1.0);
        } else if (e.getKeyCode() == 40) {
            this.rotate(0.0, 1.0);
        } else if (e.getKeyCode() == 37) {
            this.rotate(1.0, 0.0);
        } else if (e.getKeyCode() == 39) {
            this.rotate(-1.0, 0.0);
        } else {
            super.keyPressed(e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        super.keyReleased(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        super.keyTyped(e);
    }

    public synchronized void saveToPNG(String fileToSave) {
        this.Lock();
        String os = System.getProperty("os.name").toLowerCase();
        Boolean isLinux = os.contains("linux");
        if (isLinux.booleanValue()) {
            this.GetRenderWindow().OffScreenRenderingOn();
        }
        vtkWindowToImageFilter w2if = new vtkWindowToImageFilter();
        w2if.SetInput((vtkWindow)this.rw);
        w2if.SetMagnification(1);
        w2if.Update();
        vtkPNGWriter writer = new vtkPNGWriter();
        writer.SetInput((vtkDataObject)w2if.GetOutput());
        writer.SetFileName(fileToSave);
        writer.Write();
        if (isLinux.booleanValue()) {
            this.GetRenderWindow().OffScreenRenderingOff();
        }
        this.UnLock();
    }

    public synchronized void saveToJPG(String fileToSave) {
        this.Lock();
        this.GetRenderWindow().OffScreenRenderingOn();
        vtkWindowToImageFilter w2if = new vtkWindowToImageFilter();
        w2if.SetInput((vtkWindow)this.rw);
        w2if.SetMagnification(1);
        this.ren.Render();
        w2if.Update();
        vtkJPEGWriter writer = new vtkJPEGWriter();
        writer.SetInput((vtkDataObject)w2if.GetOutput());
        writer.SetFileName(fileToSave);
        writer.Write();
        this.ren.Render();
        this.GetRenderWindow().OffScreenRenderingOff();
        this.UnLock();
    }

    public synchronized void saveToTIFF(String fileToSave) {
        this.Lock();
        this.GetRenderWindow().OffScreenRenderingOn();
        vtkWindowToImageFilter w2if = new vtkWindowToImageFilter();
        w2if.SetInput((vtkWindow)this.rw);
        w2if.SetMagnification(1);
        this.ren.Render();
        w2if.Update();
        vtkTIFFWriter writer = new vtkTIFFWriter();
        writer.SetInput((vtkDataObject)w2if.GetOutput());
        writer.SetFileName(fileToSave);
        writer.Write();
        this.ren.Render();
        this.GetRenderWindow().OffScreenRenderingOff();
        this.UnLock();
    }

    public vtkGenericRenderWindowInteractor getRenderWindowInteractor() {
        return super.getIren();
    }
}

