/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.gmsh.field;

import com.artenum.penelope.field.DataFieldManager;
import com.artenum.penelope.field.EdgeDataField;
import com.artenum.penelope.field.FaceDataField;
import com.artenum.penelope.field.PolyhedronDataField;
import com.artenum.penelope.field.VertexDataField;
import com.artenum.penelope.field.data.FloatDataArray;
import com.artenum.penelope.field.data.IntDataArray;
import com.artenum.penelope.field.interfaces.DataArray;
import com.artenum.penelope.field.interfaces.DataField;
import com.artenum.penelope.field.io.DataFieldLoadException;
import com.artenum.penelope.field.io.DataFieldLoader;
import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.MeshElement;
import com.artenum.penelope.mesh.interfaces.MeshMask;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.mesh.mask.EdgeMeshMask;
import com.artenum.penelope.mesh.mask.FaceMeshMask;
import com.artenum.penelope.mesh.mask.PolyhedronMeshMask;
import com.artenum.penelope.mesh.mask.VertexMeshMask;
import com.artenum.penelope.plugin.gmsh.mesh.GeometryIdMapper;
import com.artenum.penelope.plugin.gmsh.mesh.GmshDataSection;
import com.artenum.penelope.plugin.gmsh.mesh.GmshMeshBuilder22;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GmshDataFieldLoader
implements DataFieldLoader {
    private final GmshMeshBuilder22 loader;

    public GmshDataFieldLoader(GmshMeshBuilder22 loader) {
        this.loader = loader;
    }

    public DataFieldManager getDataSet() throws DataFieldLoadException {
        MeshType localisation = null;
        DataFieldManager dataSet = new DataFieldManager();
        this.loadNodeDataSection(localisation, dataSet);
        this.loadElementDataSection(localisation, dataSet);
        return dataSet;
    }

    private void loadNodeDataSection(MeshType localisation, DataFieldManager dataSet) {
        List<GmshDataSection> dataSectionList = this.loader.getNodeDataSections();
        System.out.println("data section list size : " + dataSectionList.size());
        for (int dataId = 0; dataId < dataSectionList.size(); ++dataId) {
            IntDataArray dataArray;
            VertexDataField dataField;
            int penelopeId;
            GmshDataSection tmpDataSection = dataSectionList.get(dataId);
            GmshDataSection.GmshDataSectionType type = tmpDataSection.getType();
            System.out.println("type = " + (Object)((Object)type));
            for (int j = 0; j < tmpDataSection.getStrings().size(); ++j) {
                System.out.println(tmpDataSection.getStrings().get(j));
            }
            System.out.println("Nb data: " + tmpDataSection.getNbData());
            Mesh mesh = this.loader.getMesh();
            DataFieldManager dataFieldManager = mesh.getDataFieldManager();
            VertexMeshMask meshMask = new VertexMeshMask(dataId, tmpDataSection.getStrings().get(0), "data from gmsh .msh file.", mesh);
            Set<Integer> associatedIds = tmpDataSection.getAssociatedIds();
            for (int gmshId : associatedIds) {
                penelopeId = this.loader.getIdMapper().getPenelopeVertexId(gmshId);
                System.out.println("vertex gmsh Id: " + gmshId);
                System.out.println("      corresponding to " + penelopeId + " in penelope");
                Vertex elm = mesh.getVertexById(penelopeId);
                meshMask.addMeshElementId(elm.getId());
                dataFieldManager.addMeshMaskToVertexId((MeshMask)meshMask, elm.getId());
                if (localisation != MeshType.UNKNOWN) continue;
                localisation = this.evaluateLocalisation((MeshElement)elm);
                System.out.println("    Localisation: " + localisation);
            }
            System.out.println("    Nb meshElements: " + meshMask.getNbMeshElements());
            int firstElmId = associatedIds.iterator().next();
            if (tmpDataSection.canDataBeInterpretedAsInt(firstElmId)) {
                dataField = new VertexDataField(dataId, tmpDataSection.getStrings().get(0), "data from gmsh .msh file.", (MeshMask)meshMask);
                System.out.println("Data imported as integer....");
                dataArray = new IntDataArray(tmpDataSection.getNbData());
                for (int gmshId : associatedIds) {
                    penelopeId = this.loader.getIdMapper().getPenelopeVertexId(gmshId);
                    int value = tmpDataSection.getDataAsInts(gmshId)[0];
                    dataArray.add((Object)value);
                }
                dataField.setDataArray((DataArray)dataArray);
                meshMask.addDataField((DataField)dataField);
                dataSet.addDataField((DataField)dataField);
                System.out.println("    Nb data: " + dataField.getNbMeshElements());
            } else {
                dataField = new VertexDataField(dataId, tmpDataSection.getStrings().get(0), "data from gmsh .msh file.", (MeshMask)meshMask);
                System.out.println("Data imported as float....");
                dataArray = new FloatDataArray(tmpDataSection.getNbData());
                for (int gmshId : associatedIds) {
                    penelopeId = this.loader.getIdMapper().getPenelopeVertexId(gmshId);
                    dataArray.add(Float.valueOf((float)tmpDataSection.getDataAsDoubles(gmshId)[0]));
                }
                dataField.setDataArray((DataArray)dataArray);
                meshMask.addDataField((DataField)dataField);
                dataSet.addDataField((DataField)dataField);
                System.out.println("    Nb data: " + dataField.getNbMeshElements());
            }
            localisation = null;
        }
    }

    private void loadElementDataSection(MeshType localisation, DataFieldManager dataSet) {
        List<GmshDataSection> dataSectionList = this.loader.getElementDataSections();
        System.out.println("data section list size : " + dataSectionList.size());
        for (int dataId = 0; dataId < dataSectionList.size(); ++dataId) {
            GmshDataSection tmpDataSection = dataSectionList.get(dataId);
            GmshDataSection.GmshDataSectionType type = tmpDataSection.getType();
            System.out.println("type = " + (Object)((Object)type));
            for (int j = 0; j < tmpDataSection.getStrings().size(); ++j) {
                System.out.println(tmpDataSection.getStrings().get(j));
            }
            System.out.println("Nb data: " + tmpDataSection.getNbData());
            VertexMeshMask meshField = null;
            Mesh mesh = this.loader.getMesh();
            DataFieldManager dataFieldManager = mesh.getDataFieldManager();
            GeometryIdMapper idMapper = this.loader.getIdMapper();
            for (Integer next : tmpDataSection.getAssociatedIds()) {
                System.out.println(next);
            }
            Iterator<Integer> iterator2 = tmpDataSection.getAssociatedIds().iterator();
            if (iterator2.hasNext()) {
                int gmshId = iterator2.next();
                Integer penelopeNodeElementId = idMapper.getPenelopeVertexId(gmshId);
                if (penelopeNodeElementId != null) {
                    meshField = new VertexMeshMask(dataId, tmpDataSection.getStrings().get(0), "data from gmsh .msh file.", this.loader.getMesh());
                } else if (idMapper.getPenelopeEdgeId(gmshId) != null) {
                    meshField = new EdgeMeshMask(dataId, tmpDataSection.getStrings().get(0), "data from gmsh .msh file.", this.loader.getMesh());
                } else if (idMapper.getPenelopeFaceId(gmshId) != null) {
                    meshField = new FaceMeshMask(dataId, tmpDataSection.getStrings().get(0), "data from gmsh .msh file.", this.loader.getMesh());
                } else if (idMapper.getPenelopePolyhedronId(gmshId) != null) {
                    meshField = new PolyhedronMeshMask(dataId, tmpDataSection.getStrings().get(0), "data from gmsh .msh file.", this.loader.getMesh());
                } else {
                    throw new UnsupportedOperationException("there is no equivalent id from gmsh mesh element to penelope id. The gmsh id is : " + gmshId);
                }
            }
            Set<Integer> associatedIds = tmpDataSection.getAssociatedIds();
            for (int gmshId : associatedIds) {
                System.out.println("Read Element Id: " + gmshId);
                Integer penelopeNodeElementId = idMapper.getPenelopeVertexId(gmshId);
                Vertex elm = null;
                if (penelopeNodeElementId != null) {
                    elm = this.loader.getMesh().getVertexById(penelopeNodeElementId.intValue());
                    System.out.println("      corresponding to " + penelopeNodeElementId);
                } else if (idMapper.getPenelopeEdgeId(gmshId) != null) {
                    penelopeNodeElementId = idMapper.getPenelopeEdgeId(gmshId);
                    elm = this.loader.getMesh().getEdgeById(penelopeNodeElementId.intValue());
                    System.out.println("      corresponding to " + penelopeNodeElementId);
                } else if (idMapper.getPenelopeFaceId(gmshId) != null) {
                    penelopeNodeElementId = idMapper.getPenelopeFaceId(gmshId);
                    elm = this.loader.getMesh().getFaceById(penelopeNodeElementId.intValue());
                    System.out.println("      corresponding to " + penelopeNodeElementId);
                } else if (idMapper.getPenelopePolyhedronId(gmshId) != null) {
                    penelopeNodeElementId = idMapper.getPenelopePolyhedronId(gmshId);
                    elm = this.loader.getMesh().getPolyhedronById(penelopeNodeElementId.intValue());
                    System.out.println("      corresponding to " + penelopeNodeElementId);
                } else {
                    throw new UnsupportedOperationException("there is no equivalent id from gmsh mesh element to penelope id. The gmsh id is : " + gmshId);
                }
                meshField.addMeshElementId(elm.getId());
                if (meshField instanceof VertexMeshMask) {
                    dataFieldManager.addMeshMaskToVertexId((MeshMask)meshField, elm.getId());
                } else if (meshField instanceof EdgeMeshMask) {
                    dataFieldManager.addMeshMaskToEdgeId((MeshMask)meshField, elm.getId());
                } else if (meshField instanceof FaceMeshMask) {
                    dataFieldManager.addMeshMaskToFaceId((MeshMask)meshField, elm.getId());
                } else if (meshField instanceof PolyhedronMeshMask) {
                    dataFieldManager.addMeshMaskToPolyhedronId((MeshMask)meshField, elm.getId());
                } else {
                    throw new UnsupportedOperationException("there is no equivalent id from gmsh mesh element to penelope id. The gmsh id is : " + gmshId);
                }
                if (localisation != MeshType.UNKNOWN) continue;
                localisation = this.evaluateLocalisation((MeshElement)elm);
                System.out.println("    Localisation: " + localisation);
            }
            System.out.println("    Nb meshElements: " + meshField.getNbMeshElements());
            int firstElmId = associatedIds.iterator().next();
            if (tmpDataSection.canDataBeInterpretedAsInt(firstElmId)) {
                MeshType meshType = meshField.getMeshType();
                VertexDataField dataField = null;
                if (meshType == MeshType.VERTEX) {
                    dataField = new VertexDataField(dataId, tmpDataSection.getStrings().get(0), "data from gmsh .msh file.", (MeshMask)meshField);
                } else if (meshType == MeshType.EDGE) {
                    dataField = new EdgeDataField(dataId, tmpDataSection.getStrings().get(0), "data from gmsh .msh file.", (MeshMask)meshField);
                } else if (meshType == MeshType.FACE) {
                    dataField = new FaceDataField(dataId, tmpDataSection.getStrings().get(0), "data from gmsh .msh file.", (MeshMask)meshField);
                } else if (meshType == MeshType.POLYHEDRON) {
                    dataField = new PolyhedronDataField(dataId, tmpDataSection.getStrings().get(0), "data from gmsh .msh file.", (MeshMask)meshField);
                } else {
                    throw new UnsupportedOperationException("mesh type is unknown. It is :" + meshType);
                }
                System.out.println("Data imported as integer....");
                IntDataArray dataArray = new IntDataArray(tmpDataSection.getNbData());
                for (int gmshId : associatedIds) {
                    int value = tmpDataSection.getDataAsInts(gmshId)[0];
                    dataArray.add((Object)value);
                }
                dataField.setDataArray((DataArray)dataArray);
                meshField.addDataField((DataField)dataField);
                dataSet.addDataField((DataField)dataField);
                System.out.println("    Nb data: " + dataField.getNbMeshElements());
            } else {
                FaceDataField dataField = new FaceDataField(dataId, tmpDataSection.getStrings().get(0), "data from gmsh .msh file.", (MeshMask)meshField);
                System.out.println("Data imported as float....");
                FloatDataArray dataArray = new FloatDataArray(tmpDataSection.getNbData());
                for (int gmshId : associatedIds) {
                    dataArray.add(Float.valueOf((float)tmpDataSection.getDataAsDoubles(gmshId)[0]));
                }
                dataField.setDataArray((DataArray)dataArray);
                meshField.addDataField((DataField)dataField);
                dataSet.addDataField((DataField)dataField);
                System.out.println("    Nb data: " + dataField.getNbMeshElements());
            }
            localisation = null;
        }
    }

    private MeshType evaluateLocalisation(MeshElement elm) {
        if (elm.getMeshType() == MeshType.VERTEX) {
            return MeshType.VERTEX;
        }
        if (elm.getMeshType() == MeshType.EDGE) {
            return MeshType.EDGE;
        }
        if (elm.getMeshType() == MeshType.FACE) {
            return MeshType.FACE;
        }
        if (elm.getMeshType() == MeshType.POLYHEDRON) {
            return MeshType.POLYHEDRON;
        }
        return MeshType.UNKNOWN;
    }
}

