/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.gmsh.geo.io;

import com.artenum.penelope.plugin.gmsh.geo.model.GeoCircle;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoEdge;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoGroup;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoLine;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoLineLoop;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoModel;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoPlaneSurface;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoPoint;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoRuledSurface;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoSurface;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoSurfaceLoop;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoVolume;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class GeoFileReader {
    private static final String KEY_GROUP = "Physical";
    private static final String KEY_POINT = "Point";
    private static final String KEY_LINE = "Line";
    private static final String KEY_CIRCLE = "Circle";
    private static final String KEY_LOOP = "Loop";
    private static final String KEY_PLANE = "Plane";
    private static final String KEY_SURFACE = "Surface";
    private static final String KEY_RULED = "Ruled";
    private static final String KEY_VOLUME = "Volume";
    private static final String KEY_COMMENT = "//";
    private GeoModel cadModel = new GeoModel();
    private String currentLine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoModel readFile(String filePath, boolean clearPreviousGroup) throws IOException {
        String elementSubString = "";
        String valueSubString = "";
        Object tmpPoint = null;
        if (clearPreviousGroup) {
            this.cadModel.getGeoGroups().clear();
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filePath));
            while ((this.currentLine = br.readLine()) != null) {
                elementSubString = this.currentLine.substring(0, this.currentLine.indexOf("="));
                valueSubString = this.currentLine.substring(this.currentLine.indexOf("=") + 1, this.currentLine.length());
                if (this.currentLine.startsWith(KEY_POINT)) {
                    this.cadModel.getPointsList().add(new GeoPoint(this.extractId(elementSubString), this.extractCoordinates(valueSubString), this.extractLocalResolution(valueSubString)));
                } else if (this.currentLine.startsWith(KEY_LINE)) {
                    if (this.currentLine.indexOf(KEY_LOOP) != -1) {
                        this.readLineLoops(elementSubString, valueSubString);
                    } else {
                        this.readLines(elementSubString, valueSubString);
                    }
                } else if (this.currentLine.startsWith(KEY_CIRCLE)) {
                    this.readCircles(elementSubString, valueSubString);
                } else if (this.currentLine.startsWith(KEY_PLANE)) {
                    this.readPlaneSurfaces(elementSubString, valueSubString);
                } else if (this.currentLine.startsWith(KEY_RULED)) {
                    this.readRuledSurfaces(elementSubString, valueSubString);
                } else if (this.currentLine.startsWith(KEY_SURFACE) && this.currentLine.indexOf(KEY_LOOP) != -1) {
                    this.readFaceLoops(elementSubString, valueSubString);
                }
                if (this.currentLine.indexOf(KEY_VOLUME) != -1) {
                    this.readVolumes(elementSubString, valueSubString);
                    continue;
                }
                if (!this.currentLine.startsWith(KEY_GROUP)) continue;
                this.currentLine = this.currentLine.substring(0, this.currentLine.indexOf("="));
                if (this.currentLine.indexOf(KEY_POINT) != -1) {
                    this.cadModel.getGeoGroups().add(new GeoGroup(this.extractId(this.currentLine), 0));
                    continue;
                }
                if (this.currentLine.indexOf(KEY_LINE) != -1) {
                    this.cadModel.getGeoGroups().add(new GeoGroup(this.extractId(this.currentLine), 1));
                    continue;
                }
                if (this.currentLine.indexOf(KEY_SURFACE) != -1) {
                    this.cadModel.getGeoGroups().add(new GeoGroup(this.extractId(this.currentLine), 2));
                    continue;
                }
                if (this.currentLine.indexOf(KEY_VOLUME) == -1) continue;
                this.cadModel.getGeoGroups().add(new GeoGroup(this.extractId(this.currentLine), 3));
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return this.cadModel;
    }

    public GeoModel getCADModel() {
        return this.cadModel;
    }

    public void setCADModel(GeoModel model) {
        this.cadModel = model;
    }

    public void readLineLoops(String elementSubString, String valueSubString) {
        GeoEdge tmpEdge = null;
        GeoLineLoop tmpLineLoop = new GeoLineLoop(this.extractId(elementSubString));
        ArrayList<Integer> ids = this.extractIdsList(valueSubString);
        for (int id : ids) {
            tmpEdge = this.getEdgeById(Math.abs(id));
            if (tmpEdge != null) {
                tmpLineLoop.addElementOnLoop(tmpEdge, id);
                continue;
            }
            System.err.println("Edge of id " + id + " not found!");
        }
        this.cadModel.getLineLoopsList().add(tmpLineLoop);
    }

    public void readFaceLoops(String elementSubString, String valueSubString) {
        GeoSurface tmpSurface = null;
        GeoSurfaceLoop tmpFaceLoop = new GeoSurfaceLoop(this.extractId(elementSubString));
        ArrayList<Integer> ids = this.extractIdsList(valueSubString);
        for (int id : ids) {
            tmpSurface = this.getSurfaceById(Math.abs(id));
            if (tmpSurface != null) {
                tmpFaceLoop.addElementOnLoop(tmpSurface);
                continue;
            }
            System.err.println("Surface of id " + id + " not found!");
        }
        this.cadModel.getSurfaceLoopsList().add(tmpFaceLoop);
    }

    public void readLines(String elementSubString, String valueSubString) {
        int id2 = -1;
        GeoPoint tmpPoint = null;
        GeoLine tmpLine = new GeoLine(this.extractId(elementSubString));
        ArrayList<Integer> ids = this.extractIdsList(valueSubString);
        for (int id2 : ids) {
            tmpPoint = this.getPointById(id2);
            if (tmpPoint != null) {
                tmpPoint.addEdgeOnNode(tmpLine);
                tmpLine.addPoint(tmpPoint);
                continue;
            }
            System.err.println("READLINES : Point of id " + id2 + " not found!");
        }
        this.cadModel.getLinesList().add(tmpLine);
    }

    public void readCircles(String elementSubString, String valueSubString) {
        int id2 = -1;
        GeoPoint tmpPoint = null;
        GeoCircle tmpCircle = new GeoCircle(this.extractId(elementSubString));
        ArrayList<Integer> ids = this.extractIdsList(valueSubString);
        for (int id2 : ids) {
            tmpPoint = this.getPointById(id2);
            if (tmpPoint != null) {
                tmpPoint.addEdgeOnNode(tmpCircle);
                tmpCircle.addPoint(tmpPoint);
                continue;
            }
            System.err.println("READCIRCLE : Point of id " + id2 + " not found!");
        }
        this.cadModel.getCirclesList().add(tmpCircle);
    }

    public void readPlaneSurfaces(String elementSubString, String valueSubString) {
        GeoLineLoop tmpLoop = null;
        GeoPlaneSurface tmpPlaneSurface = new GeoPlaneSurface(this.extractId(elementSubString));
        ArrayList<Integer> ids = this.extractIdsList(valueSubString);
        for (int id : ids) {
            tmpLoop = this.getLineLoopById(id);
            if (tmpLoop != null) {
                tmpPlaneSurface.addLineLoop(tmpLoop);
                continue;
            }
            System.err.println("Loop of id " + id + " not found!");
        }
        this.cadModel.getPlaneSurfacesList().add(tmpPlaneSurface);
    }

    public void readRuledSurfaces(String elementSubString, String valueSubString) {
        GeoLineLoop tmpLoop = null;
        GeoRuledSurface tmpRuledSurface = new GeoRuledSurface(this.extractId(elementSubString));
        ArrayList<Integer> ids = this.extractIdsList(valueSubString);
        for (int id : ids) {
            tmpLoop = this.getLineLoopById(id);
            if (tmpLoop != null) {
                tmpRuledSurface.addLineLoop(tmpLoop);
                continue;
            }
            System.err.println("Loop of id " + id + " not found!");
        }
        this.cadModel.getRuledSurfacesList().add(tmpRuledSurface);
    }

    public void readVolumes(String elementSubString, String valueSubString) {
        GeoSurfaceLoop tmpLoop = null;
        GeoVolume tmpVolume = new GeoVolume(this.extractId(elementSubString));
        ArrayList<Integer> ids = this.extractIdsList(valueSubString);
        for (int id : ids) {
            tmpLoop = this.getSurfaceLoopById(id);
            if (tmpLoop != null) {
                tmpVolume.addSurfaceLoop(tmpLoop);
                continue;
            }
            System.err.println("Loop of id " + id + " not found!");
        }
        this.cadModel.getVolumesList().add(tmpVolume);
    }

    private int extractId(String line) {
        int a = line.indexOf(40) + 1;
        int b = line.indexOf(41);
        return Integer.parseInt(line.substring(a, b).trim());
    }

    private double[] extractCoordinates(String line) {
        int a = line.indexOf(123) + 1;
        int b = line.indexOf(125);
        String subString = line.substring(a, b).trim();
        String[] splittedLine = subString.split(",");
        double[] coordinates = new double[]{Float.parseFloat(splittedLine[0]), Float.parseFloat(splittedLine[1]), Float.parseFloat(splittedLine[2])};
        return coordinates;
    }

    private double extractLocalResolution(String line) {
        int a = line.indexOf(123) + 1;
        int b = line.indexOf(125);
        String subString = line.substring(a, b).trim();
        String[] splittedLine = subString.split(",");
        return Float.parseFloat(splittedLine[3].trim());
    }

    private ArrayList<Integer> extractIdsList(String line) {
        int a = line.indexOf(123) + 1;
        int b = line.indexOf(125);
        String subString = line.substring(a, b).trim();
        String[] splittedLine = subString.split(",");
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < splittedLine.length; ++i) {
            ids.add(Integer.parseInt(splittedLine[i].trim()));
        }
        return ids;
    }

    private GeoPoint getPointById(int id) {
        GeoPoint currentPoint2 = null;
        for (GeoPoint currentPoint2 : this.cadModel.getPointsList()) {
            if (currentPoint2.getId() != id) continue;
            return currentPoint2;
        }
        return null;
    }

    private GeoEdge getEdgeById(int id) {
        Object var2_2 = null;
        for (GeoEdge geoEdge : this.cadModel.getLinesList()) {
            if (geoEdge.getId() != id) continue;
            return geoEdge;
        }
        for (GeoEdge geoEdge : this.cadModel.getCirclesList()) {
            if (geoEdge.getId() != id) continue;
            return geoEdge;
        }
        return null;
    }

    private GeoLineLoop getLineLoopById(int id) {
        GeoLineLoop currentLoop2 = null;
        for (GeoLineLoop currentLoop2 : this.cadModel.getLineLoopsList()) {
            if (currentLoop2.getId() != id) continue;
            return currentLoop2;
        }
        return null;
    }

    private GeoSurfaceLoop getSurfaceLoopById(int id) {
        GeoSurfaceLoop currentLoop2 = null;
        for (GeoSurfaceLoop currentLoop2 : this.cadModel.getSurfaceLoopsList()) {
            if (currentLoop2.getId() != id) continue;
            return currentLoop2;
        }
        return null;
    }

    private GeoSurface getSurfaceById(int id) {
        Object var2_2 = null;
        for (GeoSurface geoSurface : this.cadModel.getPlaneSurfacesList()) {
            if (geoSurface.getId() != id) continue;
            return geoSurface;
        }
        for (GeoSurface geoSurface : this.cadModel.getRuledSurfacesList()) {
            if (geoSurface.getId() != id) continue;
            return geoSurface;
        }
        return null;
    }

    public ArrayList<GeoGroup> getGeoGroups() {
        return this.cadModel.getGeoGroups();
    }
}

