/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.gmsh.mesh;

import com.artenum.penelope.field.DataFieldManager;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.MeshMask;
import com.artenum.penelope.mesh.interfaces.Polyhedron;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.plugin.gmsh.mesh.GMSHFilePart22;
import com.artenum.penelope.plugin.gmsh.mesh.GmshMeshMapping;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GmshExporter22 {
    private static final String NEWLINE = System.getProperty("line.separator");
    private final String filePath;
    private final Mesh mesh;
    private final GmshMeshMapping meshMapping;

    public GmshExporter22(Mesh mesh, GmshMeshMapping meshMapping, String filePath) {
        this.mesh = mesh;
        this.filePath = filePath;
        this.meshMapping = meshMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportAll() throws IOException {
        BufferedWriter fw = null;
        try {
            fw = new BufferedWriter(new FileWriter(this.filePath));
            this.exportHeader(fw);
            this.exportNodes(fw);
            this.exportMeshElements(fw);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    public void exportHeader(BufferedWriter fw) throws IOException {
        fw.write(GMSHFilePart22.HEADER_SECTION.getStartTag() + NEWLINE);
        fw.write("2.2 0 8\n");
        fw.write(GMSHFilePart22.HEADER_SECTION.getEndTag() + NEWLINE);
    }

    public void exportNodes(BufferedWriter fw) throws IOException {
        fw.write(GMSHFilePart22.NODE_SECTION.getStartTag() + NEWLINE);
        fw.write(Integer.toString(this.mesh.getNbVertices()) + NEWLINE);
        Iterator nodeElementIterator = this.mesh.getVertexIterator();
        Vertex nodeElement = null;
        while (nodeElementIterator.hasNext()) {
            nodeElement = (Vertex)nodeElementIterator.next();
            int penelopeId = nodeElement.getId();
            Integer gmshNodeId = this.meshMapping.getIdMapper().getGmshVertexId(penelopeId);
            fw.write(Integer.toString(gmshNodeId));
            fw.write(" ");
            fw.write(Double.toString(nodeElement.getPoint().getCoord()[0]));
            fw.write(" ");
            fw.write(Double.toString(nodeElement.getPoint().getCoord()[1]));
            fw.write(" ");
            fw.write(Double.toString(nodeElement.getPoint().getCoord()[2]));
            fw.write(NEWLINE);
        }
        fw.write(GMSHFilePart22.NODE_SECTION.getEndTag() + NEWLINE);
        fw.flush();
    }

    public void exportMeshElements(BufferedWriter fw) throws IOException {
        this.exportMeshElements(fw, true);
    }

    public void exportMeshElements(BufferedWriter fw, boolean closeSection) throws IOException {
        int j;
        int meshMaskIndex;
        List meshMasks;
        Integer meshElementType;
        int penelopeId;
        DataFieldManager dataFieldManager = this.mesh.getDataFieldManager();
        fw.write("$Elements\n");
        Map<Integer, Integer> edgeIdMap = this.meshMapping.getIdMapper().getEdgeIdMap();
        Map<Integer, Integer> faceIdMap = this.meshMapping.getIdMapper().getFaceIdMap();
        int vertexCount = 0;
        List vertexMeshMasks = dataFieldManager.getVertexMeshMasks();
        for (MeshMask meshMask : vertexMeshMasks) {
            vertexCount += meshMask.getMeshElementIds().length;
        }
        int edgeCount = 0;
        List edgeMeshMasks = dataFieldManager.getEdgeMeshMasks();
        for (MeshMask meshMask : edgeMeshMasks) {
            edgeCount += meshMask.getMeshElementIds().length;
        }
        int faceCount = 0;
        List faceMeshMasks = dataFieldManager.getFaceMeshMasks();
        for (MeshMask meshMask : faceMeshMasks) {
            faceCount += meshMask.getMeshElementIds().length;
        }
        int polyhedronCount = 0;
        List polyhedronMeshMasks = dataFieldManager.getPolyhedronMeshMasks();
        for (MeshMask meshMask : polyhedronMeshMasks) {
            polyhedronCount += meshMask.getMeshElementIds().length;
        }
        int nbMeshElements = vertexCount + edgeCount + faceCount + polyhedronCount;
        fw.write(Integer.toString(nbMeshElements));
        fw.write("\n");
        List<Vertex> vertexList = this.meshMapping.getPoint15List();
        for (Vertex vertex : vertexList) {
            int meshElementType2 = 15;
            Integer nbVerticesOnMeshElement = new Integer(1);
            Integer penelopeVertexId = vertex.getId();
            Integer gmshVertexId = this.meshMapping.getIdMapper().getGmshVertexId(penelopeVertexId);
            List meshMasks2 = dataFieldManager.getVertexMeshMasksForVertexId(vertex.getId());
            int meshMaskCount = meshMasks2.size();
            for (int meshMaskIndex2 = 0; meshMaskIndex2 < meshMaskCount; ++meshMaskIndex2) {
                fw.write(Integer.toString(gmshVertexId));
                fw.write(" ");
                fw.write(Integer.toString(15));
                fw.write(" ");
                fw.write(Integer.toString(1) + " ");
                fw.write(Integer.toString(((MeshMask)meshMasks2.get(meshMaskIndex2)).getId()) + " ");
                for (int j2 = 0; j2 < nbVerticesOnMeshElement; ++j2) {
                    penelopeId = vertex.getId();
                    int gmshId = this.meshMapping.getIdMapper().getGmshVertexId(penelopeId);
                    fw.write(Integer.toString(gmshId));
                    fw.write(" ");
                }
                fw.write("\n");
            }
        }
        for (Integer penelopeEdgeId : edgeIdMap.values()) {
            Edge edge = this.mesh.getEdgeById(penelopeEdgeId.intValue());
            meshElementType = 1;
            Integer gmshEdgeId = this.meshMapping.getIdMapper().getGmshEdgeId(penelopeEdgeId);
            meshMasks = dataFieldManager.getEdgeMeshMasksForEdgeId(edge.getId());
            int meshMaskCount = meshMasks.size();
            for (meshMaskIndex = 0; meshMaskIndex < meshMaskCount; ++meshMaskIndex) {
                fw.write(Integer.toString(gmshEdgeId));
                fw.write(" ");
                fw.write(Integer.toString(meshElementType));
                fw.write(" ");
                fw.write(Integer.toString(1) + " ");
                fw.write(Integer.toString(((MeshMask)meshMasks.get(meshMaskIndex)).getId()) + " ");
                for (j = 0; j < edge.getNbVertices(); ++j) {
                    Vertex localVertex = edge.getVertexAt(j);
                    penelopeId = localVertex.getId();
                    Integer gmshId = this.meshMapping.getIdMapper().getGmshVertexId(penelopeId);
                    fw.write(Integer.toString(gmshId));
                    fw.write(" ");
                }
                fw.write("\n");
            }
        }
        for (Integer penelopeFaceId : faceIdMap.values()) {
            Face face = this.mesh.getFaceById(penelopeFaceId.intValue());
            meshElementType = 2;
            Integer gmshFaceId = this.meshMapping.getIdMapper().getGmshFaceId(penelopeFaceId);
            meshMasks = dataFieldManager.getFaceMeshMasksForFaceId(face.getId());
            int meshMaskCount = meshMasks.size();
            for (meshMaskIndex = 0; meshMaskIndex < meshMaskCount; ++meshMaskIndex) {
                fw.write(Integer.toString(gmshFaceId));
                fw.write(" ");
                fw.write(Integer.toString(meshElementType));
                fw.write(" ");
                fw.write(Integer.toString(1) + " ");
                fw.write(Integer.toString(((MeshMask)meshMasks.get(meshMaskIndex)).getId()) + " ");
                for (j = 0; j < face.getNbVertices(); ++j) {
                    Vertex localVertex = face.getVertexAt(j);
                    penelopeId = localVertex.getId();
                    Integer gmshId = this.meshMapping.getIdMapper().getGmshVertexId(penelopeId);
                    fw.write(Integer.toString(gmshId));
                    fw.write(" ");
                }
                fw.write("\n");
            }
        }
        for (Polyhedron polyhedron : this.mesh.getPolyhedronList()) {
            Integer meshElementType3 = 4;
            Integer gmshPolyhedronId = this.meshMapping.getIdMapper().getGmshPolyhedronId(polyhedron.getId());
            List meshMasks3 = dataFieldManager.getPolyhedronMeshMasksForPolyhedronId(polyhedron.getId());
            int meshMaskCount = meshMasks3.size();
            for (int meshMaskIndex3 = 0; meshMaskIndex3 < meshMaskCount; ++meshMaskIndex3) {
                fw.write(Integer.toString(gmshPolyhedronId));
                fw.write(" ");
                fw.write(Integer.toString(meshElementType3));
                fw.write(" ");
                fw.write(Integer.toString(1) + " ");
                fw.write(Integer.toString(((MeshMask)meshMasks3.get(meshMaskIndex3)).getId()) + " ");
                for (int j3 = 0; j3 < polyhedron.getNbVertices(); ++j3) {
                    Vertex localVertex = polyhedron.getVertexAt(j3);
                    int penelopeId2 = localVertex.getId();
                    Integer gmshId = this.meshMapping.getIdMapper().getGmshVertexId(penelopeId2);
                    fw.write(Integer.toString(gmshId));
                    fw.write(" ");
                }
                fw.write("\n");
            }
        }
        if (closeSection) {
            fw.write("$EndElements\n");
        }
        fw.flush();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public GmshMeshMapping getMeshBuilder() {
        return this.meshMapping;
    }

    public Mesh getMesh() {
        return this.mesh;
    }
}

