/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.gmsh.mesh;

import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.MeshMask;
import com.artenum.penelope.mesh.interfaces.Polyhedron;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.plugin.gmsh.mesh.GeometryIdMapper;
import com.artenum.penelope.plugin.gmsh.mesh.GmshMeshMapping;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GmshMeshMappingHandMade
implements GmshMeshMapping {
    private final Mesh mesh;
    private final GeometryIdMapper idMapper;
    private final List<Vertex> point15List;

    public GmshMeshMappingHandMade(Mesh mesh) {
        this.mesh = mesh;
        this.idMapper = new GeometryIdMapper();
        this.point15List = new ArrayList<Vertex>();
        this.buildMapping();
        this.buildPoint15List();
    }

    private void buildPoint15List() {
        for (MeshMask vertexMeshMask : this.mesh.getDataFieldManager().getVertexMeshMasks()) {
            Iterator iterator = vertexMeshMask.getMeshElementIterator();
            while (iterator.hasNext()) {
                this.point15List.add((Vertex)iterator.next());
            }
        }
    }

    private void buildMapping() {
        this.buildVertexMapping();
        int maxEdgeIdInPenelope = this.buildEdgeMapping();
        int maxFaceIdInPenelope = this.buildFaceMapping(maxEdgeIdInPenelope + 1);
        this.buildPolyhedronMapping(maxFaceIdInPenelope + 1);
    }

    private void buildVertexMapping() {
        int vertexId = 1;
        Iterator vertexIterator = this.mesh.getVertexIterator();
        while (vertexIterator.hasNext()) {
            Vertex currentVertex = (Vertex)vertexIterator.next();
            int penelopeVertexId = currentVertex.getId();
            this.idMapper.addVertexIdMapping(vertexId, penelopeVertexId);
            ++vertexId;
        }
    }

    private int buildEdgeMapping() {
        int max = 0;
        Iterator edgeIterator = this.mesh.getEdgeIteratorStored();
        while (edgeIterator.hasNext()) {
            Edge currentEdge = (Edge)edgeIterator.next();
            int penelopeEdgeId = currentEdge.getId();
            if (penelopeEdgeId > max) {
                max = penelopeEdgeId;
            }
            this.idMapper.addEdgeIdMapping(penelopeEdgeId + 1, penelopeEdgeId);
        }
        return max;
    }

    private int buildFaceMapping(int maxEdgeIdInPenelope) {
        int max = 0;
        Iterator faceIterator = this.mesh.getFaceIteratorStored();
        while (faceIterator.hasNext()) {
            Face currentFace = (Face)faceIterator.next();
            int penelopeFaceId = currentFace.getId();
            int gmshFaceId = penelopeFaceId + maxEdgeIdInPenelope;
            if (gmshFaceId > max) {
                max = gmshFaceId;
            }
            this.idMapper.addFaceIdMapping(gmshFaceId + 1, penelopeFaceId);
        }
        return max;
    }

    private void buildPolyhedronMapping(int maxFaceIdInPenelope) {
        Iterator polyhedronIterator = this.mesh.getPolyhedronIterator();
        while (polyhedronIterator.hasNext()) {
            Polyhedron currentPolyhedron = (Polyhedron)polyhedronIterator.next();
            int penelopePolyhedronId = currentPolyhedron.getId();
            this.idMapper.addPolyhedronIdMapping(penelopePolyhedronId + maxFaceIdInPenelope + 1, penelopePolyhedronId);
        }
    }

    @Override
    public List<Vertex> getPoint15List() {
        return this.point15List;
    }

    @Override
    public GeometryIdMapper getIdMapper() {
        return this.idMapper;
    }
}

